/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.allmusic;

import java.io.*;
import java.net.*;
import java.util.*;

import com.bluedragontavern.albumgrabber.*;
import com.bluedragontavern.albumgrabber.Cache;
import com.bluedragontavern.albumgrabber.allmusic.pages.*;
import com.bluedragontavern.albumgrabber.util.*;

/**
 * Search for an artist picture
 *
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */
public class ArtistSearch
{
	public static final String OPT1_NAME = "1";
	public static final String OPT1_ALBUM = "2";
	public static final String OPT1_SONG = "3";
	public static final String OPT1_CLASSICAL_WORK = "55";

	/**
	 * Search for an artist picture
	 */
	public static Artist search(Artist artist)
		throws Exception
	{
		System.out.println("Searching for... " + artist.toStringSearch());
		artist = searchArtist(artist);

		//If artist found, get the bytes for the image
		if (artist.isFound())
		{
			artist.getImageBytes();
			System.out.println("Searched for: " + artist.getSearchArtistName() +
									 " and found: " + artist.getFoundArtistName());

			//Increment num artists sucessfully located
			Report.getInstance().incNumArtistsLocated();
		}
		else
		{
			System.out.println("Could not find artist: " +
									 artist.getSearchArtistName());
		}

		return artist;
	}

	/**
	 * Returns the best matching Artist
	 * @param album DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	private static Artist searchArtist(Artist artist)
		throws Exception
	{
		//First check the cache
		String html = Cache.getInstance().getArtistSearchResult(
			artist.getSearchArtistName());

		if (html == null)
		{
			String uriArtist = URLEncoder.encode(artist.getSearchArtistName(),
															 "UTF-8");

			Properties props = new Properties();
			props.put("P", "amg");
			props.put("SQL", uriArtist);
			props.put("OPT1", OPT1_NAME);
			props.put("Submit", "Go");

			URL url = new URL("http://www.allmusic.com/cg/amg.dll?p=amg");
			html = NetUtil.doPost(url, props, null);

			//Cache the artist search result for performance reasons
			Cache.getInstance().addArtistSearchResult(
				artist.getSearchArtistName(), html);
		}

		//Check if we got lucky(found artist on first try)
		ArtistPage artistPage = new ArtistPage(html);
		artist = artistPage.getArtist(artist);

		if (artist.isFound() == false)
		{
			//Perhaps we got multiple hits
			MultipleArtistsPage multipleArtistsPage = new MultipleArtistsPage(
				html);
			artist = multipleArtistsPage.getArtist(artist);
		}

		return artist;
	}

	//Test main
	public static void main(String[] argv)
	{
		try
		{
			search(new Artist(new File("Aerosmith")));
		}
		catch (Exception ex)
		{
			System.out.println(ex);
		}
	}
}
