/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber;

import java.util.*;

import java.awt.*;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 * @author unascribed
 * @version 1.0
 */
public abstract class ItemToGrab
{
	protected boolean found = false;
	protected Vector thumbnails = null;

	abstract public Image getImage()
		throws Exception;

	abstract public void writeImage()
		throws Exception;

	abstract public String toStringSearch();

	abstract public String toStringFound();

	/**
	 * Mark the item as being found
	 */
	public void found()
	{
		found = true;
	}

	/**
	 * Tells whether this item has been found on the internet or not
	 * @return DOCUMENT ME!
	 */
	public boolean isFound()
	{
		return found;
	}

	/**
	 * Returns whether it has thumbnails or not
	 * @return DOCUMENT ME!
	 */
	public boolean hasThumbnails()
	{
		if (thumbnails == null || thumbnails.size() == 0)
		{
			return false;
		}

		return true;
	}

	/**
	 * Set thumbnails
	 * @param foundArtistName DOCUMENT ME!
	 */
	public void setThumbnails(Vector thumbnails)
	{
		this.thumbnails = thumbnails;
	}

	/**
	 * Get the thumbnails
	 * @return DOCUMENT ME!
	 */
	public Vector getThumbnails()
	{
		return thumbnails;
	}
}