package retypar.gui;

import javax.swing.*;

/**
 * Shows the current progress of an ongoing conversion.
 *
 * @author Jens Heuser
 */
public class Walker extends JProgressBar implements Runnable{

    int width = 200;
    int height = 50;

    final float STEP = 1;

    /**
     * You must specify a <code>Box</code> the progress bar should appear in.
     * @param comp The target <code>Box</code>
     */
    public Walker(Box comp){
        comp.add(this);

        setStringPainted(true);
        setMinimum(0);
        setMaximum(100);
        setValue(0);
        setVisible(true);
    }


    /**
     * Monitors the value of {@link retypar.retypar#getProgress()} and updates the progress bar.
     */
    public void run(){
        int tmp = 0;
        setEnabled(true);
        setValue(retypar.retypar.getProgress());
        while(retypar.retypar.getProgress() < 100){
            try{
                if (tmp != retypar.retypar.getProgress()){
                    setValue(retypar.retypar.getProgress());
                    paint(getGraphics());
                    tmp = retypar.retypar.getProgress();
                }
                }catch(Exception e){
                retypar.retypar.logError("Progress monitor failure!");
            }
        }
        setValue(100);
        setEnabled(false);
    }

    /**
     * Sets the value to zero and starts watching the progress of conversion.
     * @see Walker#run
     */
    public void walk(){
        setValue(0);
        paint(this.getGraphics());
        Thread thread = new Thread(this);
        thread.start();
        //thread.setPriority(7);
    }
}
