package retypar.gui;

import retypar.retypar;
import retypar.converter.Converter;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.io.*;
import java.net.URL;
import java.util.LinkedList;
import java.util.ArrayList;

/**
 * <code>JFrame</code> that displays the options.
 */
public class OptionsFrame extends JFrame implements ActionListener, ItemListener{

    private Container c = getContentPane();
    private ButtonGroup bg = new ButtonGroup();
    private Box plaf;
    private JRadioButton plafMetal;
    private JRadioButton plafMotif;
    private JRadioButton plafWin;
    private JCheckBox checkUpd;

    private String plafStr = UIManager.getLookAndFeel().getClass().getName();

    private Box optionsBox;
    private Box algoBox;

    private JTextPane changeLogText;
    private JScrollPane clgScroll;
    private JComboBox onlineAl;
    private JComboBox offlineAl;
    private JButton deleteButton;
    private JButton installButton;

    private MainFrame parent;

    public OptionsFrame(MainFrame parent){
        this.parent = parent;
        setTitle(parent.l.pr("Options"));
        c.setLayout(new BorderLayout());

        optionsBox = Box.createVerticalBox();

        plafMetal = new JRadioButton("Metal");
        plafMetal.addActionListener(this);
        plafMetal.setActionCommand("metal");
        if (parent.plaf.substring(parent.plaf.lastIndexOf(".") + 1).startsWith("Metal")) plafMetal.setSelected(true);


        plafMotif = new JRadioButton("Motif");
        plafMotif.addActionListener(this);
        plafMotif.setActionCommand("motif");
        if (parent.plaf.substring(parent.plaf.lastIndexOf(".") + 1).startsWith("Motif")) plafMotif.setSelected(true);


        plafWin = new JRadioButton("Windows");
        plafWin.addActionListener(this);
        plafWin.setActionCommand("win");
        if (parent.plaf.substring(parent.plaf.lastIndexOf(".") + 1).startsWith("Windows")) plafWin.setSelected(true);


        bg.add(plafMetal);
        bg.add(plafMotif);
        bg.add(plafWin);

        plaf = Box.createHorizontalBox();
        plaf.add(plafMetal);
        plaf.add(plafMotif);
        plaf.add(plafWin);

        plaf.setBorder(new TitledBorder("\"Look-and-feel\":"));

        optionsBox.add(plaf);
        optionsBox.add(Box.createVerticalStrut(10));

        checkUpd = new JCheckBox(parent.l.pr("Check for new version on startup"));
        checkUpd.setSelected(retypar.checkUpd);
        checkUpd.addActionListener(this);
        checkUpd.setActionCommand("checkUpd");
        checkUpd.setAlignmentX(Component.CENTER_ALIGNMENT);

        optionsBox.add(checkUpd);
        optionsBox.add(Box.createHorizontalStrut(10));



        changeLogText = new JTextPane();
        changeLogText.setBackground(new Color(192, 192, 192));
        changeLogText.setText(getChangeLog());
        changeLogText.setCaretPosition(0);
        changeLogText.setEditable(false);
        changeLogText.setVisible(true);

        clgScroll = new JScrollPane();
        clgScroll.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        clgScroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        clgScroll.setViewportView(changeLogText);


        algoBox = Box.createVerticalBox();
        algoBox.setBorder(new TitledBorder(parent.l.pr("Algorithms")));

        JLabel onlineAlLabel = new JLabel(parent.l.pr("Online:"));
        onlineAl = new JComboBox();
        installButton = new JButton(parent.l.pr("Install"));
        installButton.addActionListener(this);
        installButton.setActionCommand("install");
        Box pop1Box = Box.createHorizontalBox();
        onlineAl.setAlignmentX(Component.LEFT_ALIGNMENT);

        fillOnlineAlgoCombo();

        pop1Box.add(onlineAl);
        pop1Box.add(installButton);
        algoBox.add(onlineAlLabel);
        algoBox.add(pop1Box);

        //onlineAl.setEnabled(false);
        //installButton.setEnabled(false);

        algoBox.add(Box.createHorizontalStrut(10));

        JLabel offlineAlLabel = new JLabel(parent.l.pr("Installed:"));
        offlineAl = new JComboBox();
        offlineAl.addItemListener(this);
        deleteButton = new JButton(parent.l.pr("Delete"));
        deleteButton.addActionListener(this);
        deleteButton.setActionCommand("delete");
        //if (retypar.runningInJar) deleteButton.setEnabled(false);
        Box pop2Box = Box.createHorizontalBox();
        offlineAl.setAlignmentX(Component.LEFT_ALIGNMENT);

        fillOfflineAlgoCombo();

        pop2Box.add(offlineAl);
        pop2Box.add(deleteButton);
        algoBox.add(offlineAlLabel);
        algoBox.add(pop2Box);


        optionsBox.add(algoBox);
        optionsBox.add(new JLabel(" "));
        c.add(optionsBox, BorderLayout.WEST);
        c.add(clgScroll, BorderLayout.CENTER);


        // Positionierung:
        int px, py, sx, sy;

        sx = 510;
        sy = 250;

        px = parent.getX() + ((parent.getWidth() - sx) / 2);
        py = parent.getY() + ((parent.getHeight() - sy) / 2);

        setBounds(px, py, sx, sy);

        setPlaf(parent.plaf);
        //setSize(510, 250);
        setResizable(false);
        setVisible(true);
    }


    public void actionPerformed(ActionEvent e){
        if (e.getActionCommand().equals("win")) setPlaf("win");
        if (e.getActionCommand().equals("metal")) setPlaf("metal");
        if (e.getActionCommand().equals("motif")) setPlaf("motif");

        if (e.getActionCommand().equals("checkUpd")) writeINI();
        if (e.getActionCommand().equals("delete")) deleteAlgo((Converter)offlineAl.getSelectedItem());
        if (e.getActionCommand().equals("install")) installAlgo((OnlineAlEntry)onlineAl.getSelectedItem());
    }


    public void itemStateChanged(ItemEvent e){
        deleteButton.setEnabled(true);
        if (offlineAl.getItemCount() == 0) return;

        if (((Converter)offlineAl.getSelectedItem()).getShortName().equals("mr")) deleteButton.setEnabled(false);
        if (((Converter)offlineAl.getSelectedItem()).getShortName().equals("ns")) deleteButton.setEnabled(false);
    }


    private void fillOnlineAlgoCombo(){
        onlineAl.removeAllItems();
        LinkedList ls = retypar.getOnlineAlgos();
        OnlineAlEntry oal;

        for (int i = 0; i < ls.size(); i += 2){
            oal = new OnlineAlEntry((String)ls.get(i), (String)ls.get(i + 1));
            onlineAl.addItem(oal);
        }
        if (onlineAl.getItemCount() == 0) installButton.setEnabled(false);
            else installButton.setEnabled(true);
        onlineAl.invalidate();
    }


    private void fillOfflineAlgoCombo(){
        offlineAl.removeAllItems();
        for (int i = 0; i < retypar.converters.size(); i++)
            offlineAl.addItem(retypar.converters.get(i));

        offlineAl.invalidate();
    }


    private void deleteAlgo(Converter algo){
        retypar.deleteAlgo(algo);
        offlineAl.removeItem(algo);
        offlineAl.invalidate();
        parent.renderCombo.removeItem(algo);
        parent.renderCombo.invalidate();
    }


    private void installAlgo(OnlineAlEntry algo){
        if (algo == null) return;
        if (retypar.downloadAndInstallAlgo(algo.getLocation()) == true){
            fillOnlineAlgoCombo();
            fillOfflineAlgoCombo();
            parent.fillRenderCombo();
            }
        else {
            String errors = "\n\nError:\n" + retypar.printErrors();
            popUpError(parent.l.pr("Error installing Algorithm!"), "Could not install the algorithm.\nCheck Your internet connection and permissions or space." + errors);
        }
    }


    private void popUpError(String title, String message){
        JOptionPane.showMessageDialog(this, message, title, JOptionPane.ERROR_MESSAGE);
    }


    private void setPlaf(String plaf){
        UIManager.LookAndFeelInfo[] plafInfo = UIManager.getInstalledLookAndFeels();

        if (plaf.indexOf(".") > -1) plaf = plaf.substring(plaf.lastIndexOf(".") + 1);

        for (int i = 0; i < plafInfo.length; i++){
            if (plafInfo[i].getName().toLowerCase().indexOf(plaf) > -1) {
                try{
                    UIManager.setLookAndFeel(plafInfo[i].getClassName());
                    SwingUtilities.updateComponentTreeUI(parent);
                    SwingUtilities.updateComponentTreeUI(this);
                    plafStr = plafInfo[i].getClassName();
                    retypar.plaf = plafStr;
                    parent.setPlaf();
                    writeINI();
                    break;
                }catch(Exception e){
                    retypar.logError("Failure setting LookAndFeel");
                }
            }
        }
    }


    private String getChangeLog(){
        String changeLog = "";
        String tmp = "";

        try{
            InputStream in = getClass().getResourceAsStream("/changelog.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
                while ((tmp = br.readLine()) != null)
                    changeLog += tmp + "\n";
            in.close();
        }catch(Exception e){
            retypar.logError("Error reading changelog");
        }
        return changeLog;
    }


    private void writeINI(){
        retypar.plaf = plafStr;
        retypar.checkUpd = checkUpd.isSelected();
        retypar.writeINI();
    }
}
