/*
 * Decompiled with CFR 0.152.
 */
package retypar;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import heuser.simpleLogger.SimpleLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import retypar.AlgoClassLoader;
import retypar.batchMode;
import retypar.converter.Converter;
import retypar.gui.MainFrame;
import thirdParty.GifEncoder.AnimatedGifEncoder;

public class retypar
extends SimpleLogger {
    public static final String version = "0.9.4";
    public static final String updateURL = "http://retypar.sourceforge.net/download/";
    public static final String appName = "retypar";
    public static final String homepage = "http://www.retypar.de.vu";
    public static final String email = "retypar.image2ascii@gmail.com";
    private static final String textVideoVersion = "1";
    private static final String algosOnline = "http://retypar.sourceforge.net/download/algorithms/";
    private static String algoSubDir = "retypar/converter/";
    public static String lastPath = "";
    private static MainFrame mF;
    public static int fontSize;
    public static String font;
    public static Font[] fonts;
    public static String[] availableGraphicalExportFormats;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_HTML = 1;
    public static final int TYPE_JPEG = 2;
    public static final int TYPE_TVID = 3;
    public static final int TYPE_ANSI = 4;
    public static final int TYPE_GIF = 5;
    public static final String[] EXTENSIONS_TYPE_JPEG;
    public static final String[] EXTENSIONS_TYPE_GIF;
    public static final String[] EXTENSIONS_TYPE_HTML;
    public static final String[] EXTENSIONS_TYPE_TEXT;
    public static final String[] EXTENSIONS_TYPE_TVID;
    public static final String[] EXTENSIONS_TYPE_ANSI;
    public static final int GIF_MAX_QUALITY_IN_BITS = 24;
    private static File input;
    private static File output;
    public static LinkedList converters;
    private static Calendar now;
    private static String duration;
    public static Converter activeConverter;
    public static boolean checkUpd;
    public static String plaf;
    public static String lang;
    public static LinkedList markedForDeletion;
    public static boolean runningInJar;
    private static boolean importingExternal;
    private static String fileSeparator;
    public static String basedir;
    static /* synthetic */ Class class$retypar$retypar;
    static /* synthetic */ Class class$retypar$converter$Converter;

    public static void main(String[] stringArray) {
        retypar.setErrorPrefix("*** ");
        retypar.setConsoleOutput(true);
        retypar.setBasedir();
        retypar.readINI();
        converters = retypar.loadConverters();
        converters.addAll(retypar.importConverters());
        if (stringArray.length > 0) {
            retypar.runInBatchMode(stringArray);
        } else {
            retypar.logMsg("\n--- retypar 0.9.4 (Jens Heuser, 2005) ---\n");
            retypar.logMsg("No arguments given. Starting GUI...\n");
            mF = new MainFrame();
        }
    }

    private static void setBasedir() {
        basedir = (class$retypar$retypar == null ? (class$retypar$retypar = retypar.class$("retypar.retypar")) : class$retypar$retypar).getResource("retypar.class").toString();
        if (basedir.startsWith("jar:")) {
            basedir = basedir.substring(10, basedir.length());
            basedir = basedir.substring(0, basedir.lastIndexOf("retypar_0.9.4.jar!"));
        }
        if (basedir.startsWith("file:")) {
            basedir = basedir.substring(6, basedir.length());
            basedir = basedir.substring(0, basedir.lastIndexOf("retypar/retypar.class"));
        }
    }

    protected static LinkedList loadConverters() {
        return retypar.loadConverters(null);
    }

    protected static LinkedList loadConverters(File file) {
        File file2;
        String string;
        LinkedList<Converter> linkedList = new LinkedList<Converter>();
        if (file == null) {
            URL uRL = (class$retypar$retypar == null ? (class$retypar$retypar = retypar.class$("retypar.retypar")) : class$retypar$retypar).getResource("/retypar/converter/");
            string = uRL.toString();
            if (string.startsWith("jar:")) {
                string = uRL.toString().substring(4);
            }
            file2 = new File(string.substring(6));
        } else {
            file2 = file;
            string = file.getAbsolutePath();
        }
        String[] stringArray = !file2.isDirectory() && !file2.isFile() ? retypar.scanJar(file2) : file2.list();
        if (stringArray == null) {
            return linkedList;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".class")) continue;
            AlgoClassLoader algoClassLoader = new AlgoClassLoader();
            try {
                Converter converter;
                if (!importingExternal || !runningInJar) {
                    converter = (Converter)(class$retypar$retypar == null ? retypar.class$("retypar.retypar") : class$retypar$retypar).getClassLoader().loadClass("retypar.converter." + stringArray[i].substring(0, stringArray[i].length() - 6)).newInstance();
                } else {
                    converter = (Converter)algoClassLoader.loadClass(string + System.getProperty("file.separator") + stringArray[i]).newInstance();
                    String string2 = "";
                    string2 = converter.broughtPackage();
                    if (string2 != null) {
                        File file3 = new File(string + System.getProperty("file.separator") + string2);
                        String[] stringArray2 = file3.list();
                        for (int j = 0; j < stringArray2.length; ++j) {
                            if (!stringArray[j].endsWith(".class")) continue;
                            algoClassLoader.loadClass(string + System.getProperty("file.separator") + string2 + System.getProperty("file.separator") + stringArray2[j]).newInstance();
                        }
                    }
                }
                if (!(class$retypar$converter$Converter == null ? retypar.class$("retypar.converter.Converter") : class$retypar$converter$Converter).isInstance(converter)) continue;
                linkedList.add(converter);
                continue;
            }
            catch (Exception exception) {
                if (stringArray[i].equals("Converter.class") || stringArray[i].equals("FontRenderer.class") || stringArray[i].equals("ImageProcessor.class") || stringArray[i].equals("Parameter.class") || stringArray[i].equals("Letter.class")) continue;
                retypar.logError("Could not load algorithm file '" + stringArray[i] + "': " + exception.toString());
            }
        }
        return linkedList;
    }

    private static LinkedList importConverters() {
        importingExternal = true;
        LinkedList linkedList = new LinkedList();
        if (!runningInJar) {
            return linkedList;
        }
        String string = "";
        string = (class$retypar$retypar == null ? (class$retypar$retypar = retypar.class$("retypar.retypar")) : class$retypar$retypar).getResource("retypar.class").toString();
        string = string.substring(0, string.lastIndexOf("retypar_0.9.4.jar"));
        string = string + algoSubDir;
        string = string.startsWith("jar:") ? string.substring(10) : string.substring(6);
        File file = new File(string);
        file.mkdir();
        linkedList = retypar.loadConverters(file);
        importingExternal = false;
        return linkedList;
    }

    private static String[] scanJar(File file) {
        if (file.getAbsolutePath().indexOf(".jar!") == -1) {
            return null;
        }
        runningInJar = true;
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = "";
        try {
            if (System.getProperty("os.name").toLowerCase().indexOf("linux") > -1) {
                string = "/";
            }
            JarFile jarFile = new JarFile(string + file.getParentFile().getParent().replaceAll("!", ""));
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2 = ((Object)enumeration.nextElement()).toString();
                if (string2.indexOf("retypar/converter/") <= -1 || string2.substring(string2.lastIndexOf(47)).length() < 2) continue;
                linkedList.add(string2.substring(string2.lastIndexOf(47) + 1));
            }
        }
        catch (Exception exception) {
            retypar.logError("Error accessing jar " + file.getPath() + "! Stacktrace:");
        }
        String[] stringArray = new String[linkedList.size()];
        int n = 0;
        while (!linkedList.isEmpty()) {
            stringArray[n] = (String)linkedList.removeLast();
            ++n;
        }
        return stringArray;
    }

    private static void deleteDirectory(File file) {
        int n;
        File[] fileArray = file.listFiles();
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n].isDirectory()) {
                retypar.deleteDirectory(fileArray[n]);
                fileArray[n].delete();
            }
            fileArray[n].delete();
        }
        n = file.delete() ? 1 : 0;
    }

    public static void deleteAlgo(Converter converter) {
        String string = "";
        try {
            string = converter.broughtPackage();
        }
        catch (Exception exception) {
            string = "";
        }
        String string2 = converter.getClass().getName();
        string2 = string2.replace('.', fileSeparator.charAt(0));
        File file = new File(basedir + fileSeparator + string2 + ".class");
        if (file.exists()) {
            file.delete();
        }
        if (string.length() > 0) {
            String string3 = basedir + appName + fileSeparator + "converter" + fileSeparator + string;
            retypar.deleteDirectory(new File(string3));
        }
        converters.remove(converter);
        converters = retypar.loadConverters();
        converters.addAll(retypar.importConverters());
    }

    public static boolean hasEnoughMemoryToConvert(int n) {
        return (double)Runtime.getRuntime().freeMemory() >= (double)(n * 3) * 1.5;
    }

    public static BufferedImage convertImage(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Color color, int n, int n2, int n3, int n4, Converter converter, int n5) {
        Image image;
        try {
            image = ImageIO.read(file);
        }
        catch (Exception exception) {
            retypar.logError("Could not read image '" + file.getPath() + "'!");
            return null;
        }
        if (n2 != 0) {
            image = retypar.adjustBrightness(image, n2);
        }
        if (n3 != 0) {
            image = retypar.adjustContrast(image, n3);
        }
        if (n4 != 0) {
            image = retypar.adjustSaturation(image, n4);
        }
        converter.prepare(image, bl, bl2, bl3, bl4, bl5, color, n, n5);
        activeConverter = converter;
        retypar.startTimer();
        if (activeConverter.returnsImage()) {
            return activeConverter.getImage();
        }
        return retypar.drawImageFromASCII(activeConverter.getASCII(), activeConverter.getColors(), file, bl5, color, n);
    }

    public static int getProgress() {
        try {
            if (!activeConverter.monitorsProgess()) {
                return 101;
            }
        }
        catch (Exception exception) {
            return 101;
        }
        return activeConverter.getProgress();
    }

    private static void startTimer() {
        now = GregorianCalendar.getInstance();
    }

    public static void stopTimer() {
        Calendar calendar = GregorianCalendar.getInstance();
        long l = now.getTimeInMillis();
        long l2 = calendar.getTimeInMillis();
        long l3 = l2 - l;
        String string = "" + l3 / 60000L;
        if (string.length() == 1) {
            string = "0" + string;
        }
        duration = string;
        string = "" + l3 / 1000L;
        if (string.length() == 1) {
            string = "0" + string;
        }
        duration = duration + ":" + string;
        string = "" + l3 % 1000L;
        if (string.length() == 1) {
            string = "0" + string;
        }
        duration = duration + ":" + string;
    }

    public static String getDuration() {
        return duration;
    }

    private static BufferedImage drawImageFromASCII(String[] stringArray, Color[][] colorArray, File file, boolean bl, Color color, int n) {
        int n2;
        int n3;
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(file);
            n3 = bufferedImage.getWidth();
            n2 = bufferedImage.getHeight();
        }
        catch (Exception exception) {
            retypar.logError("Error drawing BufferedImage from ASCII.");
            return null;
        }
        int n4 = bl ? 1 : 10;
        if (n != 100) {
            n3 = n3 * n / 100;
            n2 = n2 * n / 100;
        }
        n3 = n3 / fontSize * fontSize;
        n2 = n2 / fontSize * fontSize;
        bufferedImage = new BufferedImage(n3, n2, n4);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(color);
        graphics2D.clearRect(0, 0, n3, n2);
        graphics2D.setFont(new Font(font, 0, fontSize + 1));
        graphics2D.setColor(Color.BLACK);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length(); ++j) {
                if (bl) {
                    graphics2D.setColor(colorArray[i][j]);
                }
                graphics2D.drawString("" + stringArray[i].charAt(j), j * fontSize, i * fontSize + fontSize);
            }
        }
        return bufferedImage;
    }

    public static Image adjustBrightness(Image image, int n) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        bufferedImage.getGraphics().drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
        n = (int)(255.0f * ((float)n / 100.0f));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                n5 = bufferedImage.getRGB(i, j);
                n2 = (n5 & 0xFF0000) >> 16;
                n3 = (n5 & 0xFF00) >> 8;
                n4 = n5 & 0xFF;
                n3 += n;
                n4 += n;
                if ((n2 += n) > 255) {
                    n2 = 255;
                }
                if (n3 > 255) {
                    n3 = 255;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                n5 = n2 << 16 & 0xFF0000 | n3 << 8 & 0xFF00 | n4 & 0xFF;
                bufferedImage.setRGB(i, j, n5);
            }
        }
        return bufferedImage;
    }

    public static Image adjustContrast(Image image, int n) {
        int n2;
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        bufferedImage.getGraphics().drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
        int[] nArray = new int[256];
        n = (int)(255.0f * ((float)n / 100.0f));
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < 128; ++n2) {
            nArray[n2] = n2 - Math.abs(128 - n2) * n / 255;
        }
        for (n2 = 128; n2 < 256; ++n2) {
            nArray[n2] = n2 + Math.abs(128 - n2) * n / 255;
        }
        for (n2 = 0; n2 < bufferedImage.getWidth(); ++n2) {
            for (int i = 0; i < bufferedImage.getHeight(); ++i) {
                n6 = bufferedImage.getRGB(n2, i);
                n3 = (n6 & 0xFF0000) >> 16;
                n4 = (n6 & 0xFF00) >> 8;
                n5 = n6 & 0xFF;
                n3 = nArray[n3];
                n4 = nArray[n4];
                n5 = nArray[n5];
                if (n3 > 255) {
                    n3 = 255;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                if (n5 > 255) {
                    n5 = 255;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                n6 = n3 << 16 & 0xFF0000 | n4 << 8 & 0xFF00 | n5 & 0xFF;
                bufferedImage.setRGB(n2, i, n6);
            }
        }
        return bufferedImage;
    }

    public static Image adjustSaturation(Image image, int n) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        bufferedImage.getGraphics().drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
        n = (int)(255.0f * ((float)n / 100.0f));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                n5 = bufferedImage.getRGB(i, j);
                n2 = (n5 & 0xFF0000) >> 16;
                n3 = (n5 & 0xFF00) >> 8;
                n4 = n5 & 0xFF;
                n2 = (int)((float)n2 + (float)n2 * ((float)n / 100.0f));
                n3 = (int)((float)n3 + (float)n3 * ((float)n / 100.0f));
                n4 = (int)((float)n4 + (float)n4 * ((float)n / 100.0f));
                if (n2 > 255) {
                    n2 = 255;
                }
                if (n3 > 255) {
                    n3 = 255;
                }
                if (n4 > 255) {
                    n4 = 255;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                n5 = n2 << 16 & 0xFF0000 | n3 << 8 & 0xFF00 | n4 & 0xFF;
                bufferedImage.setRGB(i, j, n5);
            }
        }
        return bufferedImage;
    }

    public static boolean storeImage(File file, BufferedImage bufferedImage, int n, int n2, boolean bl, Color color, String[] stringArray, Color[][] colorArray, boolean bl2) {
        switch (n2) {
            case 2: {
                return retypar.storeJPEG(retypar.checkExtension(file, EXTENSIONS_TYPE_JPEG), bufferedImage, n);
            }
            case 5: {
                return retypar.storeGIF(retypar.checkExtension(file, EXTENSIONS_TYPE_GIF), bufferedImage, n, bl2 ? color : null);
            }
            case 1: {
                return retypar.storeHTML(retypar.checkExtension(file, EXTENSIONS_TYPE_HTML), bl, color, stringArray, colorArray);
            }
            case 0: {
                return retypar.storeTEXT(retypar.checkExtension(file, EXTENSIONS_TYPE_TEXT), stringArray);
            }
            case 3: {
                return retypar.storeTextVideo(retypar.checkExtension(file, EXTENSIONS_TYPE_TVID), stringArray);
            }
            case 4: {
                return retypar.storeANSI(retypar.checkExtension(file, EXTENSIONS_TYPE_ANSI), color, stringArray, colorArray);
            }
        }
        return false;
    }

    private static boolean storeJPEG(File file, BufferedImage bufferedImage, int n) {
        if (file == null) {
            return true;
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            if (!retypar.streamJPEG(bufferedOutputStream, bufferedImage, n)) {
                throw new Exception();
            }
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            retypar.logError("Output file error: " + exception.toString());
            return false;
        }
        return true;
    }

    public static boolean streamJPEG(OutputStream outputStream, BufferedImage bufferedImage, int n) {
        try {
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            jPEGEncodeParam.setQuality((float)(100 - n) / 100.0f, false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
        }
        catch (Exception exception) {
            retypar.logError("Error encoding JPEG: " + exception.toString());
            return false;
        }
        return true;
    }

    private static boolean storeGIF(File file, BufferedImage bufferedImage, int n, Color color) {
        if (file == null) {
            return true;
        }
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            if (!retypar.streamGIF(bufferedOutputStream, bufferedImage, n, color)) {
                throw new Exception();
            }
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            retypar.logError("Output file error: " + exception.toString());
            return false;
        }
        return true;
    }

    public static boolean streamGIF(OutputStream outputStream, BufferedImage bufferedImage, int n, Color color) {
        AnimatedGifEncoder animatedGifEncoder = new AnimatedGifEncoder();
        float f = 0.24f * (float)n;
        System.out.println("quality = " + f + ", int = " + (int)f);
        animatedGifEncoder.setTransparent(color);
        animatedGifEncoder.setCompression((int)f);
        animatedGifEncoder.start(outputStream);
        animatedGifEncoder.addFrame(bufferedImage);
        return true;
    }

    private static boolean storeANSI(File file, Color color, String[] stringArray, Color[][] colorArray) {
        if (file == null) {
            return true;
        }
        int n = 0;
        int n2 = 0;
        String string = retypar.getSAUCEstring(file.getName());
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("\u001b[" + retypar.getANSIcolor(color, false) + "m");
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray[i].length(); ++j) {
                    n = retypar.getANSIcolor(colorArray[i][j], true);
                    if (n != n2) {
                        fileWriter.write("\u001b[" + n + "m" + stringArray[i].charAt(j));
                    } else {
                        fileWriter.write(stringArray[i].charAt(j));
                    }
                    n2 = n;
                }
                fileWriter.write("\r\n");
            }
            fileWriter.write(26);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            retypar.logError("output file error: " + exception.toString());
            return false;
        }
        return true;
    }

    private static String getSAUCEstring(String string) {
        int n;
        Calendar calendar = Calendar.getInstance();
        String string2 = "";
        String string3 = "SAUCE";
        String string4 = "00";
        String string5 = "retypar 0.9.4";
        String string6 = "www.retypar.de.vu";
        String string7 = calendar.get(1) + "" + (calendar.get(2) + 1 < 10 ? "0" + (calendar.get(2) + 1) : "" + (calendar.get(2) + 1)) + (calendar.get(5) + 1 < 10 ? "0" + calendar.get(5) : "" + calendar.get(5));
        String string8 = "0000";
        String string9 = textVideoVersion;
        String string10 = textVideoVersion;
        String string11 = "00";
        String string12 = "00";
        String string13 = "00";
        String string14 = "00";
        String string15 = "0";
        String string16 = "0";
        if (string.length() > 35) {
            string = string.substring(0, 34);
        }
        for (n = 0; n < 35 && string.length() != 35; ++n) {
            string = string + " ";
        }
        if (string5.length() > 20) {
            string5 = string5.substring(0, 19);
        }
        for (n = 0; n < 20 && string5.length() != 20; ++n) {
            string5 = string5 + " ";
        }
        if (string6.length() > 20) {
            string6 = string6.substring(0, 19);
        }
        for (n = 0; n < 20 && string6.length() != 20; ++n) {
            string6 = string6 + " ";
        }
        string2 = string3 + string4 + string + string5 + string6 + string7 + string8 + string9 + string10 + string11 + string12 + string13 + string14 + string15 + string16;
        while (string2.length() < 128) {
            string2 = string2 + " ";
        }
        return string2;
    }

    private static int getANSIcolor(Color color, boolean bl) {
        Color color2 = Color.BLACK;
        Color color3 = Color.RED;
        Color color4 = Color.GREEN;
        Color color5 = Color.YELLOW;
        Color color6 = Color.BLUE;
        Color color7 = Color.MAGENTA;
        Color color8 = Color.CYAN;
        Color color9 = Color.WHITE;
        int n = 30;
        int n2 = 31;
        int n3 = 32;
        int n4 = 33;
        int n5 = 34;
        int n6 = 35;
        int n7 = 36;
        int n8 = 37;
        Color[] colorArray = new Color[]{color2, color3, color4, color5, color6, color7, color8, color9};
        int[] nArray = new int[]{n, n2, n3, n4, n5, n6, n7, n8};
        long l = 0L;
        l += (long)Math.abs(color2.getRed() - color.getRed());
        l += (long)Math.abs(color2.getGreen() - color.getGreen());
        l += (long)Math.abs(color2.getBlue() - color.getBlue());
        int n9 = n;
        int n10 = 0;
        for (int i = 0; i < colorArray.length; ++i) {
            n10 = Math.abs(colorArray[i].getRed() - color.getRed());
            n10 += Math.abs(colorArray[i].getGreen() - color.getGreen());
            if ((long)(n10 += Math.abs(colorArray[i].getBlue() - color.getBlue())) >= l) continue;
            l = n10;
            n9 = nArray[i];
        }
        if (!bl) {
            n9 += 10;
        }
        return n9;
    }

    private static boolean storeHTML(File file, boolean bl, Color color, String[] stringArray, Color[][] colorArray) {
        if (file == null) {
            return true;
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("<HTML><BODY bgcolor=#" + retypar.getHexColor(color) + ">\r\n");
            fileWriter.write("<DIV STYLE=\"line-height: 75%;\">\r\n");
            fileWriter.write("<tt>\r\n");
            for (int i = 0; i < stringArray.length; ++i) {
                for (int j = 0; j < stringArray[i].length(); ++j) {
                    if (bl) {
                        fileWriter.write("<font color=#" + retypar.getHexColor(colorArray[i][j]) + ">");
                    }
                    fileWriter.write(stringArray[i].charAt(j));
                    if (!bl) continue;
                    fileWriter.write("</font>");
                }
                fileWriter.write("<BR>\r\n");
            }
            fileWriter.write("</tt>\r\n</DIV>\r\n</BODY>\r\n</HTML>");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            retypar.logError("Output file error: " + exception.toString());
            return false;
        }
        return true;
    }

    private static String getHexColor(Color color) {
        String string = Integer.toHexString(color.getRed());
        String string2 = Integer.toHexString(color.getGreen());
        String string3 = Integer.toHexString(color.getBlue());
        return retypar.fillLeadZeros(string) + retypar.fillLeadZeros(string2) + retypar.fillLeadZeros(string3);
    }

    private static String fillLeadZeros(String string) {
        if (string.length() == 0) {
            string = "00";
        }
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private static boolean storeTEXT(File file, String[] stringArray) {
        if (file == null) {
            return true;
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            for (int i = 0; i < stringArray.length; ++i) {
                fileWriter.write(stringArray[i]);
                fileWriter.write("\r\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            retypar.logError("Output file error: " + exception.toString());
            return false;
        }
        return true;
    }

    private static boolean storeTextVideo(File file, String[] stringArray) {
        boolean bl;
        if (file == null) {
            retypar.logError("Output file is null! Skipping.");
            return true;
        }
        int n = 0;
        boolean bl2 = bl = !file.exists();
        if (output == null) {
            output = file;
            bl = true;
        } else {
            file = output;
        }
        try {
            FileWriter fileWriter = new FileWriter(file, !bl);
            if (bl) {
                fileWriter.write("retypar text video version 1\r\n" + stringArray.length + "\r\n");
            }
            while (n < stringArray.length) {
                fileWriter.write(stringArray[n]);
                fileWriter.write("\r\n");
                ++n;
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            retypar.logError("Output file error: " + exception.toString());
            return false;
        }
        return true;
    }

    public static File checkExtension(File file, String[] stringArray) {
        String string = "";
        String string2 = System.getProperty("file.separator");
        boolean bl = false;
        try {
            string = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - file.getName().length());
        }
        catch (Exception exception) {
            retypar.logError("Error referencing file " + file.getAbsolutePath());
            return null;
        }
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (file.getName().toLowerCase().endsWith("." + stringArray[i])) {
                bl2 = true;
            }
            if (!stringArray[i].toLowerCase().equals("txv")) continue;
            bl = true;
        }
        if (!bl2) {
            file = file.getName().lastIndexOf(".") == -1 ? new File(string + string2 + file.getName() + "." + stringArray[0]) : new File(string + string2 + file.getName().substring(0, file.getName().lastIndexOf(".")) + "." + stringArray[0]);
        }
        if (file.exists() && !bl) {
            retypar.logError("File already exists! Do not supply one filename when converting multiple files.");
            return null;
        }
        return file;
    }

    public static void readINI() {
        String string = "";
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File("retypar.ini")));
            lang = bufferedReader.readLine();
            plaf = bufferedReader.readLine();
            string = bufferedReader.readLine();
            lastPath = bufferedReader.readLine();
            while ((string2 = bufferedReader.readLine()) != null) {
                markedForDeletion.add(string2);
            }
            bufferedReader.close();
            checkUpd = !string.equals("n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lang == null) {
            lang = "";
        }
        if (lastPath == null) {
            lastPath = "";
        }
    }

    public static void writeINI() {
        String string = "y";
        if (!checkUpd) {
            string = "n";
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File("retypar.ini")));
            bufferedWriter.write(lang);
            bufferedWriter.newLine();
            bufferedWriter.write(plaf);
            bufferedWriter.newLine();
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            bufferedWriter.write(lastPath);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            retypar.logError("writeINI:\n");
            exception.printStackTrace();
        }
    }

    private static LinkedList getAllOnlineAlgos() {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            String string;
            URL uRL = new URL("http://retypar.sourceforge.net/download/algorithms/algos.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                linkedList.add(string);
                linkedList.add(bufferedReader.readLine());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return linkedList;
    }

    public static LinkedList getOnlineAlgos() {
        LinkedList linkedList = retypar.getAllOnlineAlgos();
        for (int i = 0; i < linkedList.size(); ++i) {
            String string = (String)linkedList.get(i);
            for (int j = 0; j < converters.size(); ++j) {
                if (!((Object)((Converter)converters.get(j))).toString().equals(string)) continue;
                linkedList.removeFirst();
                linkedList.removeFirst();
            }
            ++i;
        }
        return linkedList;
    }

    public static boolean downloadAndInstallAlgo(String string) {
        File file = retypar.downloadAlgo(string);
        if (file == null) {
            return false;
        }
        if (!retypar.installAlgo(file)) {
            return false;
        }
        converters = retypar.loadConverters();
        converters.addAll(retypar.importConverters());
        return true;
    }

    private static File downloadAlgo(String string) {
        File file;
        try {
            int n;
            URL uRL = new URL(algosOnline + string);
            URLConnection uRLConnection = uRL.openConnection();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            file = new File(basedir + string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            fileOutputStream.close();
        }
        catch (Exception exception) {
            retypar.logError("Error downloading new algorithm.");
            return null;
        }
        return file;
    }

    private static boolean installAlgo(File file) {
        Object object;
        ZipFile zipFile;
        LinkedList<File> linkedList = new LinkedList<File>();
        linkedList.add(file);
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            retypar.logError("Cannot access zip file " + file.toString());
            retypar.deleteFiles(linkedList);
            return false;
        }
        if (basedir.length() == 0) {
            retypar.logError("You should never see this...");
            return false;
        }
        String string = basedir + algoSubDir;
        if (!new File(string).exists() && !((File)(object = new File(string))).mkdirs()) {
            retypar.logError("Cannot create directory '" + string + "'.");
            return false;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            try {
                int n;
                ZipEntry zipEntry = enumeration.nextElement();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                object = new BufferedInputStream(inputStream);
                File file2 = new File(string + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    if (!file2.mkdir()) {
                        retypar.logError("Cannot create directory " + file2.getName());
                        zipFile.close();
                        retypar.deleteFiles(linkedList);
                        return false;
                    }
                    linkedList.add(file2);
                    continue;
                }
                if (!file2.createNewFile()) {
                    retypar.logError("Cannot create file " + file2.getName());
                    zipFile.close();
                    retypar.deleteFiles(linkedList);
                    return false;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                while ((n = ((BufferedInputStream)object).read()) != -1) {
                    fileOutputStream.write(n);
                }
                fileOutputStream.close();
                linkedList.add(file2);
            }
            catch (Exception exception) {
                retypar.logError("Zip file maybe corrupt: " + exception.toString());
                retypar.deleteFiles(linkedList);
                return false;
            }
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {
            retypar.logError("Cannot close zip file!");
            retypar.deleteFiles(linkedList);
            return false;
        }
        file.delete();
        return true;
    }

    private static void deleteFiles(LinkedList linkedList) {
        int n;
        File[] fileArray = new File[linkedList.size()];
        for (n = 0; n < linkedList.size(); ++n) {
            fileArray[n] = (File)linkedList.get(n);
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (fileArray[n].isFile()) {
                fileArray[n].delete();
                continue;
            }
            if (!fileArray[n].isDirectory() || fileArray[n].getName().equals("converter")) continue;
            retypar.deleteDirectory(fileArray[n]);
        }
    }

    public static void setFont(String string) {
        font = string;
    }

    public static void setFontSize(int n) {
        fontSize = n;
    }

    private static void runInBatchMode(String[] stringArray) {
        new batchMode(stringArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        fontSize = 10;
        font = "DialogInput";
        fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        availableGraphicalExportFormats = new String[]{"JPEG", "GIF"};
        EXTENSIONS_TYPE_JPEG = new String[]{"jpg", "jpeg"};
        EXTENSIONS_TYPE_GIF = new String[]{"gif"};
        EXTENSIONS_TYPE_HTML = new String[]{"htm", "html"};
        EXTENSIONS_TYPE_TEXT = new String[]{"txt"};
        EXTENSIONS_TYPE_TVID = new String[]{"txv"};
        EXTENSIONS_TYPE_ANSI = new String[]{"ans"};
        converters = new LinkedList();
        duration = "--:--:---";
        checkUpd = true;
        markedForDeletion = new LinkedList();
        runningInJar = false;
        importingExternal = false;
        fileSeparator = System.getProperty("file.separator");
        basedir = "";
    }
}

