/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.DashInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.GraphicsInterface;
import graphic.PointDouble;
import graphic.PointG;
import graphic.PolygonInterface;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitivePolygon
extends GraphicPrimitive {
    private int nPoints;
    private boolean isFilled;
    private int dashStyle;
    private PolygonInterface p;
    int N_POINTS = 5;
    private int xmin;
    private int ymin;
    private int width;
    private int height;
    private float w;

    @Override
    public int getControlPointNumber() {
        return this.nPoints + 2;
    }

    public PrimitivePolygon(String f, int size) {
        this.isFilled = false;
        this.nPoints = 0;
        this.p = null;
        this.initPrimitive(this.N_POINTS, f, size);
    }

    public PrimitivePolygon(boolean f, int layer, int dashSt, String font, int size) {
        this.p = null;
        this.initPrimitive(this.N_POINTS, font, size);
        this.nPoints = 0;
        this.isFilled = f;
        this.dashStyle = dashSt;
        this.setLayer(layer);
    }

    public void removePoint(int x, int y, double tolerance) {
        int i;
        if (this.nPoints <= 3) {
            return;
        }
        double min_distance = GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, x, y);
        int sel_i = -1;
        for (i = 1; i < this.nPoints; ++i) {
            double distance = GeometricDistances.pointToPoint(this.virtualPoint[i].x, this.virtualPoint[i].y, x, y);
            if (!(distance < min_distance)) continue;
            min_distance = distance;
            sel_i = i;
        }
        if (min_distance <= tolerance) {
            --this.nPoints;
            for (i = 0; i < this.nPoints; ++i) {
                if (i >= sel_i) {
                    this.virtualPoint[i].x = this.virtualPoint[i + 1].x;
                    this.virtualPoint[i].y = this.virtualPoint[i + 1].y;
                }
                this.changed = true;
            }
        }
    }

    public void addPointClosest(int px, int py) {
        int[] xp = new int[this.N_POINTS];
        int[] yp = new int[this.N_POINTS];
        for (int k = 0; k < this.nPoints; ++k) {
            xp[k] = this.virtualPoint[k].x;
            yp[k] = this.virtualPoint[k].y;
        }
        int distance = (int)Math.sqrt((px - xp[0]) * (px - xp[0]) + (py - yp[0]) * (py - yp[0]));
        int minv = 0;
        for (int i = 0; i < this.nPoints; ++i) {
            int d;
            int j = i;
            if (j == this.nPoints - 1) {
                j = -1;
            }
            if ((d = GeometricDistances.pointToSegment(xp[i], yp[i], xp[j + 1], yp[j + 1], px, py)) >= distance) continue;
            distance = d;
            minv = j + 1;
        }
        this.addPoint(px, py);
        for (int i = this.nPoints - 1; i > minv; --i) {
            this.virtualPoint[i].x = this.virtualPoint[i - 1].x;
            this.virtualPoint[i].y = this.virtualPoint[i - 1].y;
        }
        this.virtualPoint[minv].x = px;
        this.virtualPoint[minv].y = py;
        this.changed = true;
    }

    public void addPoint(int x, int y) {
        if (this.nPoints + 2 >= this.N_POINTS) {
            int i;
            int o_n = this.N_POINTS;
            this.N_POINTS += 10;
            PointG[] nv = new PointG[this.N_POINTS];
            for (i = 0; i < o_n; ++i) {
                nv[i] = this.virtualPoint[i];
            }
            while (i < this.N_POINTS) {
                nv[i] = new PointG();
                ++i;
            }
            this.virtualPoint = nv;
        }
        this.virtualPoint[this.nPoints].x = x;
        ++this.nPoints;
        this.virtualPoint[this.nPoints].y = y;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y + 10;
        this.changed = true;
    }

    public void createPolygon(MapCoordinates coordSys, GraphicsInterface g) {
        this.xmin = Integer.MAX_VALUE;
        this.ymin = Integer.MAX_VALUE;
        int xmax = -2147483647;
        int ymax = -2147483647;
        this.p = g.createPolygon();
        this.p.reset();
        for (int j = 0; j < this.nPoints; ++j) {
            int x = coordSys.mapX(this.virtualPoint[j].x, this.virtualPoint[j].y);
            int y = coordSys.mapY(this.virtualPoint[j].x, this.virtualPoint[j].y);
            this.p.addPoint(x, y);
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y <= ymax) continue;
            ymax = y;
        }
        this.width = xmax - this.xmin;
        this.height = ymax - this.ymin;
    }

    @Override
    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.createPolygon(coordSys, g);
            this.w = (float)(Globals.lineWidth * coordSys.getXMagnitude());
            if (this.w < 0.5f) {
                this.w = 0.5f;
            }
        }
        if (!g.hitClip(this.xmin, this.ymin, this.width, this.height)) {
            return;
        }
        g.applyStroke(this.w, this.dashStyle);
        if (this.isFilled && this.width >= 2 && this.height >= 2) {
            g.fillPolygon(this.p);
        }
        g.drawPolygon(this.p);
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("PP") || tokens[0].equals("PV")) {
            if (N < 6) {
                IOException E = new IOException("bad arguments on PP/PV");
                throw E;
            }
            int j = 1;
            int i = 0;
            int x1 = 0;
            int y1 = 0;
            while (!(j >= N - 1 || j + 1 < N - 1 && tokens[j + 1].equals("FCJ"))) {
                x1 = Integer.parseInt(tokens[j++]);
                y1 = Integer.parseInt(tokens[j++]);
                ++i;
                this.addPoint(x1, y1);
            }
            this.nPoints = i;
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            if (N > j) {
                this.parseLayer(tokens[j++]);
                if (j < N - 1 && tokens[j++].equals("FCJ")) {
                    this.dashStyle = Integer.parseInt(tokens[j++]);
                    if (this.dashStyle >= 5) {
                        this.dashStyle = 4;
                    }
                    if (this.dashStyle < 0) {
                        this.dashStyle = 0;
                    }
                }
            }
            this.isFilled = tokens[0].equals("PP");
        } else {
            IOException E = new IOException("PP/PV: Invalid primitive:" + tokens[0] + " programming error?");
            throw E;
        }
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = super.getControls();
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = this.isFilled;
        pd.description = Globals.messages.getString("ctrl_filled");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new DashInfo(this.dashStyle);
        pd.description = Globals.messages.getString("ctrl_dash_style");
        pd.isExtension = true;
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = super.setControls(v);
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Boolean) {
            this.isFilled = (Boolean)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof DashInfo) {
            this.dashStyle = ((DashInfo)pd.parameter).style;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        if (this.dashStyle >= 5) {
            this.dashStyle = 4;
        }
        if (this.dashStyle < 0) {
            this.dashStyle = 0;
        }
        return i;
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        int[] xp = new int[this.N_POINTS];
        int[] yp = new int[this.N_POINTS];
        for (int k = 0; k < this.nPoints; ++k) {
            xp[k] = this.virtualPoint[k].x;
            yp[k] = this.virtualPoint[k].y;
        }
        if (this.isFilled && GeometricDistances.pointInPolygon(xp, yp, this.nPoints, px, py)) {
            return 1;
        }
        int distance = (int)Math.sqrt((px - xp[0]) * (px - xp[0]) + (py - yp[0]) * (py - yp[0]));
        for (int i = 0; i < this.nPoints; ++i) {
            int d;
            int j = i;
            if (j == this.nPoints - 1) {
                j = -1;
            }
            if ((d = GeometricDistances.pointToSegment(xp[i], yp[i], xp[j + 1], yp[j + 1], px, py)) >= distance) continue;
            distance = d;
        }
        return distance;
    }

    @Override
    public String toString(boolean extensions) {
        StringBuffer temp = new StringBuffer(25);
        if (this.isFilled) {
            temp.append("PP ");
        } else {
            temp.append("PV ");
        }
        for (int i = 0; i < this.nPoints; ++i) {
            temp.append(this.virtualPoint[i].x);
            temp.append(" ");
            temp.append(this.virtualPoint[i].y);
            temp.append(" ");
        }
        temp.append(this.getLayer());
        temp.append("\n");
        String cmd = temp.toString();
        if (extensions && (this.dashStyle > 0 || this.hasName() || this.hasValue())) {
            String text = "0";
            if (this.name.length() != 0 || this.value.length() != 0) {
                text = "1";
            }
            cmd = cmd + "FCJ " + this.dashStyle + " " + text + "\n";
        }
        cmd = cmd + this.saveText(false);
        return cmd;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        PointDouble[] vertices = new PointDouble[this.nPoints];
        for (int i = 0; i < this.nPoints; ++i) {
            vertices[i] = new PointDouble();
            vertices[i].x = cs.mapX(this.virtualPoint[i].x, this.virtualPoint[i].y);
            vertices[i].y = cs.mapY(this.virtualPoint[i].x, this.virtualPoint[i].y);
        }
        exp.exportPolygon(vertices, this.nPoints, this.isFilled, this.getLayer(), this.dashStyle, Globals.lineWidth * cs.getXMagnitude());
    }

    @Override
    public int getNameVirtualPointNumber() {
        return this.nPoints;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return this.nPoints + 1;
    }
}

