/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import dialogs.LayerInfo;
import dialogs.ParameterDescription;
import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.FontG;
import graphic.GraphicsInterface;
import graphic.PointG;
import graphic.nil.GraphicsNull;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrimitiveAdvText
extends GraphicPrimitive {
    private String txt = "";
    private int six = 3;
    private int siy = 4;
    private int sty;
    private int o = 0;
    private String fontName = "Courier New";
    private boolean recalcSize;
    static final int TEXT_BOLD = 1;
    static final int TEXT_MIRRORED = 4;
    static final int TEXT_ITALIC = 2;
    static final int N_POINTS = 1;
    private int xaSCI;
    private int yaSCI;
    private int orientationSCI;
    private int hSCI;
    private int thSCI;
    private int wSCI;
    private int[] xpSCI;
    private int[] ypSCI;
    private boolean mirror;
    private int orientation;
    private int h;
    private int th;
    private int w;
    private double ymagnitude;
    private boolean coordmirroring;
    private int x1;
    private int y1;
    private int xa;
    private int ya;
    private int qq;
    private double xyfactor;
    private double si;
    private double co;
    private boolean needsStretching;

    @Override
    public int getControlPointNumber() {
        return 1;
    }

    public PrimitiveAdvText() {
        this.virtualPoint = new PointG[1];
        for (int i = 0; i < 1; ++i) {
            this.virtualPoint[i] = new PointG();
        }
        this.changed = true;
        this.recalcSize = true;
    }

    public PrimitiveAdvText(int x, int y, int sx, int sy, String fn, int or, int st, String t, int l) {
        this();
        this.virtualPoint[0] = new PointG(x, y);
        this.six = sx;
        this.siy = sy;
        this.sty = st;
        this.txt = t;
        this.o = or;
        this.fontName = fn;
        this.setLayer(l);
        this.changed = true;
        this.recalcSize = true;
    }

    @Override
    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        if (this.txt.length() == 0) {
            return;
        }
        this.changed = true;
        this.ymagnitude = coordSys.getYMagnitude();
        this.coordmirroring = coordSys.getMirror();
        if (this.changed) {
            this.changed = false;
            this.mirror = false;
            this.recalcSize = true;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.xa = coordSys.mapX(this.x1, this.y1);
            this.ya = coordSys.mapY(this.x1, this.y1);
            g.setFont(this.fontName, (int)((double)(this.six * 12) * coordSys.getYMagnitude() / 7.0 + 0.5), (this.sty & 2) != 0, (this.sty & 1) != 0);
            this.orientation = this.o;
            this.mirror = false;
            if ((this.sty & 4) != 0) {
                this.mirror = !this.mirror;
                this.orientation = -this.orientation;
            }
            if (this.six == 0 || this.siy == 0) {
                this.siy = 10;
                this.six = 7;
            }
            this.orientation -= coordSys.getOrientation() * 90;
            if (this.coordmirroring) {
                this.mirror = !this.mirror;
                this.orientation = -this.orientation;
            }
            this.h = g.getFontAscent();
            this.th = this.h + g.getFontDescent();
            this.w = g.getStringWidth(this.txt);
            this.xyfactor = 1.0;
            this.needsStretching = false;
            if (this.siy / this.six != 1) {
                this.xyfactor = (double)this.siy / (double)this.six * 22.0 / 40.0;
                this.needsStretching = true;
            }
            if (this.orientation == 0) {
                if (this.mirror) {
                    coordSys.trackPoint(this.xa - this.w, this.ya);
                    coordSys.trackPoint(this.xa, this.ya + (int)((double)this.th * this.xyfactor));
                } else {
                    coordSys.trackPoint(this.xa + this.w, this.ya);
                    coordSys.trackPoint(this.xa, this.ya + (int)((double)this.h * this.xyfactor));
                }
            } else {
                if (this.mirror) {
                    this.si = Math.sin(Math.toRadians(-this.orientation));
                    this.co = Math.cos(Math.toRadians(-this.orientation));
                } else {
                    this.si = Math.sin(Math.toRadians(this.orientation));
                    this.co = Math.cos(Math.toRadians(this.orientation));
                }
                double bbx1 = this.xa;
                double bby1 = this.ya;
                double bbx2 = (double)this.xa + (double)this.th * this.si;
                double bby2 = (double)this.ya + (double)this.th * this.co * this.xyfactor;
                double bbx3 = (double)this.xa + (double)this.w * this.co + (double)this.th * this.si;
                double bby3 = (double)this.ya + ((double)this.th * this.co - (double)this.w * this.si) * this.xyfactor;
                double bbx4 = (double)this.xa + (double)this.w * this.co;
                double bby4 = (double)this.ya - (double)this.w * this.si * this.xyfactor;
                if (this.mirror) {
                    bbx2 = (double)this.xa - (double)this.th * this.si;
                    bbx3 = (double)this.xa - (double)this.w * this.co - (double)this.th * this.si;
                    bbx4 = (double)this.xa - (double)this.w * this.co;
                }
                coordSys.trackPoint((int)bbx1, (int)bby1);
                coordSys.trackPoint((int)bbx2, (int)bby2);
                coordSys.trackPoint((int)bbx3, (int)bby3);
                coordSys.trackPoint((int)bbx4, (int)bby4);
            }
            this.qq = (int)((double)this.ya / this.xyfactor);
        }
        g.drawAdvText(this.xyfactor, this.xa, this.ya, this.qq, this.h, this.w, this.h, this.needsStretching, this.orientation, this.mirror, this.txt);
    }

    @Override
    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        this.recalcSize = true;
        if (tokens[0].equals("TY")) {
            if (N < 9) {
                IOException E = new IOException("bad arguments on TY");
                throw E;
            }
            this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.siy = Integer.parseInt(tokens[3]);
            this.six = Integer.parseInt(tokens[4]);
            this.o = Integer.parseInt(tokens[5]);
            this.sty = Integer.parseInt(tokens[6]);
            this.parseLayer(tokens[7]);
            int j = 8;
            StringBuffer txtb = new StringBuffer();
            this.fontName = tokens[8].equals("*") ? "Courier New" : tokens[8].replaceAll("\\+\\+", " ");
            while (j < N - 1) {
                txtb.append(tokens[++j]);
                if (j >= N - 1) continue;
                txtb.append(" ");
            }
            this.txt = txtb.toString();
        } else if (tokens[0].equals("TE")) {
            if (N < 4) {
                IOException E = new IOException("bad arguments on TE");
                throw E;
            }
            this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.six = 3;
            this.siy = 4;
            this.o = 0;
            this.sty = 0;
            int j = 2;
            this.txt = "";
            while (j < N - 1) {
                this.txt = this.txt + tokens[++j] + " ";
            }
            this.parseLayer("0");
        } else {
            IOException E = new IOException("Invalid primitive: programming error?");
            throw E;
        }
    }

    @Override
    public int getDistanceToPoint(int px, int py) {
        if (this.changed || this.recalcSize) {
            if (this.changed) {
                GraphicsNull gSCI = new GraphicsNull();
                gSCI.setFont(this.fontName, (int)((double)this.six * 12.0 / 7.0 + 0.5), (this.sty & 2) != 0, (this.sty & 1) != 0);
                this.hSCI = gSCI.getFontAscent();
                this.thSCI = this.hSCI + gSCI.getFontDescent();
                this.wSCI = gSCI.getStringWidth(this.txt);
            } else {
                this.hSCI = (int)((double)this.h / this.ymagnitude);
                this.thSCI = (int)((double)this.th / this.ymagnitude);
                this.wSCI = (int)((double)this.w / this.ymagnitude);
            }
            this.recalcSize = false;
            this.xaSCI = this.virtualPoint[0].x;
            this.yaSCI = this.virtualPoint[0].y;
            this.orientationSCI = this.o;
            if (this.siy / this.six != 1) {
                this.hSCI = (int)Math.round((double)this.hSCI * ((double)this.siy * 22.0 / 40.0 / (double)this.six));
                this.thSCI = (int)Math.round((double)this.thSCI * ((double)this.siy * 22.0 / 40.0 / (double)this.six));
            }
            if ((this.sty & 4) != 0) {
                this.orientationSCI = -this.orientationSCI;
                this.wSCI = -this.wSCI;
            }
            if (this.coordmirroring) {
                this.wSCI = -this.wSCI;
            }
            if (this.orientationSCI != 0) {
                double si = Math.sin(Math.toRadians(this.orientation));
                double co = Math.cos(Math.toRadians(this.orientation));
                this.xpSCI = new int[4];
                this.ypSCI = new int[4];
                this.xpSCI[0] = this.xaSCI;
                this.ypSCI[0] = this.yaSCI;
                this.xpSCI[1] = (int)((double)this.xaSCI + (double)this.thSCI * si);
                this.ypSCI[1] = (int)((double)this.yaSCI + (double)this.thSCI * co);
                this.xpSCI[2] = (int)((double)this.xaSCI + (double)this.thSCI * si + (double)this.wSCI * co);
                this.ypSCI[2] = (int)((double)this.yaSCI + (double)this.thSCI * co - (double)this.wSCI * si);
                this.xpSCI[3] = (int)((double)this.xaSCI + (double)this.wSCI * co);
                this.ypSCI[3] = (int)((double)this.yaSCI - (double)this.wSCI * si);
            }
        }
        if (this.orientationSCI == 0 ? GeometricDistances.pointInRectangle(Math.min(this.xaSCI, this.xaSCI + this.wSCI), this.yaSCI, Math.abs(this.wSCI), this.thSCI, px, py) : GeometricDistances.pointInPolygon(this.xpSCI, this.ypSCI, 4, px, py)) {
            return 0;
        }
        return 0x3FFFFFFF;
    }

    @Override
    public Vector<ParameterDescription> getControls() {
        Vector<ParameterDescription> v = new Vector<ParameterDescription>(10);
        ParameterDescription pd = new ParameterDescription();
        pd.parameter = this.txt;
        pd.description = Globals.messages.getString("ctrl_text");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new LayerInfo(this.getLayer());
        pd.description = Globals.messages.getString("ctrl_layer");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.six;
        pd.description = Globals.messages.getString("ctrl_xsize");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.siy;
        pd.description = Globals.messages.getString("ctrl_ysize");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = this.o;
        pd.description = Globals.messages.getString("ctrl_angle");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = (this.sty & 4) != 0;
        pd.description = Globals.messages.getString("ctrl_mirror");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = (this.sty & 2) != 0;
        pd.description = Globals.messages.getString("ctrl_italic");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = (this.sty & 1) != 0;
        pd.description = Globals.messages.getString("ctrl_boldface");
        v.add(pd);
        pd = new ParameterDescription();
        pd.parameter = new FontG(this.fontName);
        pd.description = Globals.messages.getString("ctrl_font");
        v.add(pd);
        return v;
    }

    @Override
    public int setControls(Vector<ParameterDescription> v) {
        int i = 0;
        this.changed = true;
        this.recalcSize = true;
        ParameterDescription pd = v.get(i);
        ++i;
        if (pd.parameter instanceof String) {
            this.txt = (String)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof LayerInfo) {
            this.setLayer(((LayerInfo)pd.parameter).getLayer());
        } else {
            System.out.println("Warning: unexpected parameter!");
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.six = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.siy = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i);
        ++i;
        if (pd.parameter instanceof Integer) {
            this.o = (Integer)pd.parameter;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.sty = (Boolean)pd.parameter != false ? this.sty | 4 : this.sty & 0xFFFFFFFB;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.sty = (Boolean)pd.parameter != false ? this.sty | 2 : this.sty & 0xFFFFFFFD;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof Boolean) {
            this.sty = (Boolean)pd.parameter != false ? this.sty | 1 : this.sty & 0xFFFFFFFE;
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        pd = v.get(i++);
        if (pd.parameter instanceof FontG) {
            this.fontName = ((FontG)pd.parameter).getFamily();
        } else {
            System.out.println("Warning: unexpected parameter!" + pd);
        }
        return i;
    }

    @Override
    public void rotatePrimitive(boolean bc, int ix, int iy) {
        boolean bCounterClockWise = bc;
        super.rotatePrimitive(bCounterClockWise, ix, iy);
        int po = this.o / 90;
        if ((this.sty & 4) != 0) {
            boolean bl = bCounterClockWise = !bCounterClockWise;
        }
        if (bCounterClockWise) {
            ++po;
            po %= 4;
        } else {
            po = (po + 3) % 4;
        }
        this.o = 90 * po;
    }

    @Override
    public void mirrorPrimitive(int xPos) {
        super.mirrorPrimitive(xPos);
        this.sty ^= 4;
        this.changed = true;
        this.recalcSize = true;
    }

    @Override
    public String toString(boolean extensions) {
        CharSequence s;
        String subsFont;
        if (this.fontName.equals("Courier New")) {
            subsFont = "*";
        } else {
            s = new StringBuffer("");
            for (int i = 0; i < this.fontName.length(); ++i) {
                if (this.fontName.charAt(i) == ' ') {
                    s.append("++");
                    continue;
                }
                s.append(this.fontName.charAt(i));
            }
            subsFont = s.toString();
        }
        s = "TY " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.siy + " " + this.six + " " + this.o + " " + this.sty + " " + this.getLayer() + " " + subsFont + " " + this.txt + "\n";
        return s;
    }

    @Override
    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        int resulting_o = this.o - cs.getOrientation() * 90;
        exp.exportAdvText(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), (int)Math.abs(cs.mapXr(this.six, this.six) - cs.mapXr(0.0, 0.0)), (int)Math.abs(cs.mapYr(this.siy, this.siy) - cs.mapYr(0.0, 0.0)), this.fontName, (this.sty & 1) != 0, (this.sty & 4) != 0, (this.sty & 2) != 0, resulting_o, this.getLayer(), this.txt);
    }

    @Override
    public int getNameVirtualPointNumber() {
        return -1;
    }

    @Override
    public int getValueVirtualPointNumber() {
        return -1;
    }
}

