/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.fidocadj.librarymodel.Category;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.librarymodel.LibraryModel;
import net.sourceforge.fidocadj.librarymodel.event.AddEvent;
import net.sourceforge.fidocadj.librarymodel.event.KeyChangeEvent;
import net.sourceforge.fidocadj.librarymodel.event.LibraryListener;
import net.sourceforge.fidocadj.librarymodel.event.RemoveEvent;
import net.sourceforge.fidocadj.librarymodel.event.RenameEvent;
import net.sourceforge.fidocadj.macropicker.model.AbstractMacroTreeNode;
import net.sourceforge.fidocadj.macropicker.model.MacroTreeNode;
import net.sourceforge.fidocadj.macropicker.model.NodeFilterInterface;
import primitives.MacroDesc;

public class MacroTreeModel
implements TreeModel,
LibraryListener {
    public static final int ROOT = 0;
    public static final int LIBRARY = 1;
    public static final int CATEGORY = 2;
    public static final int MACRO = 3;
    private RootNode rootNode;
    private final LibraryModel libraryModel;
    private final List<TreeModelListener> listeners;
    private HashMap<TreePath, AbstractMacroTreeNode> libraryNodeMap;
    private String filterWord;

    public MacroTreeModel(LibraryModel libraryModel) {
        this.libraryModel = libraryModel;
        this.listeners = new ArrayList<TreeModelListener>();
        this.createMap();
        this.synchronizeTree(null);
        this.fireChanged();
    }

    public void setFilterWord(String filterWord) {
        this.filterWord = filterWord;
        if (filterWord == null || filterWord.length() == 0) {
            this.synchronizeTree(null);
            this.filterWord = null;
            this.fireChanged();
        } else {
            final String chainedWord = filterWord.toLowerCase(new Locale("en"));
            this.synchronizeTree(new NodeFilterInterface(){

                public boolean accept(MacroTreeNode node) {
                    String[] words = chainedWord.trim().split(" ");
                    int matched = 0;
                    for (String word : words) {
                        if (0 <= node.toString().toLowerCase().indexOf(word)) {
                            ++matched;
                            continue;
                        }
                        if (word.length() != 0) continue;
                        ++matched;
                    }
                    return words.length == matched;
                }
            });
            this.fireChanged();
        }
    }

    private void resetSearchMode() {
        this.filterWord = null;
    }

    public boolean isSearchMode() {
        return this.filterWord != null;
    }

    private void createMap() {
        this.libraryNodeMap = new HashMap();
    }

    public int getNodeType(TreePath path) {
        if (path == null) {
            return -1;
        }
        Object o = path.getLastPathComponent();
        if (o instanceof RootNode) {
            return 0;
        }
        if (o instanceof LibraryNode) {
            return 1;
        }
        if (o instanceof CategoryNode) {
            return 2;
        }
        if (o instanceof MacroNode) {
            return 3;
        }
        return -1;
    }

    public String getFilterWord() {
        return this.filterWord;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public Object getChild(Object parent, int index) {
        return ((TreeNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        return ((TreeNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        return ((TreeNode)parent).getIndex((TreeNode)child);
    }

    public Object getRoot() {
        return this.rootNode;
    }

    public boolean isLeaf(Object node) {
        return ((TreeNode)node).isLeaf();
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public MacroDesc getMacro(TreePath path) {
        if (path == null) {
            return null;
        }
        Object o = this.getPathComponentAt(path, 3);
        if (o instanceof MacroNode) {
            return ((MacroNode)o).getMacro();
        }
        return null;
    }

    public Category getCategory(TreePath path) {
        if (path == null) {
            return null;
        }
        Object o = this.getPathComponentAt(path, 2);
        if (o instanceof CategoryNode) {
            return ((CategoryNode)o).getCategory();
        }
        return null;
    }

    public Library getLibrary(TreePath path) {
        if (path == null) {
            return null;
        }
        Object o = this.getPathComponentAt(path, 1);
        if (o instanceof LibraryNode) {
            return ((LibraryNode)o).getLibrary();
        }
        return null;
    }

    private Object getPathComponentAt(TreePath path, int index) {
        if (index <= path.getPathCount() - 1) {
            return path.getPathComponent(index);
        }
        return null;
    }

    private void fireChanged() {
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.rootNode), null, null));
        }
    }

    private TreePath createAbsolutePath(TreeNode lastNode) {
        TreeNode parentNode = lastNode.getParent();
        if (parentNode == null) {
            return new TreePath(lastNode);
        }
        return this.createAbsolutePath(parentNode).pathByAddingChild(lastNode);
    }

    public void libraryNodeRenamed(RenameEvent e) {
        Object renamedNode = e.getRenamedNode();
        if (renamedNode == null) {
            this.fireTreeNodeChanged(new TreePath(this.rootNode));
        } else {
            for (TreePath path : this.libraryNodeMap.keySet()) {
                if (path.getLastPathComponent() != renamedNode) continue;
                TreeNode renamedMacroTreeNode = this.libraryNodeMap.get(path);
                TreePath renamedPath = this.createAbsolutePath(renamedMacroTreeNode);
                this.fireTreeNodeChanged(renamedPath);
            }
        }
    }

    public void libraryNodeRemoved(RemoveEvent e) {
        this.resetSearchMode();
        this.synchronizeTree(null);
        Object parentNode = e.getParentNode();
        if (parentNode == null) {
            this.fireTreeStructureChanged(new TreePath(this.rootNode));
        } else {
            for (TreePath path : this.libraryNodeMap.keySet()) {
                if (path.getLastPathComponent() != parentNode) continue;
                TreeNode parentMacroTreeNode = this.libraryNodeMap.get(path);
                TreePath parentPath = this.createAbsolutePath(parentMacroTreeNode);
                this.fireTreeStructureChanged(parentPath);
                System.out.println("deleted in:" + parentPath);
            }
        }
    }

    public void libraryNodeAdded(AddEvent e) {
        this.resetSearchMode();
        this.synchronizeTree(null);
        Object parentNode = e.getParentNode();
        if (parentNode == null) {
            this.fireTreeStructureChanged(new TreePath(this.rootNode));
        } else {
            for (TreePath path : this.libraryNodeMap.keySet()) {
                if (path.getLastPathComponent() != parentNode) continue;
                TreeNode parentMacroTreeNode = this.libraryNodeMap.get(path);
                TreePath parentPath = this.createAbsolutePath(parentMacroTreeNode);
                this.fireTreeStructureChanged(parentPath);
                System.out.println("added in:" + parentPath);
            }
        }
    }

    public void libraryNodeKeyChanged(KeyChangeEvent e) {
    }

    public void libraryLoaded() {
        this.resetSearchMode();
        this.synchronizeTree(null);
        this.fireChanged();
    }

    private void fireTreeNodeChanged(TreePath path) {
        if (path != null) {
            for (TreeModelListener l : this.listeners) {
                l.treeNodesChanged(new TreeModelEvent((Object)this, path));
            }
        }
    }

    private void fireTreeNodeRemoved(TreePath path) {
        if (path != null) {
            for (TreeModelListener l : this.listeners) {
                l.treeNodesRemoved(new TreeModelEvent((Object)this, path));
            }
        }
    }

    private void fireTreeStructureChanged(TreePath path) {
        if (path != null) {
            for (TreeModelListener l : this.listeners) {
                l.treeStructureChanged(new TreeModelEvent((Object)this, path));
            }
        }
    }

    private void synchronizeTree(NodeFilterInterface filter) {
        HashMap tmpMap = (HashMap)this.libraryNodeMap.clone();
        this.libraryNodeMap.clear();
        if (this.rootNode == null) {
            this.rootNode = new RootNode();
        }
        if (filter == null) {
            this.rootNode.setLabel("FidoCadJ");
        } else {
            this.rootNode.setLabel("Search results...");
        }
        this.rootNode.clearChildNodes();
        for (Library library : this.libraryModel.getAllLibraries()) {
            LibraryNode ln;
            TreePath libraryPath = new TreePath(library);
            if (this.libraryNodeMap.containsKey(libraryPath)) {
                ln = (LibraryNode)tmpMap.get(libraryPath);
                ln.clearChildNodes();
            } else {
                ln = new LibraryNode(library);
            }
            for (Category category : library.getAllCategories()) {
                CategoryNode cn;
                if (category.isHidden()) continue;
                TreePath categoryPath = libraryPath.pathByAddingChild(category);
                if (tmpMap.containsKey(categoryPath)) {
                    cn = (CategoryNode)tmpMap.get(categoryPath);
                    cn.clearChildNodes();
                } else {
                    cn = new CategoryNode(category);
                }
                for (MacroDesc macro : category.getAllMacros()) {
                    TreePath macroPath = categoryPath.pathByAddingChild(macro);
                    MacroNode mn = tmpMap.containsKey(macroPath) ? (MacroNode)tmpMap.get(macroPath) : new MacroNode(macro);
                    if (filter != null && !filter.accept(mn)) continue;
                    cn.addMacroNode(mn);
                    this.libraryNodeMap.put(macroPath, mn);
                }
                if (filter != null && cn.getChildCount() == 0) continue;
                ln.addCategoryNode(cn);
                this.libraryNodeMap.put(categoryPath, cn);
            }
            if (filter != null && ln.getChildCount() == 0) continue;
            this.rootNode.addLibraryNode(ln);
            this.libraryNodeMap.put(libraryPath, ln);
        }
        this.rootNode.sortTree();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MacroNode
    extends AbstractMacroTreeNode
    implements Comparable<MacroNode> {
        MacroDesc macro;

        MacroNode(MacroDesc macroDesc) {
            this.macro = macroDesc;
            this.icon = null;
        }

        public MacroDesc getMacro() {
            return this.macro;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        public int compareTo(MacroNode node) {
            MacroDesc m1 = this.macro;
            MacroDesc m2 = node.getMacro();
            return m1.name.compareToIgnoreCase(m2.name);
        }

        @Override
        public String toString() {
            return this.macro.name;
        }

        public boolean equals(MacroNode node) {
            return this.compareTo(node) == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CategoryNode
    extends AbstractMacroTreeNode
    implements Comparable<CategoryNode> {
        private final Category category;

        CategoryNode(Category category) {
            this.category = category;
            this.icon = null;
        }

        public Category getCategory() {
            return this.category;
        }

        public void addMacroNode(MacroNode node) {
            this.childNodes.add(node);
            node.setParent(this);
        }

        @Override
        public int compareTo(CategoryNode node) {
            Category c1 = this.category;
            Category c2 = node.getCategory();
            return c1.getName().compareToIgnoreCase(c2.getName());
        }

        @Override
        public String toString() {
            return this.category.getName();
        }

        public boolean equals(CategoryNode node) {
            return this.compareTo(node) == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LibraryNode
    extends AbstractMacroTreeNode
    implements Comparable<LibraryNode> {
        private final Library library;

        LibraryNode(Library library) {
            this.library = library;
            this.icon = library.isStdLib() ? MetalIconFactory.getTreeHardDriveIcon() : MetalIconFactory.getTreeFloppyDriveIcon();
        }

        public Library getLibrary() {
            return this.library;
        }

        public void addCategoryNode(CategoryNode node) {
            this.childNodes.add(node);
            node.setParent(this);
        }

        @Override
        public int compareTo(LibraryNode node) {
            Library l1 = this.library;
            Library l2 = node.getLibrary();
            if (l1.isStdLib() == l2.isStdLib()) {
                return l1.getName().compareToIgnoreCase(l2.getName());
            }
            if (l1.isStdLib()) {
                return -1;
            }
            return 1;
        }

        @Override
        public String toString() {
            return this.library.getName();
        }

        public boolean equals(LibraryNode node) {
            return this.compareTo(node) == 0;
        }
    }

    private class RootNode
    extends AbstractMacroTreeNode {
        RootNode() {
            this.parent = null;
            this.label = "FidoCadJ";
            this.icon = MetalIconFactory.getTreeComputerIcon();
        }

        RootNode(String label) {
            this.parent = null;
            this.label = label;
            this.icon = MetalIconFactory.getTreeComputerIcon();
        }

        RootNode(String label, Icon icon) {
            this.parent = null;
            this.label = label;
            this.icon = icon;
        }

        public void addLibraryNode(LibraryNode node) {
            this.childNodes.add(node);
            node.setParent(this);
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

