/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj.macropicker;

import globals.Globals;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.fidocadj.librarymodel.Category;
import net.sourceforge.fidocadj.librarymodel.Library;
import net.sourceforge.fidocadj.macropicker.MacroTree;
import primitives.MacroDesc;

public class MacroTreePopupMenu
extends JPopupMenu
implements ChangeListener {
    private final MacroTree macroTree;
    private final MacroTree.OperationPermission permission;
    private final JMenuItem copyMenu;
    private final JMenuItem pasteMenu;
    private final JMenuItem renameMenu;
    private final JMenuItem removeMenu;
    private final JMenuItem renkeyMenu;

    public MacroTreePopupMenu(MacroTree macroTree) {
        this.macroTree = macroTree;
        this.permission = macroTree.getOperationPermission();
        this.copyMenu = new JMenuItem(Globals.messages.getString("Copy"));
        this.pasteMenu = new JMenuItem(Globals.messages.getString("Paste"));
        this.removeMenu = new JMenuItem(Globals.messages.getString("Delete"));
        this.renameMenu = new JMenuItem(Globals.messages.getString("Rename"));
        this.renkeyMenu = new JMenuItem(Globals.messages.getString("RenKey"));
        this.add(this.copyMenu);
        this.add(this.pasteMenu);
        this.add(this.removeMenu);
        this.add(this.renameMenu);
        this.add(this.renkeyMenu);
        this.copyMenu.addActionListener(this.createCopyActionListener());
        this.pasteMenu.addActionListener(this.createPasteActionListener());
        this.removeMenu.addActionListener(this.createRemoveActionListener());
        this.renameMenu.addActionListener(this.createRenameActionListener());
        this.renkeyMenu.addActionListener(this.createRenkeyActionListener());
    }

    public void stateChanged(ChangeEvent e) {
        this.copyMenu.setEnabled(this.permission.isCopyAvailable());
        this.pasteMenu.setEnabled(this.permission.isPasteAvailable());
        this.removeMenu.setEnabled(this.permission.isRemoveAvailable());
        this.renameMenu.setEnabled(this.permission.isRenameAvailable());
        this.renkeyMenu.setEnabled(this.permission.isRenKeyAvailable());
    }

    private void enableAllMenu(boolean b) {
        this.copyMenu.setEnabled(b);
        this.pasteMenu.setEnabled(b);
        this.removeMenu.setEnabled(b);
        this.renameMenu.setEnabled(b);
        this.renkeyMenu.setEnabled(b);
    }

    private ActionListener createRenameActionListener() {
        final MacroTree mt = this.macroTree;
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                switch (mt.getSelectedType()) {
                    case 2: {
                        MacroDesc m = mt.getSelectedMacro();
                        if (m == null) break;
                        mt.rename(m);
                        break;
                    }
                    case 1: {
                        Category c = mt.getSelectedCategory();
                        if (c == null) break;
                        mt.rename(c);
                        break;
                    }
                    case 0: {
                        Library l = mt.getSelectedLibrary();
                        if (l == null) break;
                        mt.rename(l);
                        break;
                    }
                }
            }
        };
        return al;
    }

    private ActionListener createRemoveActionListener() {
        final MacroTree mt = this.macroTree;
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                switch (mt.getSelectedType()) {
                    case 2: {
                        MacroDesc m = mt.getSelectedMacro();
                        if (m == null) break;
                        mt.remove(m);
                        break;
                    }
                    case 1: {
                        Category c = mt.getSelectedCategory();
                        if (c == null) break;
                        mt.remove(c);
                        break;
                    }
                    case 0: {
                        Library l = mt.getSelectedLibrary();
                        if (l == null) break;
                        mt.remove(l);
                        break;
                    }
                }
            }
        };
        return al;
    }

    private ActionListener createRenkeyActionListener() {
        final MacroTree mt = this.macroTree;
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                switch (mt.getSelectedType()) {
                    case 2: {
                        MacroDesc m = mt.getSelectedMacro();
                        if (m == null) break;
                        mt.changeKey(m);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 0: {
                        break;
                    }
                }
            }
        };
        return al;
    }

    private ActionListener createCopyActionListener() {
        final MacroTree mt = this.macroTree;
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mt.setSelectedNodeToCopyTarget();
            }
        };
        return al;
    }

    private ActionListener createPasteActionListener() {
        final MacroTree mt = this.macroTree;
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                mt.pasteIntoSelectedNode();
            }
        };
        return al;
    }
}

