/*
 * Decompiled with CFR 0.152.
 */
package circuit.views;

import circuit.model.DrawingModel;
import export.ExportGraphic;
import export.ExportInterface;
import geom.MapCoordinates;
import graphic.DimensionG;
import graphic.PointG;
import java.io.IOException;
import primitives.GraphicPrimitive;
import primitives.PrimitiveMacro;
import primitives.PrimitivePCBPad;

public class Export {
    private final DrawingModel P;
    public static final int exportBorder = 6;

    public Export(DrawingModel pp) {
        this.P = pp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportDrawing(ExportInterface exp, boolean header, boolean exportInvisible, MapCoordinates mp) throws IOException {
        Export export = this;
        synchronized (export) {
            int l;
            GraphicPrimitive g;
            int i;
            if (header) {
                PointG o = new PointG(0, 0);
                DimensionG d = ExportGraphic.getImageSize(this.P, 1.0, true, o);
                d.width += 6;
                d.height += 6;
                d.width = (int)((double)d.width * mp.getXMagnitude());
                d.height = (int)((double)d.height * mp.getYMagnitude());
                exp.exportStart(d, this.P.layerV, mp.getXGridStep());
            }
            if (this.P.drawOnlyLayer >= 0 && !this.P.drawOnlyPads) {
                for (int i2 = 0; i2 < this.P.getPrimitiveVector().size(); ++i2) {
                    GraphicPrimitive g2 = this.P.getPrimitiveVector().get(i2);
                    int l2 = g2.getLayer();
                    if (l2 == this.P.drawOnlyLayer && !(g2 instanceof PrimitiveMacro)) {
                        if (!this.P.layerV.get((int)l2).isVisible && !exportInvisible) continue;
                        g2.export(exp, mp);
                        continue;
                    }
                    if (!(g2 instanceof PrimitiveMacro)) continue;
                    ((PrimitiveMacro)g2).setDrawOnlyLayer(this.P.drawOnlyLayer);
                    ((PrimitiveMacro)g2).setExportInvisible(exportInvisible);
                    if (!this.P.layerV.get((int)l2).isVisible && !exportInvisible) continue;
                    g2.export(exp, mp);
                }
                return;
            }
            if (!this.P.drawOnlyPads) {
                for (int j = 0; j < this.P.layerV.size(); ++j) {
                    for (i = 0; i < this.P.getPrimitiveVector().size(); ++i) {
                        g = this.P.getPrimitiveVector().get(i);
                        l = g.getLayer();
                        if (l == j && !(g instanceof PrimitiveMacro)) {
                            if (!this.P.layerV.get((int)l).isVisible && !exportInvisible) continue;
                            g.export(exp, mp);
                            continue;
                        }
                        if (!(g instanceof PrimitiveMacro)) continue;
                        ((PrimitiveMacro)g).setDrawOnlyLayer(j);
                        ((PrimitiveMacro)g).setExportInvisible(exportInvisible);
                        if (!this.P.layerV.get((int)l).isVisible && !exportInvisible) continue;
                        g.export(exp, mp);
                    }
                }
            }
            for (i = 0; i < this.P.getPrimitiveVector().size(); ++i) {
                g = this.P.getPrimitiveVector().get(i);
                if (g instanceof PrimitivePCBPad) {
                    ((PrimitivePCBPad)g).setDrawOnlyPads(true);
                    l = g.getLayer();
                    if (this.P.layerV.get((int)l).isVisible || exportInvisible) {
                        g.export(exp, mp);
                    }
                    ((PrimitivePCBPad)g).setDrawOnlyPads(false);
                    continue;
                }
                if (!(g instanceof PrimitiveMacro)) continue;
                ((PrimitiveMacro)g).setExportInvisible(exportInvisible);
                ((PrimitiveMacro)g).setDrawOnlyPads(true);
                l = g.getLayer();
                if (this.P.layerV.get((int)l).isVisible || exportInvisible) {
                    g.export(exp, mp);
                }
                ((PrimitiveMacro)g).setDrawOnlyPads(false);
                ((PrimitiveMacro)g).resetExport();
            }
            if (header) {
                exp.exportEnd();
            }
        }
    }
}

