/*
 * Decompiled with CFR 0.152.
 */
package circuit.controllers;

import circuit.controllers.EditorActions;
import circuit.controllers.ParserActions;
import circuit.controllers.UndoActions;
import circuit.model.DrawingModel;
import globals.ProvidesCopyPasteInterface;

public class CopyPasteActions {
    private final DrawingModel P;
    private final EditorActions edt;
    private final ParserActions pa;
    private final UndoActions ua;
    private final ProvidesCopyPasteInterface cpi;
    private boolean shiftCP;

    public CopyPasteActions(DrawingModel pp, EditorActions ed, ParserActions aa, UndoActions u, ProvidesCopyPasteInterface p) {
        this.P = pp;
        this.edt = ed;
        this.pa = aa;
        this.ua = u;
        this.cpi = p;
        this.shiftCP = false;
    }

    public void paste(int xstep, int ystep) {
        this.edt.setSelectionAll(false);
        try {
            this.pa.addString(new StringBuffer(this.cpi.pasteText()), true);
        }
        catch (Exception E) {
            System.out.println("Warning: paste operation has gone wrong.");
        }
        if (this.shiftCP) {
            this.edt.moveAllSelected(xstep, ystep);
        }
        this.ua.saveUndoState();
        this.P.setChanged(true);
    }

    public void copySelected(boolean extensions, boolean splitNonStandard, int xstep, int ystep) {
        StringBuffer s = this.edt.getSelectedString(extensions, this.pa);
        if (splitNonStandard) {
            s = this.pa.splitMacros(s, false);
        }
        this.cpi.copyText(s.toString());
    }

    public boolean getShiftCopyPaste() {
        return this.shiftCP;
    }

    public void setShiftCopyPaste(boolean s) {
        this.shiftCP = s;
    }
}

