/*
 * Decompiled with CFR 0.152.
 */
import java.util.NoSuchElementException;

public final class priorityqueue {
    protected Queue[] queues;
    protected float[] priorities;
    protected static final int DEFAULTQUEUES = 5;
    protected static final int DEFAULTINCREMENT = 5;
    protected static final float INTERNAL_FREE_MARK = -999.9f;
    protected int increment;

    public priorityqueue() {
        this(5, 5);
    }

    public priorityqueue(int n) {
        this(n, 5);
    }

    public priorityqueue(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("size(queues) <= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("increment < 0");
        }
        this.queues = new Queue[n];
        this.priorities = new float[n];
        for (int i = n - 1; i >= 0; --i) {
            this.priorities[i] = -999.9f;
        }
        this.increment = n2;
    }

    public synchronized Object push(Object object) {
        return this.push(object, 1.0f);
    }

    public synchronized Object push(Object object, float f) {
        Object object2;
        for (int i = this.priorities.length - 1; i >= 0; --i) {
            object2 = this.queues[i];
            float f2 = this.priorities[i];
            if (f2 == f) {
                if (object2 != null) {
                    ((Queue)object2).push(object);
                    this.notify();
                    return object;
                }
                this.queues[i] = object2 = new Queue(this.increment, this.increment);
                ((Queue)object2).push(object);
                this.notify();
                return object;
            }
            if (f2 != -999.9f) continue;
            this.add(i, f, object);
            this.notify();
            return object;
        }
        float[] fArray = new float[this.priorities.length + this.increment];
        object2 = new Queue[this.priorities.length + this.increment];
        for (int i = 0; i < this.increment; ++i) {
            fArray[i] = -999.9f;
        }
        this.priorities = fArray;
        this.queues = object2;
        this.add(this.increment - 1, f, object);
        this.notify();
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        for (int i = this.priorities.length - 1; i >= 0; --i) {
            stringBuffer.append(this.priorities[i] + " ");
        }
        return stringBuffer.toString();
    }

    /*
     * Loose catch block
     */
    public synchronized Object pop() {
        int n = this.queues.length;
        while (true) {
            try {
                return this.queues[--n].pop();
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.queues[n] = null;
                continue;
            }
            break;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    public synchronized int search(Object object) {
        int n = this.queues.length;
        int n2 = 0;
        while (true) {
            try {
                int n3;
                while ((n3 = this.queues[n].search(object)) == -1) {
                    n2 += this.queues[n].queuesize();
                }
                return n3 + n2;
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return -1;
            }
            break;
        }
    }

    /*
     * Loose catch block
     */
    public Object peek() {
        int n = this.queues.length;
        while (true) {
            try {
                return this.queues[--n].peek();
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.queues[n] = null;
                continue;
            }
            break;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    protected Object add(int n, float f, Object object) {
        Queue queue;
        int n2 = n;
        if (n < this.priorities.length - 1 && this.priorities[n + 1] < f) {
            for (int i = n + 1; i < this.priorities.length; ++i) {
                if (!(this.priorities[i] > f)) continue;
                System.arraycopy(this.priorities, n + 1, this.priorities, n, i - n);
                System.arraycopy(this.queues, n + 1, this.queues, n, i - n);
                n2 = i - 1;
                break;
            }
        }
        this.queues[n2] = queue = new Queue(this.increment, this.increment);
        this.priorities[n2] = f;
        return queue.push(object);
    }
}

