/**
 * $Id: QuickSort.java,v 1.1.1.1 2001/07/22 02:44:50 groomed Exp $
 *
 * This code adapted from http://ironbark.bendigo.latrobe.edu.au/courses/bcomp/c103/sem296/lectures/Lecture2.html.
 *
 */

package redlight.utils;

public class QuickSort {
    
    public static void sort(Sortable A[], int first, int last) {

        /* Index of the element separating the two sub-arrays. */

        int pivindx;

        /* More than one element to be sorted? */

        if (last > first) {

            pivindx = partition(A, first, last);
            sort(A, first, pivindx - 1);
            sort(A, pivindx + 1, last);

        }

    }

    public static int partition(Sortable A[], int first, int last) {

        int pivindx, top, i; 
        Sortable pivot;
   
        /* Choose a pivot: select a random index between first and last. */

        i = first;
   
        /* Put the pivot first, remember pivot, initialise ready for loop. */

        /* Remember the pivot. */

        pivot = A[i];
        A[i] = A[first];

        /* Pivot now first. */

        A[first] = pivot;
        pivindx = first;
        top = last;                       
        
        /* Still unknown elements. */

        while (top > pivindx) {

            /* "top" indicates the highest unknown element. */

            if(pivot.smallerThan(A[top])) {

                /* Where it belongs, count as >= */

                top--;

            } else {

                /* Shift down. */

                A[pivindx] = A[top];

                /* Shift displaced element up. */

                A[top] = A[pivindx + 1];

                /* Put pivot back. */

                A[pivindx + 1] = pivot;

                /* Alter record of pivot location. */

                pivindx++;

            }

        }

        return pivindx;

    }

    public static void sort(short A[], int first, int last) {

        /* Index of the element separating the two sub-arrays. */

        int pivindx;

        /* More than one element to be sorted? */

        if (last > first) {

            pivindx = partition(A, first, last);
            sort(A, first, pivindx - 1);
            sort(A, pivindx + 1, last);

        }

    }

    public static int partition(short A[], int first, int last) {

        int pivindx, top, i; 
        short pivot;
   
        /* Choose a pivot: select a random index between first and last. */

        i = first;
   
        /* Put the pivot first, remember pivot, initialise ready for loop. */

        /* Remember the pivot. */

        pivot = A[i];
        A[i] = A[first];

        /* Pivot now first. */

        A[first] = pivot;
        pivindx = first;
        top = last;                       
        
        /* Still unknown elements. */

        while (top > pivindx) {

            /* "top" indicates the highest unknown element. */

            if(pivot < A[top]) {

                /* Where it belongs, count as >= */

                top--;

            } else {

                /* Shift down. */

                A[pivindx] = A[top];

                /* Shift displaced element up. */

                A[top] = A[pivindx + 1];

                /* Put pivot back. */

                A[pivindx + 1] = pivot;

                /* Alter record of pivot location. */

                pivindx++;

            }

        }

        return pivindx;

    }
    
}
