/**
 * $Id: Queueable.java,v 1.1.1.1 2001/07/22 02:44:50 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

/**
 * Implemented by Objects that are scheduled by a QueueThread.
 * @see QueueThread
 */
public interface Queueable {
    /**
     * This method is called when the QueueThread grants
     * a queue element to perform some action. When this
     * method returns, the QueueThread removes the Queueable
     * object from the queue and invokes the granted() 
     * method on the next element in the queue.
     */
    public void granted();
}
