/**
 * $Id: MeterSource.java,v 1.3 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

/**
 * Objects that perform a lengthy operation that are
 * monitored by a Meter should implement this.
 */
public interface MeterSource {
    /**
     * Sets the Meter to monitor this MeterSource.
     * @param m the Meter to set
     */
    public void setMeter(Meter m);

    /**
     * Returns the Meter that is monitoring this 
     * MeterSource.
     * @return Meter object
     */
    public Meter getMeter();

    /**
     * Invoked by a Meter on it's MeterSource to signal that the 
     * operation has to be interrupted. When a Meter invokes this
     * method, it will / should no longer receive stopMeter()
     * or stopMeterWithError() messages.
     * @see redlight.utils.Meter
     */
    public void interrupt();

    /**
     * Invoked by a Meter on it's MeterSource to wait for the
     * MeterSource thread to complete any necessary cleanup
     * operations (such as closing files).
     * @see redlight.utils.Meter
     */
    public void join();

}






