/**
 * $Id: Logger.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.utils;

import java.io.FileWriter;
import java.io.File;
import java.util.Date;
import java.text.DateFormat;
import java.io.IOException;

/**
 * Logfile utilities.
 */
public class Logger {
    FileWriter logWriter;
    Exception error;

    /**
     * Writes a date-prepended string to the logfile.
     * @param s the string to log
     * @return true if writing to the logfile was successfull, false otherwise
     */
    public boolean writeLog(String s) {

	boolean ok = false;

	if(logWriter != null) {

	    String stripped_crlf = TextUtils.findAndReplace(s, "\r", " ");
	    stripped_crlf = 
		TextUtils.findAndReplace(stripped_crlf, "\n", " ");
	    String line = DateFormat.getInstance().
		format(new Date(System.currentTimeMillis())) +
		"  " + stripped_crlf + System.getProperty("line.separator");

	    try {

		logWriter.write(line, 0, line.length());
		logWriter.flush();
		ok = true;

	    } catch (IOException e) {

		error = e;

	    }
	}

	return ok;

    }

    /**
     * Opens a logfile. If the logfile is specified as a
     * non-existant file in a non-existant directory, then 
     * the file and all parent directories are automatically
     * created.
     * @param logFile the file to log to
     * @param first the first line in the logfile
     * @param append true to append to an existing file, 
     * false to overwrite it.
     * @return true if opening the flie was successfull, false otherwise
     */
    public boolean openLog(File logFile, String first, boolean append) {

	boolean ok = false;

	try {

	    if(!new File(logFile.getParent()).exists()) 
		new File(logFile.getParent()).mkdirs();

	    logWriter = 
		new FileWriter(new File(logFile.getParent(), 
					FilenameUtils.
					qualify(logFile.getName())).getPath(), 
			       append);
	    MacFileUtils.
		setFileTypeAndCreator(logFile, new String("TEXT").getBytes(), 
					       new String("ttxt").getBytes());
	    String line = "Log started";

	    logWriter.write(System.getProperty("line.separator"));
	    writeLog("Log started"); 
	    writeLog(first);
	    ok = true;

	} catch (IOException e) {

	    error = e;

	}

	return ok;

    }

    /**
     * Closes a previously opened logfile.
     */
    public void closeLog() {

	if(logWriter != null) {

	    try {

		logWriter.flush();
		logWriter.close();

	    } catch (IOException e) {
		//		e.printStackTrace();
	    }
	}

	logWriter = null;

    }

    /**
     * Returns the error that occurred.
     * @return the error
     */
    public Exception getError() {

	return error;

    }
}








