/**
 * $Id: Policy.java,v 1.2 2001/07/23 14:11:26 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

package redlight.server;

import redlight.hotline.HLServer;
import redlight.hotline.HLServerPolicy;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServerDispatcher;

/**
 * This class implements policy for Main.
 */
public class Policy extends HLServerPolicy {

    public Policy(HLServer h) {

        super(h);

    }

    public String approveFlatnewsPost(HLServerDispatcher client,
                                      String newPost) {

        String parentApproval = super.approveFlatnewsPost(client, newPost);

        if(parentApproval != null)
            return parentApproval;

        if(newPost.length() > 16384)
            return "Your news post exceeds the maximum length of 16KB.";

        return null;

    }

    String checkAccountLogin(HLProtocol.AccountInfo account) {

        if(account.login.indexOf(':') != -1 || 
           account.login.indexOf('\r') != -1 || 
           account.login.indexOf('\n') != -1 || 
           account.login.trim().length() == 0)
            return "Account login cannot contain \n, \r or : and cannot be empty.";
            
        return null;

    }

    public String approveAccountCreate(HLProtocol.AccountInfo account) {
        
        return checkAccountLogin(account);

    }
    
    public String approveAccountModify(HLProtocol.AccountInfo account) {

        return checkAccountLogin(account);

    }    
    
}
