/**
 * $Id: Scriptable.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.script;

import java.util.BitSet;

/**
 * An object that wishes to receive and respond to scripting messages
 * implements this class.
 */
public interface Scriptable {
    /**
     * Invoked when this object has become a target for the
     * specified ScriptBroker.
     * @param sb the ScriptBroker
     */
    public void gotTarget(ScriptBroker sb);
    /**
     * Invoked when this object is no longer a target for the
     * specified ScriptBroker.
     * @param sb the ScriptBroker
     */
    public void lostTarget(ScriptBroker sb);
    /**
     * Invoked to determine whether this object
     * can receive a particular message. This method
     * should return a set of binary flags where every
     * bit encodes a particular kind of message.
     * @return a set of binary flags
     */
    public long getKnownMessages();
    /**
     * Invoked by the ScriptBroker when a message arrives
     * for this object. The ScriptBroker will only invoke
     * this method after first determining that the message
     * is in fact of a type returned by getKnownMessages().
     * @param s the message
     * @return the result of executing the script
     */
    public ScriptResult executeScript(ScriptObject s) throws UnknownMessageException;
}

