/**
 * $Id: ResourceInputStream.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.InputStream;
import java.io.IOException;

import com.apple.memory.PInt;
import com.apple.memory.PShort;
import com.apple.MacOS.FSSpec;
import com.apple.MacOS.MacOSError;
import com.apple.mrj.MRJOSType;

import redlight.utils.DebuggerOutput;

public class ResourceInputStream 
    extends InputStream implements com.apple.NativeObject {    

    private short refNum;
    private ResourceFork parent;

    public ResourceInputStream(ResourceFork fork) throws IOException {
	parent = fork;
	refNum = parent.refNum;
    }
    
    public void close() throws IOException {
	parent.close();
    }

    public int available() throws IOException {
	return parent.available();
    }

    public synchronized void mark(int readLimit) {
    }
    
    public boolean markSupported() {
	return false;
    }

    public synchronized void reset() {
    }

    public long skip(long n) throws IOException {
	parent.seek(parent.getFilePointer() + (int) n);
	return parent.getFilePointer();
    }

    public int read() {
	byte[] b = new byte[1];
	short err = FSRead(refNum, new PInt(1), b);
	if (err != -39)         // eof
	    MacOSError.CheckResult(err);
	else {
	    return -1;
	}
	return (int) b[0];
    }

    public int read(byte[] b, int offset, int length) {
	PInt r = new PInt(length); 
	byte[] tmpbuf = new byte[length];
	short err = FSRead(refNum, r, tmpbuf);
	int read = r.getValue();
	System.arraycopy(tmpbuf, 0, b, offset, read);
	if (err != -39)         // eof
	    MacOSError.CheckResult(err);
	else {
	    return -1;
	}
	return read;
    }
    
    /**
     * The JDirect implementation
     */

    /** specify the library names that we need to work */
    private static String[] kNativeLibraryNames = { "InterfaceLib" };

    /** Declare the native methods that we're accessing */
    private static native short FSRead(
				       short refNum, 
				       PInt bytesRead, 
				       byte[] buff);
}
