/**
 * $Id: SplitFork.java,v 1.2 2001/09/10 07:24:56 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.*;

import redlight.utils.DebuggerOutput;

public class SplitFork extends Fork {

    RandomAccessFile forkFile;
    String perms = new String();
    String id = "DATA", ext = "";
    File forkFileAvatar;
    boolean isOpen = false;

    public SplitFork(MacFile parent, 
                     Integer p, 
                     String id,
                     String ext) {

	super(parent);

        this.id = id;
        this.ext = ext;

        if((p.intValue() & MacFile.READ_PERM) == MacFile.READ_PERM)
            perms = "r";

        if((p.intValue() & MacFile.WRITE_PERM) == MacFile.WRITE_PERM)
            perms += "w";

        if(ext == "") 
            forkFileAvatar = new File(parent.getFile().toString());
        else
            forkFileAvatar = new File(parent.getFile().getParent(), "." + parent.getFile().getName() + ext);

    }

    private boolean openFork() throws IOException {

        if(forkFile == null) {

            try {
                
                forkFile = new RandomAccessFile(forkFileAvatar, perms);
                isOpen = true;

                DebuggerOutput.debug(toString() + ": opened (" + forkFileAvatar.length() + ")");
                
            } catch(FileNotFoundException e) {}

        }

        return isOpen;

    }

    public long size() {

        return forkFileAvatar.length();

    }

    public long seek(long s) throws IOException {

        if(openFork()) {

            forkFile.seek(s);
            DebuggerOutput.debug(toString() + ": seek to " + s + ")");

            return s;

        }

	return -1;

    }

    public DataOutput getDataOutput() throws IOException {

        if(openFork())
            return forkFile;

        throw new IOException("Could not open " + forkFileAvatar.toString());

    }

    public DataInput getDataInput() throws IOException {

        if(openFork())
            return forkFile;

        throw new IOException("Could not open " + forkFileAvatar.toString());

    }

    public void close() throws IOException {

        if(forkFile != null) {
                
            forkFile.close();
            forkFile = null;
            isOpen = false;

            if(size() == 0) {
                
                forkFileAvatar.delete();
                DebuggerOutput.debug(toString() + ": deleted empty fork file on close");

            }

            DebuggerOutput.debug(toString() + ": closed.");

        }

    }

    public boolean exists() {

        return size() > 0 ? true : false; 

    }

    public boolean delete() {

	boolean s = false;

	try {

            close();
            s = forkFileAvatar.delete();

	} catch (IOException e) {}

	return s;

    }

    public boolean renameTo(File f) {

	boolean s = false;

	try {

            close();
            s = forkFileAvatar.renameTo(f);

	} catch (IOException e) {}

	return s;

    }

    public String toString() {

        return "SplitFork[" + id + " fork @ " + forkFileAvatar.toString() + " (" + perms + ")]";

    }

}
