/**
 * $Id: MacBinaryDataFork.java,v 1.1.1.1 2001/07/22 02:44:48 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.macfiles;

import java.io.*;

import redlight.utils.DebuggerOutput;


public class MacBinaryDataFork 
    extends MacBinaryFork {

    public MacBinaryDataFork(MacFile parent) {
	super(parent);
    }

    public long size() {
	return parent.getDataSize();
    }

    public long seek(long s) throws IOException {
	DebuggerOutput.debug("MacBinaryDataFork: seek "+s);
	// skip macbinary header
	// to arrive at proper position in data fork
	((MacBinaryMacFile) parent).getRandomAccessFile().seek(128 + s); 
	return s;
    }

    public void close() throws IOException {

        if(!isClosed) {

            close(parent.getDataSize());
            isClosed = true;

        }

    }

}











