package redlight.hotline.iconlib;

import java.io.*;
/*
                Read the license.txt file for license information!
                If you don't have it, get it at www.MarkusStengel.de.
*/


/**
 *          class to manage RGB-objects
 *          @author     Markus Stengel
 *          @see          <a href="http://www.MarkusStengel.de">developer site</a>
 */
public class HLRGB {

     private int red;
     private int green;
     private int blue;

     /**
      *          initializes the class variables RGB=0x000000
      */
     public HLRGB() {
          red       = 0;
          green     = 0;
          blue      = 0;
     }

     /**
      *          initializes the class variables RGB with the given values
      *          @param     r          red value
      *          @param     g          green value
      *          @param     b          blue value
      */
     public HLRGB(byte r, byte g, byte b) {
          red     = HLUtils.signedToUnsigned(r);
          green     = HLUtils.signedToUnsigned(g);
          blue     = HLUtils.signedToUnsigned(b);
     }

     /**
      *          initializes the class variables RGB with the given values
      *          @param     rgb     RGB value stored in big endian order
      */
     public HLRGB(int rgb) {
          set(rgb);
     }

     // extracts  the RGB values stored in big endian order in an integer and puts them into the
     // standard class color variables
     private void convert (int rgb) {

          red     = HLUtils.signedToUnsigned((byte) (rgb >> 16));
          rgb  -= red * 0x10000;
          green     = HLUtils.signedToUnsigned((byte) (rgb >> 8));
          rgb  -= green * 0x100;
          blue     = HLUtils.signedToUnsigned((byte) rgb);
     }


     /**
      *          set the class variables RGB with the given values
      *          @param     rgb     RGB value stored in big endian order
      */
     public void set (int rgb) {
          convert(rgb);
     }

     /**
      *          return the red value of the object
      *          @return               red value
      */
     public int getRed()      { return red; }

     /**
      *          return the green value of the object
      *          @return               green value
      */
     public int getGreen()     { return green; }

     /**
      *          return the blue value of the object
      *          @return               blue value
      */
     public int getBlue()     { return blue; }

     /**
      *          return the RGB in big endian format
      *          @return               RGB value, big endian format
      */
     public int get() {
          int val;
          val     = (HLUtils.signedToUnsigned((byte) red)      << 16);
          val  += (HLUtils.signedToUnsigned((byte) green)     << 8);
          val  += (HLUtils.signedToUnsigned((byte)blue));
          return  val;
     }

}