/**
 * $Id: ImageFromStream.java,v 1.2 2001/09/08 01:27:23 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.graphics;

import java.io.*;

import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.*;

import redlight.utils.DebuggerOutput;

/**
 * ImageFromStream implements an animated component.
 * The start() and stop() methods respectively start and stop the 
 * animation. When stopped, the component draws a rectangle in the 
 * background color.
 */ 
public class ImageFromStream extends java.awt.Component implements Runnable {
    Image image;
    Thread builder;
    InputStream inputStream;
    Integer imageLock;
    JComponent container;

    /**
     * @param imgs an array of image objects to use
     * @param s the delay between each frame
     * @param w the width of the component
     * @param h the height of the component
     */
    public ImageFromStream(JComponent container, InputStream inputStream) {

	super();
        this.inputStream = inputStream;
        this.imageLock = new Integer(0);
        this.container = container;
        builder = new Thread(this);
        builder.start();

    }

    public void run() {

        DebuggerOutput.debug("ImageFromStream: started ...");

        ByteArrayOutputStream imageData = new ByteArrayOutputStream();
        byte[] buf = new byte[10000];

        Thread.currentThread().setName("ImageFromStream " + inputStream);

        int r = 0;

	try {

            while(true) {

                r = inputStream.read(buf, 0, 10000);

                if(r == -1)
                    break;

                imageData.write(buf, 0, r);

            }
            
        } catch (IOException e) {

            DebuggerOutput.stackTrace(e);

	}

        try {

            imageData.flush();

        } catch(IOException e) {}

        synchronized(imageLock) {

            image = Toolkit.getDefaultToolkit().createImage(imageData.toByteArray());
            
        }

        imageData.reset();

        SwingUtilities.invokeLater(new Runnable() {

                public void run() {

                    invalidate();
                    container.revalidate();
                    container.repaint();

                }

            });

        DebuggerOutput.debug("ImageFromStream: exiting");

    }

    public java.awt.Dimension getPreferredSize() {
        
        if(image == null)
            return new Dimension(300, 200);

        return new Dimension(image.getWidth(null), image.getHeight(null));

    }
	
    public java.awt.Dimension getMinimumSize() {

        return getPreferredSize();

    }
	
    public void update(Graphics g) {

	paint(g);

    }

    public void paint(Graphics g) {
        
        synchronized(imageLock) {
            
            if(image != null) 
                g.drawImage(image, 0, 0, this);

            
        }

    }

}

