/**
 * $Id: ViewImageInterface.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;
 
import java.io.IOException;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

import redlight.graphics.ImageFromStream;
import redlight.hotline.*;
import redlight.utils.TextUtils;
import redlight.utils.DebuggerOutput;

/**
 * This class displays a piece of text as it arrives on a
 * PipedInputStream.
 */
public class ViewImageInterface extends AbstractViewInterface {

    JScrollPane scrollPane;
    ImageFromStream image;

    public ViewImageInterface(Machine machine, 
                                  TransferInterface transferInterface,
                                  String type,
                                  String filename,
                                  long total,
                                  PipedInputStream inputPipe) {

	super(machine, transferInterface, type, filename, total, inputPipe);

	scrollPane = new JScrollPane();
        image = new ImageFromStream(scrollPane, inputPipe);
        scrollPane.setViewportView(image);

	scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        contentPane.setLayout(new BorderLayout());
        contentPane.add(scrollPane, BorderLayout.CENTER);

        f.pack();
        show();

    }

    public void closeWindow() {

        super.closeWindow();
        scrollPane.setViewportView(null);
        image = null;

    }

    public void run() {}

}
