/**
 * $Id: UserCellRenderer.java,v 1.14 2001/09/09 08:43:28 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.io.IOException;
import java.awt.*;
import javax.swing.*;

import redlight.hotline.HLProtocol;

import redlight.hotline.iconlib.*;

/**
 * Renderer for users. Might be extended to support icons etcetera.
 */
class UserCellRenderer extends JLabel implements ListCellRenderer {

    boolean selected, usePlaceholder = true;
    Font font;
    Color selectedBackgroundColor, backgroundColor;
    static Color idleColor = new Color(0xababab),
        idleAdminColor = new Color(0xffabab);
    User user;
    
    public UserCellRenderer() {

        super();
        setHorizontalTextPosition(SwingConstants.LEFT);
        setVerticalTextPosition(SwingConstants.BOTTOM);
        selectedBackgroundColor = getBackground();
        backgroundColor = getBackground();
        setOpaque(true);

    }

    public UserCellRenderer(Font f) {

        this();
	font = f;
        setFont(new Font(font.getName(), font.getStyle() | Font.BOLD, font.getSize()));

    }

    public UserCellRenderer(User user, boolean usePlaceholder) {
        
        this();
        font = getFont();
        setFont(new Font(font.getName(), font.getStyle() | Font.BOLD, font.getSize()));
        this.usePlaceholder = usePlaceholder;
        initFromUser(user);

    }

    public Dimension getPreferredSize() {

        Dimension preferredSize = super.getPreferredSize();

        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);

        if(preferredSize.height < fm.getHeight())
            preferredSize.height = fm.getHeight();

        return preferredSize;

    }

    private void initFromJList(JList list) {

	selectedBackgroundColor = list.getSelectionBackground();
	backgroundColor = list.getBackground();
	font = list.getFont();
        setFont(new Font(font.getName(), font.getStyle() | Font.BOLD, font.getSize()));

    }

    private void initFromUser(User user) {

        this.user = user;

        /* Use colors to represents the status of the users:
           black for normal users, red for users who can disconnect
           other users, and lighter shades of these for users who
           have been idle for some time. */

        if((user.color & HLProtocol.UserListComponent.HAS_BEEN_IDLE) ==
           HLProtocol.UserListComponent.HAS_BEEN_IDLE) {

            setEnabled(true);

            setForeground(idleColor);

            if((user.color & HLProtocol.UserListComponent.CAN_DISCONNECT_USERS) == HLProtocol.UserListComponent.CAN_DISCONNECT_USERS)
                 setForeground(idleAdminColor);

        } else {

            setEnabled(true);

            setForeground(Color.black);        

            if((user.color & HLProtocol.UserListComponent.CAN_DISCONNECT_USERS) == HLProtocol.UserListComponent.CAN_DISCONNECT_USERS)
                setForeground(Color.red);

        }
        
        /* Get icon. */

        if(Main.iconFile == null) {

            /* Not supposed to use icons, null the icon and 
               don't use a place holder. */

            setText(user.nick);
            usePlaceholder = false;

        } else {

            if(usePlaceholder) {

                setIcon(Main.iconFile.getIconOrPlaceholder(user.icon));
                
            } else {

                Icon icon = Main.iconFile.getIcon(user.icon);
                
                if(icon != null)
                    setIcon(Main.iconFile.getIconOrPlaceholder(user.icon));
                else
                    setText(user.nick);

            }

        }

    }

    private void initFromSelectedState(boolean isSelected) {

        selected = isSelected;
	setBackground(selected ? selectedBackgroundColor : backgroundColor);

    }

    public Component getListCellRendererComponent(JList list,
						  Object value,
						  int index,
						  boolean isSelected,
						  boolean cellHasFocus) {

        initFromJList(list);
        initFromSelectedState(isSelected);
        initFromUser((User) value);

	return this;

    }

    public void paint(Graphics g) {

        super.paint(g);

        if(usePlaceholder || getIcon() != null) {

            int adjust = 0;
            
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            
            if(getHeight() > fm.getHeight())
                adjust = (getHeight() - fm.getHeight()) / 2;
            
            g.drawString(user.nick, 34, getFont().getSize() + adjust);
            
        }
        
    }

}





