/**
 * $Id: SimpleDialog.java,v 1.2 2001/09/21 02:48:24 groomed Exp $
 *
 * Copyright (C) 1998-2001 groomed <groomed@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package redlight.client;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.IOException; 

import redlight.hotline.*;

public abstract class SimpleDialog 
    implements Child,
	       ActionListener, 
	       WindowListener {
    Machine rlm;
    Container contentPane;
    Font guiFont;
    JLabel caption;
    JTextField textfield;
    JButton[] buttons;
    JPanel buttonPanel;
    JFrame f;
      
    public SimpleDialog(Machine machine, String title) {
	rlm = machine;

	guiFont = (Font) Main.rlo.getProperty("Font.gui");

	f = new JFrame(title + " (" + rlm.getServerName() + ")");
	contentPane = f.getContentPane();
	GridBagConstraints gbc = new GridBagConstraints();
	caption = new JLabel();
	textfield = new JTextField("", 31);
	buttonPanel = new JPanel();

	contentPane.setLayout(new GridBagLayout());
	textfield.setFont(guiFont);
	caption.setFont(guiFont);

	f.addWindowListener(this);

	gbc.gridx = 0; gbc.gridy = 0;
	gbc.weightx = 1; gbc.weighty = 1;
	gbc.fill = GridBagConstraints.BOTH;
	gbc.anchor = GridBagConstraints.WEST;
	gbc.insets = 
	    (Insets) Main.rlo.getProperty("BorderInsets");
	contentPane.add(caption, gbc);
	gbc.gridx = 0; gbc.gridy = 1;
	gbc.weightx = 1; gbc.weighty = 1;
	gbc.fill = GridBagConstraints.BOTH;
	gbc.anchor = GridBagConstraints.CENTER;
	contentPane.add(textfield, gbc);
	gbc.gridx = 0; gbc.gridy = 2;
	gbc.fill = GridBagConstraints.NONE;
	contentPane.add(buttonPanel, gbc);

	textfield.requestFocus();
	rlm.getInterface().registerChild(this);
    }

    public void show() {
	f.pack();

	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension w = f.getSize();
		
	f.setLocation((d.width / 2) - (w.width / 2), 
		      (d.height / 2) - (w.height / 2));

	f.show();
    }

    public void addButtons(String[] b) {
	buttons = new JButton[b.length];
	for(int i=0; i<b.length; i++) {
	    buttons[i] = new JButton(b[i]);
	    buttons[i].setFont(guiFont);
	    buttons[i].addActionListener(this);
	    buttonPanel.add(buttons[i]);	    
	}
    }

    /**
     * Following method implements Child.
     */
    public void close() {
	f.dispose();
    }

    public void displayPropertyChanged(String what, Object property) {
    }

    /**
     * Following method implements ActionListener.
     */
    public abstract void actionPerformed(ActionEvent e);

    /**
     * Following methods implement WindowListener.
     */
    public void windowActivated(WindowEvent e) { }
    public void windowDeactivated(WindowEvent e) { }
    public void windowClosed(WindowEvent e) { }
    public void windowClosing(WindowEvent e) {
	rlm.getInterface().unregisterChild(this);
	close();
    }
    public void windowIconified(WindowEvent e) { }
    public void windowDeiconified(WindowEvent e) { }
    public void windowOpened(WindowEvent e) {}
	
}

