/*
 * Decompiled with CFR 0.152.
 */
package redlight.server;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import redlight.crypto.UnixCrypt;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServer;
import redlight.hotline.HLServerAccountsTable;
import redlight.hotline.HLServerDispatcher;
import redlight.server.Main;
import redlight.server.ShutdownException;
import redlight.server.TerminateSessionException;
import redlight.utils.BytesFormat;
import redlight.utils.DebuggerOutput;
import redlight.utils.HTMLStripperInputStream;
import redlight.utils.TextUtils;
import redlight.utils.TimeFormat;

public class Console
extends Thread {
    boolean interrupted = false;
    String consolePassword = null;
    ServerSocket serverSocket;
    Socket client;
    HLServer hls;
    DataOutputStream outputStream;
    LineNumberReader lineReader;
    File initFile;
    Command[] commands = new Command[]{new Command("help [CMD]", "show this message"){

        public void perform(String[] args) throws IOException {
            if (args.length > 1) {
                URL u;
                Command c = Console.this.resolveCommand(args[1], false);
                if (c != null) {
                    Console.this.writeln(c.command);
                    args[1] = c.command.indexOf(32) != -1 ? c.command.substring(0, c.command.indexOf(32)) : c.command;
                }
                if ((u = ClassLoader.getSystemResource("redlight/Documentation/rld/" + args[1] + ".ihtml")) == null) {
                    Console.this.writeln("No help found for '" + args[1] + "'.");
                    return;
                }
                try {
                    LineNumberReader lr = new LineNumberReader(new InputStreamReader(new HTMLStripperInputStream(u.openStream())));
                    String line = lr.readLine();
                    while (line != null) {
                        Console.this.writeln(line);
                        line = lr.readLine();
                    }
                    if (args[1].equals("set")) {
                        Console.this.writeln("List of valid NAMEs:");
                        Enumeration en = Main.symbolTable.getSymbols();
                        while (en.hasMoreElements()) {
                            String symbol = (String)en.nextElement();
                            Console.this.writeln(TextUtils.pad(symbol, 25) + ": " + Main.symbolTable.getDescription(symbol) + ".");
                        }
                    }
                }
                catch (IOException e) {}
            } else {
                Console.this.write(Main.copyright);
                Console.this.writeln("Commands:");
                Console.this.writeln();
                int i = 0;
                while (i < Console.this.commands.length) {
                    Console.this.writeln("   " + TextUtils.pad(Console.this.commands[i].command, 20) + " " + Console.this.commands[i].description + ".");
                    ++i;
                }
                Console.this.writeln();
                Console.this.writeln("Commands can be abbreviated to their shortest unique prefix.");
                Console.this.writeln();
            }
        }
    }, new Command("adduser LOGIN [PASS [PRIV [NICK]]]", "create new account"){

        public void perform(String[] args) throws IOException {
            if (args.length < 2) {
                Console.this.writeln("Must specify LOGIN.");
                return;
            }
            String l = args[1];
            String p = "guest";
            long pr = 0L;
            String n = l;
            if (args.length > 2) {
                p = args[2];
                if (args.length > 3) {
                    try {
                        pr = Long.parseLong(args[3]);
                    }
                    catch (NumberFormatException e) {
                        Console.this.writeln("'" + args[3] + "' is not a number.");
                        return;
                    }
                    if (args.length > 4) {
                        n = args[4];
                    }
                }
            }
            try {
                HLServerAccountsTable accountsTable = Console.this.hls.getAccountsTable();
                accountsTable.lock();
                if (!accountsTable.exists(l)) {
                    HLProtocol.AccountInfo newAccount = Main.hlp.new HLProtocol.AccountInfo(l, n, UnixCrypt.crypt("aa", p), pr, null);
                    String accountCreateAllowed = Console.this.hls.getHLServerPolicy().approveAccountCreate(newAccount);
                    if (accountCreateAllowed == null) {
                        accountsTable.put(l, newAccount);
                        Console.this.writeln("Created account '" + l + "'.");
                    } else {
                        Console.this.writeln("Could not create account '" + l + "': " + accountCreateAllowed);
                    }
                } else {
                    Console.this.writeln("Could not create account '" + l + "' because it already exists.");
                }
                accountsTable.unlock();
            }
            catch (InterruptedException e) {
                Console.this.writeln("Could not lock accounts table.");
            }
        }
    }, new AccountCommand("deluser LOGIN...", "delete account", true){

        public void perform(HLProtocol.AccountInfo account) throws IOException {
            String l;
            HLServerAccountsTable accountsTable = Console.this.hls.getAccountsTable();
            if (accountsTable.exists(l = account.login)) {
                String accountDeleteAllowed = Console.this.hls.getHLServerPolicy().approveAccountDelete(accountsTable.get(l));
                if (accountDeleteAllowed == null) {
                    accountsTable.remove(l);
                    Console.this.writeln("Deleted account '" + l + "'.");
                } else {
                    Console.this.writeln("Could not delete account '" + l + "': " + accountDeleteAllowed);
                }
            } else {
                Console.this.writeln("Could not delete account '" + l + "' because it does not exist.");
            }
        }
    }, new AccountCommand("listusers [LOGIN...]", "list accounts", false){

        public void perform(String[] args) throws IOException {
            Console.this.writeln(" login             | nick              | privileges    | home directory");
            Console.this.writeln("-------------------+-------------------+---------------+------------------");
            super.perform(args);
        }

        public void perform(HLProtocol.AccountInfo account) throws IOException {
            String row = " " + TextUtils.pad(account.login, 16);
            row = row + " | ";
            row = row + TextUtils.pad(account.nick, 16);
            row = row + " | ";
            row = row + TextUtils.pad(new Long(account.privileges).toString(), 12);
            row = row + " | ";
            row = account.homeDirectory == null ? row + "<default>" : row + account.homeDirectory;
            Console.this.writeln(row);
        }
    }, new Command("status", "show server status"){

        public void perform(String[] args) throws IOException {
            Console.this.writeln("Settings (see also 'help set'):");
            Console.this.writeln("");
            String symbol = null;
            Enumeration en = Main.symbolTable.getSymbols();
            while (en.hasMoreElements()) {
                symbol = (String)en.nextElement();
                Console.this.writeln(TextUtils.pad(Main.symbolTable.getDescription(symbol), 25) + ": " + Main.symbolTable.get(symbol));
            }
            Console.this.writeln("");
            Console.this.writeln("Running totals:");
            Console.this.writeln("");
            Console.this.writeln("Since                     : " + new Date(Console.this.hls.uptime) + " (" + TimeFormat.format((System.currentTimeMillis() - Console.this.hls.uptime) / 1000L) + ")");
            Console.this.writeln("Currently connected       : " + Console.this.hls.getClients().length);
            Console.this.writeln("Downloads in progress     : " + Console.this.hls.downloadsInProgress);
            Console.this.writeln("Uploads in progress       : " + Console.this.hls.uploadsInProgress);
            Console.this.writeln("Downloads in queue        : " + Console.this.hls.downloadsInQueue);
            Console.this.writeln("Uploads in queue          : " + Console.this.hls.uploadsInQueue);
            Console.this.writeln("Connection peak           : " + Console.this.hls.connectionPeak);
            Console.this.writeln("Connection counter        : " + Console.this.hls.connectionCounter);
            Console.this.writeln("Download counter          : " + Console.this.hls.downloadCounter);
            Console.this.writeln("Upload counter            : " + Console.this.hls.uploadCounter);
        }
    }, new Command("set NAME [VALUE]", "set or unset parameter"){

        public void perform(String[] args) throws IOException {
            if (args.length < 2) {
                Console.this.writeln("NAME omitted.");
                return;
            }
            String newValue = args.length == 2 ? null : Console.glueArgs(2, args).trim();
            Console.this.writeln(Main.symbolTable.put(args[1].trim(), newValue));
        }
    }, new Command("xfkill XFREF", "kill transfer"){

        public void perform(String[] args) throws IOException {
            int xfref;
            if (args.length < 2) {
                Console.this.writeln("Must specify XFREF.");
                return;
            }
            try {
                xfref = Long.decode("0x" + args[1]).intValue();
            }
            catch (NumberFormatException e) {
                Console.this.writeln("Not a number: " + e.getMessage());
                return;
            }
            Enumeration en = Console.this.hls.getTransferRequests();
            while (en.hasMoreElements()) {
                HLServer.TransferRequest tr = (HLServer.TransferRequest)en.nextElement();
                if (tr.ref != xfref) continue;
                Console.this.hls.getTransferQueue().destroy(tr.ref);
                Console.this.writeln("Killed " + tr.local.getFile().getName() + ".");
                return;
            }
        }
    }, new Command("xflist", "list transfers"){

        public void perform(String[] args) throws IOException {
            Console.this.writeln("    xfref | type |  sock | state | progress        | filename");
            Console.this.writeln("----------+------+-------+-------+-----------------+-------------");
            Enumeration en = Console.this.hls.getTransferRequests();
            while (en.hasMoreElements()) {
                HLServer.TransferRequest tr = (HLServer.TransferRequest)en.nextElement();
                String row = " " + TextUtils.prepad(Integer.toHexString(tr.ref), 7) + " | ";
                row = tr.type == 1 ? row + "up  " : row + "down";
                row = row + " | ";
                if (tr.client != null) {
                    HLProtocol.UserListComponent u = tr.client.getUser();
                    row = row + TextUtils.prepad(new Integer(u.sock).toString(), 4);
                } else {
                    row = row + "  ???";
                }
                row = row + " | ";
                row = tr.queuePosition == 0 && !tr.lock ? row + "wait " : (tr.queuePosition == 0 && tr.lock ? row + "xfer " : row + "queue");
                row = row + " | ";
                if (tr.queuePosition == 0 && !tr.lock) {
                    row = row + "               ";
                } else if (tr.queuePosition == 0 && tr.lock) {
                    row = tr.progressDone > 0L ? row + TextUtils.prepad("" + (int)(100.0 * ((double)tr.progressDone / (double)tr.totalSize)), 2) : row + "  0";
                    row = row + "% / " + TextUtils.prepad(BytesFormat.format(tr.totalSize), 7);
                } else {
                    row = row + TextUtils.prepad("#" + TextUtils.prepadCharacter(new Integer(tr.queuePosition).toString(), 2, '0'), 14);
                }
                row = row + " | ";
                row = row + tr.local.getFile().getName();
                Console.this.writeln(row);
                if (!DebuggerOutput.on) continue;
                Console.this.writeln(tr.toString());
            }
        }
    }, new Command("shutdown [MSG]", "takes thee server down"){

        public void perform(String[] args) throws IOException {
            String reason = Console.glueArgs(1, args);
            throw new ShutdownException(reason);
        }
    }, new Command("quit [MSG]", "quit console (shutdown if console on stdin)"){

        public void perform(String[] args) throws IOException {
            String reason = Console.glueArgs(1, args);
            throw new TerminateSessionException(reason);
        }
    }, new Command("version", "show program version"){

        public void perform(String[] args) throws IOException {
            Console.this.writeln();
            Console.this.writeln(Main.getVersionString());
        }
    }, new Command("message MSG", "broadcast administrator message"){

        public void perform(String[] args) throws IOException {
            String msg = Console.glueArgs(1, args);
            if (msg == null) {
                Console.this.writeln("Won't send empty message.");
            } else {
                Console.this.writeln("Broadcasting: '" + msg + "'");
                Console.this.hls.broadcastAdministratorMessage(msg);
            }
        }
    }, new SocketCommand("clients [SOCK...]", "show connections", false){

        public void perform(HLServerDispatcher client) throws IOException {
            HLProtocol.UserListComponent u = client.getUser();
            String row = TextUtils.prepad(new Integer(u.sock).toString(), 5) + " | " + TextUtils.prepad(new Integer(u.icon).toString(), 5) + " | " + TextUtils.pad(client.client.getInetAddress().getHostAddress(), 14) + " | ";
            char[] flags = new char[]{' ', ' ', ' ', ' ', ' '};
            if ((u.clr & 1) == 1) {
                flags[0] = 73;
            }
            if ((u.clr & 2) == 2) {
                flags[1] = 65;
            }
            row = row + new String(flags) + " | " + u.nick;
            Console.this.writeln(row);
        }

        public void perform(String[] args) throws IOException {
            Console.this.writeln("  sock |   icon | address         | flags | nick");
            Console.this.writeln("-------+--------+-----------------+-------+------------");
            super.perform(args);
        }
    }, new SocketCommand("info SOCK...", "get info on clients", true){

        public void perform(HLServerDispatcher client) throws IOException {
            Console.this.writeln(Console.this.hls.getUserInfo(client.sock));
        }
    }, new SocketCommand("kick SOCK...", "kick user", true){

        public void perform(HLServerDispatcher client) throws IOException {
            if (Console.this.hls.kickUser(client.sock, false)) {
                Console.this.writeln("Kicked " + client.sock);
            } else {
                Console.this.writeln("Can't kick " + client.sock);
            }
        }
    }, new SocketCommand("ban SOCK...", "ban user", true){

        public void perform(HLServerDispatcher client) throws IOException {
            if (Console.this.hls.kickUser(client.sock, true)) {
                Console.this.writeln("Banned " + client.sock);
            } else {
                Console.this.writeln("Can't ban " + client.sock);
            }
        }
    }, new Command("debug", "enable / disable debug spew"){

        public void perform(String[] args) throws IOException {
            String msg = Console.glueArgs(1, args);
            Main.DebugOutputEnabled = !Main.DebugOutputEnabled;
            DebuggerOutput.setEnabled(Main.DebugOutputEnabled);
            Console.this.write("Debugging output ");
            Console.this.writeln(Main.DebugOutputEnabled ? "enabled." : "disabled.");
        }
    }};

    Console(HLServer hls, File initFile) {
        this.hls = hls;
        this.setName("Console " + this.serverSocket);
        this.initFile = initFile;
        this.start();
    }

    public synchronized void run() {
        DebuggerOutput.debug("Console starting ...");
        try {
            if (this.initFile.isFile() && this.initFile.exists() && this.initFile.canRead()) {
                DebuggerOutput.debug("Console parsing init file ...");
                FileInputStream fis = new FileInputStream(this.initFile);
                this.setIO(fis, null);
                this.prompt();
                DebuggerOutput.debug("Console parsing init file: done.");
            }
            while (!this.interrupted && Main.symbolTable.get("admin.console") != null) {
                block17: {
                    try {
                        this.setupIO();
                        if (this.auth()) {
                            this.prompt();
                        }
                    }
                    catch (IOException e) {
                        try {
                            if (e.getMessage() != null) {
                                this.writeln(e.getMessage());
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        DebuggerOutput.debug("Exception in auth prompt loop:");
                        DebuggerOutput.stackTrace(e);
                        Main.logLine("Closing administrator console connection.");
                        if (e instanceof ShutdownException) {
                            throw e;
                        }
                        if (Main.symbolTable.get("admin.console") == null) break block17;
                        if (this.serverSocket == null && Main.symbolTable.get("admin.console").equals("stdin")) {
                            throw new ShutdownException(e.getMessage());
                        }
                        this.terminateSession();
                    }
                }
                DebuggerOutput.debug("Console: interrupted = " + this.interrupted);
            }
        }
        catch (IOException e) {
            DebuggerOutput.debug("Exception in large loop:");
            DebuggerOutput.stackTrace(e);
            this.terminateServer(e.getMessage());
        }
        if (Main.symbolTable.get("admin.console") == null && !this.interrupted) {
            try {
                this.writeln("Disabling console ...");
            }
            catch (IOException e) {
                // empty catch block
            }
            this.terminateSession();
            Main.logLine("Administrator console disabled.");
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        DebuggerOutput.debug("Console exiting");
    }

    void setupIO() throws IOException {
        String hostPort;
        if (Main.symbolTable.get("admin.console") == null) {
            Main.symbolTable.put("admin.console", "stdin");
        }
        if (Main.symbolTable.get("admin.console").equals("stdin")) {
            this.terminateSession();
            try {
                this.setIO(System.in, System.out);
            }
            catch (IOException e) {
                throw new TerminateSessionException(e.getMessage());
            }
        }
        String host = hostPort = Main.symbolTable.get("admin.console");
        int port = this.hls.getPort() + 2;
        if (hostPort.lastIndexOf(58) != -1) {
            try {
                port = Integer.parseInt(hostPort.substring(hostPort.lastIndexOf(58) + 1).trim());
            }
            catch (NumberFormatException e) {
                throw new TerminateSessionException("admin.console property has illegal value " + e.getMessage());
            }
            host = hostPort.substring(0, hostPort.lastIndexOf(58));
        }
        InetAddress address = InetAddress.getByName(host);
        Main.logLine("Administrator console on " + address + ", port " + port);
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(port, 0, address);
        }
        this.tcpAccept();
        this.setIO(this.client.getInputStream(), this.client.getOutputStream());
    }

    void tcpAccept() throws IOException {
        while (!this.interrupted) {
            try {
                this.serverSocket.setSoTimeout(5000);
                this.client = this.serverSocket.accept();
                this.client.setSoTimeout(10000);
                Main.logLine("Accepted administrator console connection.");
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                // empty catch block
            }
        }
        throw new TerminateSessionException("interrupted");
    }

    void setIO(InputStream input, OutputStream output) throws IOException {
        this.lineReader = new LineNumberReader(new InputStreamReader(input));
        this.outputStream = output == null ? null : new DataOutputStream(output);
    }

    void terminateSession() {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void terminateServer(String reason) {
        try {
            this.writeln("Shutting down ...");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.hls.shutdown(reason);
        this.hls = null;
    }

    public void writeln() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.write(new String("\n").getBytes());
        }
    }

    public void writeln(String s) throws IOException {
        if (this.outputStream != null) {
            this.outputStream.write(new String(s + "\n").getBytes());
        }
    }

    public void write(String s) throws IOException {
        if (this.outputStream != null) {
            this.outputStream.write(s.getBytes());
        }
    }

    boolean auth() throws IOException {
        String cpw = Main.symbolTable.get("admin.password");
        Main.logLine("Authenticating login from " + (this.client != null ? this.client.getInetAddress().toString() : "stdin") + " ...");
        if (cpw == null) {
            Main.logLine("No authentication required.");
            return true;
        }
        this.write("Password: ");
        String pw = this.lineReader.readLine();
        if (pw == null) {
            throw new TerminateSessionException("didn't get password");
        }
        if (pw.equals(cpw)) {
            Main.logLine("Successfully authenticated.");
            return true;
        }
        Main.logLine("Authentication failed.");
        try {
            Thread.currentThread();
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw new TerminateSessionException("Authentication failed.");
    }

    void prompt() throws IOException {
        if (this.client != null) {
            this.client.setSoTimeout(300000);
        }
        this.writeln("Welcome to rld.");
        this.writeln("Type 'help' for help.");
        this.writeln("");
        this.write("> ");
        String line = this.lineReader.readLine();
        while (line != null) {
            DebuggerOutput.debug("Console.prompt: read line: " + line);
            this.doCommand(line);
            this.write("> ");
            line = this.lineReader.readLine();
        }
    }

    void doCommand(String line) throws IOException {
        line.trim();
        if (line.startsWith("#") || line.equals("")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(line);
        String[] args = new String[st.countTokens()];
        if (args.length == 0) {
            return;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            args[i] = st.nextToken();
            ++i;
        }
        Command c = this.resolveCommand(args[0], true);
        if (c != null) {
            DebuggerOutput.debug("Console.doCommand: executing: " + line);
            c.perform(args);
        }
    }

    Command resolveCommand(String c, boolean complain) throws IOException {
        String command = c;
        int matches = 0;
        int matchPos = -1;
        int i = 0;
        while (i < this.commands.length) {
            if (this.commands[i].command.startsWith(command)) {
                ++matches;
                matchPos = i;
            }
            ++i;
        }
        if (matches == 0) {
            if (complain) {
                this.writeln("Unknown command. Try help.");
            }
        } else {
            if (matches == 1) {
                return this.commands[matchPos];
            }
            if (complain) {
                this.writeln("Ambiguous command. Try help.");
            }
        }
        return null;
    }

    static String glueArgs(int from, String[] args) {
        String tmp = "";
        int i = from;
        while (i < args.length) {
            tmp = tmp + args[i] + " ";
            ++i;
        }
        return tmp.equals("") ? null : tmp.trim();
    }

    public void interrupt() {
        this.interrupted = true;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
        try {
            if (this.lineReader != null) {
                this.lineReader.close();
            }
        }
        catch (IOException e) {
            DebuggerOutput.stackTrace(e);
        }
        super.interrupt();
    }

    abstract class Command {
        String command;
        String description = "command";

        Command(String command, String description) {
            this.command = command;
            this.description = description;
        }

        public abstract void perform(String[] var1) throws IOException;
    }

    abstract class SocketCommand
    extends Command {
        private boolean socketsRequired;

        SocketCommand(String command, String description, boolean socketsRequired) {
            super(command, description);
            this.socketsRequired = socketsRequired;
        }

        public abstract void perform(HLServerDispatcher var1) throws IOException;

        public void perform(String[] args) throws IOException {
            if (args.length == 1 && this.socketsRequired) {
                Console.this.writeln("'" + this.command + "' requires socket arguments. Try help.");
                return;
            }
            HLServerDispatcher[] clients = Console.this.hls.getClients();
            try {
                int i = 0;
                while (i < clients.length) {
                    if (clients[i].sock != -1) {
                        if (args.length == 1) {
                            this.perform(clients[i]);
                        } else {
                            int j = 1;
                            while (j < args.length) {
                                if (Integer.parseInt(args[j]) == clients[i].sock) {
                                    this.perform(clients[i]);
                                }
                                ++j;
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (NumberFormatException e) {
                Console.this.writeln("Invalid socket: " + e.getMessage());
            }
        }
    }

    abstract class AccountCommand
    extends Command {
        private boolean accountsRequired;

        AccountCommand(String command, String description, boolean accountsRequired) {
            super(command, description);
            this.accountsRequired = accountsRequired;
        }

        public abstract void perform(HLProtocol.AccountInfo var1) throws IOException;

        public void perform(String[] args) throws IOException {
            if (args.length == 1 && this.accountsRequired) {
                Console.this.writeln("'" + this.command + "' requires account arguments. Try help.");
                return;
            }
            try {
                HLServerAccountsTable accountsTable = Console.this.hls.getAccountsTable();
                accountsTable.lock();
                HLProtocol.AccountInfo[] accounts = accountsTable.list();
                int i = 0;
                while (i < accounts.length) {
                    if (args.length == 1) {
                        this.perform(accounts[i]);
                    } else {
                        int j = 1;
                        while (j < args.length) {
                            if (args[j].equals(accounts[i].login)) {
                                this.perform(accounts[i]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                accountsTable.unlock();
            }
            catch (InterruptedException e) {
                Console.this.writeln("Could not lock accounts table.");
            }
        }
    }
}

