/*
 * Decompiled with CFR 0.152.
 */
package redlight.rltools;

import java.io.IOException;
import java.net.InetAddress;
import redlight.hotline.HLClient;
import redlight.hotline.HLException;
import redlight.rltools.rltest;

class TestThread
extends Thread {
    InetAddress host;
    int id;
    int numberOfLoops;
    int port;

    TestThread(ThreadGroup tg, int id, InetAddress host, int port, int numberOfLoops) {
        super(tg, "TestThread " + id);
        this.numberOfLoops = numberOfLoops;
        this.host = host;
        this.port = port;
        this.id = id;
        this.start();
    }

    public void run() {
        System.out.println("TestThread[" + this.id + "]: started");
        int currentLoop = 0;
        while (this.numberOfLoops == 0 || currentLoop < this.numberOfLoops) {
            try {
                HLClient hlc = new HLClient(this.host, this.port);
                System.out.println("TestThread[" + this.id + "]: connecting...");
                hlc.connect();
                System.out.println("TestThread[" + this.id + "]: logging in...");
                hlc.login("guest", "", "rltest " + this.id, 2505);
                int sleepTime = (int)(Math.random() * (double)rltest.ONLINE_TIME_MAX);
                System.out.println("TestThread[" + this.id + "]: sleeping for " + sleepTime + " ms...");
                Thread.currentThread();
                Thread.sleep(sleepTime);
                System.out.println("TestThread[" + this.id + "]: woke up, closing connection");
                hlc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (HLException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int sleepTime = (int)(Math.random() * (double)rltest.OFFLINE_TIME_MAX);
            System.out.print("TestThread[" + this.id + "]: sleeping for " + sleepTime + " ms ");
            if (this.numberOfLoops != 0 && currentLoop == this.numberOfLoops - 1) {
                System.out.println("before going down...");
            } else {
                System.out.println("before going online again...");
            }
            try {
                Thread.currentThread();
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++currentLoop;
        }
        System.out.println("TestThread[" + this.id + "]: exiting");
    }
}

