/*
 * Decompiled with CFR 0.152.
 */
package redlight.macfiles;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import redlight.macfiles.Fork;
import redlight.macfiles.MacBinaryMacFile;
import redlight.macfiles.MacFile;
import redlight.utils.DebuggerOutput;

public abstract class MacBinaryFork
extends Fork {
    byte[] pad = new byte[128];

    public MacBinaryFork(MacFile parent) {
        super(parent);
    }

    public DataOutput getDataOutput() {
        return ((MacBinaryMacFile)this.parent).getRandomAccessFile();
    }

    public DataInput getDataInput() {
        return ((MacBinaryMacFile)this.parent).getRandomAccessFile();
    }

    public void close(long len) throws IOException {
        try {
            DebuggerOutput.debug("MacBinaryFork: padding (len = " + len + ")");
            int padlen = 128 - (int)len % 128;
            if (padlen != 128) {
                ((MacBinaryMacFile)this.parent).getRandomAccessFile().write(this.pad, 0, padlen);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean delete() {
        return false;
    }

    public boolean exists() {
        return false;
    }
}

