/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline.iconlib;

import redlight.hotline.iconlib.HLData;
import redlight.hotline.iconlib.HLDataHdr;
import redlight.utils.DebuggerOutput;

public abstract class HLUtils {
    public static int signedToUnsigned(byte b) {
        if (b < 0) {
            return 128 + (128 + b);
        }
        return b;
    }

    public static int signedToUnsigned(short s) {
        if (s < 0) {
            return 32768 + (32768 + s);
        }
        return s;
    }

    public static int extractInt(byte[] data, int pos) {
        int i = HLUtils.signedToUnsigned(data[pos + 0]) << 24;
        i += HLUtils.signedToUnsigned(data[pos + 1]) << 16;
        i += HLUtils.signedToUnsigned(data[pos + 2]) << 8;
        return i += HLUtils.signedToUnsigned(data[pos + 3]);
    }

    public static byte[] extractBytes(byte[] data, int pos, int length) {
        byte[] ret = new byte[length];
        int i = 0;
        while (i < length) {
            ret[i] = data[pos + i];
            ++i;
        }
        return ret;
    }

    public static HLData extractDataFieldHLData(byte[] data) {
        HLData ret = new HLData();
        ret.identity = HLUtils.extractInt(data, 0);
        ret.dataSize = HLUtils.extractInt(data, 8);
        ret.dataOffset = HLUtils.extractInt(data, 12);
        return ret;
    }

    public static HLDataHdr extractDataFieldHLDataHdr(byte[] data) {
        HLDataHdr ret = new HLDataHdr();
        ret.blockName = new String(HLUtils.extractBytes(data, 0, 4));
        ret.rowCount = HLUtils.extractInt(data, 4);
        return ret;
    }

    public static byte[] intToBytes(int val) {
        byte[] b;
        b = new byte[]{(byte)(val / 0x1000000), (byte)((val -= b[0] * 0x1000000) / 65536), (byte)((val -= b[1] * 65536) >> 8), (byte)(val -= b[2] * 256)};
        return b;
    }

    public static void copyBytes(byte[] dest, byte[] src, int destOff, int srcOff, int len) {
        int i = 0;
        while (i < len) {
            dest[destOff + i] = src[srcOff + i];
            ++i;
        }
    }

    public static void storeReversed(byte[] dest, byte[] src, int destOff, int srcOff, int len) {
        int i = 0;
        while (i < len) {
            if (srcOff + len - 1 - i < 0) {
                return;
            }
            if (destOff + i < 0) {
                return;
            }
            dest[destOff + i] = src[srcOff + len - 1 - i];
            ++i;
        }
    }

    public static void printField(byte[] field) {
        int i = 0;
        while (i < field.length) {
            System.out.print(HLUtils.signedToUnsigned(field[i]) + "     ");
            ++i;
        }
        DebuggerOutput.debug("");
    }

    public static void printFieldInt(int[] field) {
        int i = 0;
        while (i < field.length) {
            System.out.print(field[i] + "     ");
            ++i;
        }
        DebuggerOutput.debug("");
    }

    public static boolean compareBeginStr(byte[] field, String c) {
        return c.compareTo(new String(HLUtils.extractBytes(field, 0, c.length()))) == 0;
    }
}

