/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLServer;
import redlight.hotline.HLTransferServer;
import redlight.macfiles.MacFile;
import redlight.macfiles.Transferrer;
import redlight.utils.BytesFormat;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;
import redlight.utils.InterruptableInputStream;
import redlight.utils.MacFileUtils;
import redlight.utils.Meter;
import redlight.utils.MeterSource;
import redlight.utils.TimeFormat;
import redlight.utils.ToArrayConverters;

class TransferThread
extends Thread
implements Meter {
    Socket client;
    HLTransferServer transferServer;
    HLServer.TransferRequest transferRequest = null;
    long creationTime = 0L;
    boolean isAlive = false;
    private KillThread killThread;
    String file = null;
    long progress = 0L;
    long total = 0L;
    long startTime = 0L;
    MeterSource meterSource;

    TransferThread(HLTransferServer transferServer, Socket client) {
        this.transferServer = transferServer;
        this.client = client;
        this.killThread = new KillThread(client);
        this.killThread.start();
        Vector vector = transferServer.transferThreads;
        synchronized (vector) {
            transferServer.transferThreads.addElement(this);
        }
        this.start();
    }

    public void disconnect() {
        this.killThread.disconnect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block25: {
            DebuggerOutput.debug("TransferThread starting ...");
            DataInputStream xfinput = null;
            DataOutputStream xfoutput = null;
            HLProtocol.FileTransferHeader fth = null;
            this.creationTime = System.currentTimeMillis();
            this.transferServer.hls.log(this.client.getInetAddress(), "Accepted file transfer connection");
            try {
                try {
                    if (this.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    xfinput = new DataInputStream(new InterruptableInputStream(this.client.getInputStream()));
                    xfoutput = new DataOutputStream(this.client.getOutputStream());
                    fth = HLServer.hlp.new HLProtocol.FileTransferHeader(xfinput);
                    DebuggerOutput.debug("TransferThread[" + fth.ref + "]: " + fth.toString());
                    this.transferRequest = this.transferServer.hls.getTransferQueue().get(fth.ref);
                    DebuggerOutput.debug("TransferThread[" + fth.ref + "]: transferRequest = " + this.transferRequest);
                    if (this.transferRequest == null) {
                        this.transferServer.hls.log(this.client.getInetAddress(), "Cannot find transfer request ID " + fth.ref + ".");
                        Object var16_4 = null;
                        this.killThread.disconnect();
                        return;
                    }
                    DebuggerOutput.debug("TransferThread[" + fth.ref + "]: transferRequest OK");
                    this.isAlive = true;
                    this.transferRequest.transferThread = this;
                    if (this.transferRequest.cancelled) {
                        DebuggerOutput.debug("TransferThread[" + fth.ref + "]: transferRequest CANCELLED");
                        throw new InterruptedException("TransferThread[" + fth.ref + "]: transferRequest cancelled");
                    }
                    this.standInLine();
                    if (this.transferRequest.type == 1) {
                        DebuggerOutput.debug("TransferThread[" + fth.ref + "]: Receiving file ...");
                        this.client.setReceiveBufferSize(16384);
                        HLProtocol.FileTransferInfo fti = HLServer.hlp.new HLProtocol.FileTransferInfo(xfinput);
                        DebuggerOutput.debug("TransferThread[" + fth.ref + "]: " + fti.toString());
                        Transferrer transferrer = new Transferrer(0, fth.ref, this);
                        transferrer.setDataInputStream(xfinput);
                        transferrer.setDataOutputStream(xfoutput);
                        this.startMeter(transferrer, fth.ref, fti.fileName, fth.len - (long)(fti.data.length + 16));
                        DebuggerOutput.debug("TransferThread[" + fth.ref + "]: " + "Initializing local file");
                        if (this.transferRequest.local.getDataSize() == 0L) {
                            this.transferRequest.local.writeHeader(fti.fileName, fti.fileType, fti.fileCreator, fti.fileComment, fti.creationDate, fti.modificationDate, fti.finderFlags);
                        }
                        byte[] l = new byte[8];
                        xfinput.skipBytes(8);
                        xfinput.readFully(l, 0, 8);
                        long size = ToArrayConverters.byteArrayToLong(l);
                        DebuggerOutput.debug("TransferThread[" + fth.ref + "]: " + "Receiving data fork (" + size + " bytes).");
                        this.transferRequest.local.getDataFork().seek(this.transferRequest.local.getDataFork().size());
                        try {
                            transferrer.transferDataFork(xfinput, this.transferRequest.local.getDataFork().getDataOutput(), size);
                            Object var10_17 = null;
                            this.transferRequest.local.setDataSize(this.transferRequest.local.getDataSize() + transferrer.getDataBytesWritten());
                        }
                        catch (Throwable throwable) {
                            Object var10_18 = null;
                            this.transferRequest.local.setDataSize(this.transferRequest.local.getDataSize() + transferrer.getDataBytesWritten());
                            this.transferRequest.local.getDataFork().close();
                            throw throwable;
                        }
                        this.transferRequest.local.getDataFork().close();
                        if (fti.numberOfBlocks == 3) {
                            DebuggerOutput.debug("TransferThread[" + fth.ref + "]: " + "Expecting resource fork ...");
                            xfinput.skipBytes(8);
                            xfinput.readFully(l, 0, 8);
                            size = ToArrayConverters.byteArrayToLong(l);
                            this.transferRequest.local.getResourceFork().seek(this.transferRequest.local.getResourceFork().size());
                            DebuggerOutput.debug("TransferThread[" + fth.ref + "]: " + "Receiving resource fork (" + size + " bytes).");
                            try {
                                transferrer.transferResourceFork(xfinput, this.transferRequest.local.getResourceFork().getDataOutput(), size);
                                Object var12_21 = null;
                                this.transferRequest.local.setResourceSize(this.transferRequest.local.getResourceSize() + transferrer.getResourceBytesWritten());
                            }
                            catch (Throwable throwable) {
                                Object var12_22 = null;
                                this.transferRequest.local.setResourceSize(this.transferRequest.local.getResourceSize() + transferrer.getResourceBytesWritten());
                                this.transferRequest.local.getResourceFork().close();
                                throw throwable;
                            }
                            this.transferRequest.local.getResourceFork().close();
                            MacFileUtils.setFileTypeAndCreator(new File(this.transferRequest.local.getFile().getParent(), FilenameUtils.qualify(this.transferRequest.local.getFile().getName())), fti.fileType.getBytes(), fti.fileCreator.getBytes());
                        }
                        DebuggerOutput.debug("TransferThread[" + fth.ref + "]: " + "Receive OK, renaming file ...");
                        this.transferRequest.local.renameTo(new File(this.transferRequest.local.getFile().toString().substring(0, this.transferRequest.local.getFile().toString().length() - 4)));
                        xfoutput.flush();
                        xfoutput.close();
                        xfinput.close();
                        this.stopMeter(fth.ref);
                        break block25;
                    }
                    this.client.setSendBufferSize(16384);
                    DebuggerOutput.debug("TransferThread[" + fth.ref + "]: " + "Sending a file ...");
                    long dataSize = (Long)this.transferRequest.rflt.chunks.get("DATA");
                    long rsrcSize = (Long)this.transferRequest.rflt.chunks.get("MACR");
                    long dataRemaining = this.transferRequest.local.getDataFork().size() - dataSize;
                    long rsrcRemaining = this.transferRequest.local.getResourceFork().size() - rsrcSize;
                    MacFile hostPath = this.transferRequest.local;
                    if (this.transferRequest.forkOrFile != 2) {
                        HLServer.hlp.new HLProtocol.FileTransferInfo(hostPath.getFile().getName(), hostPath.getType(), hostPath.getCreator(), hostPath.getComment(), hostPath.getCreationDate(), hostPath.getModificationDate(), hostPath.getFinderFlags()).write(xfoutput);
                    }
                    Transferrer transferrer = new Transferrer(0, fth.ref, this);
                    transferrer.setDataInputStream(xfinput);
                    transferrer.setDataOutputStream(xfoutput);
                    this.startMeter(transferrer, fth.ref, this.transferRequest.local.getFile().toString(), this.transferRequest.forkOrFile == 2 ? dataRemaining : dataRemaining + rsrcRemaining);
                    if (dataRemaining < 0L) throw new IOException("Attempt to resume beyond end of file.");
                    if (rsrcRemaining < 0L) {
                        throw new IOException("Attempt to resume beyond end of file.");
                    }
                    if (this.transferRequest.forkOrFile != 2) {
                        xfoutput.write(new String("DATA").getBytes());
                        xfoutput.writeInt(0);
                        xfoutput.writeLong(dataRemaining);
                    }
                    if (dataRemaining > 0L) {
                        DebuggerOutput.debug("Sending data fork, " + dataRemaining + " bytes.");
                        this.transferRequest.local.getDataFork().seek(dataSize);
                        transferrer.transferDataFork(this.transferRequest.local.getDataFork().getDataInput(), xfoutput, dataRemaining);
                    }
                    xfoutput.write(new String("MACR").getBytes());
                    xfoutput.writeInt(0);
                    xfoutput.writeLong(rsrcRemaining);
                    if (rsrcRemaining > 0L && this.transferRequest.forkOrFile != 2) {
                        DebuggerOutput.debug("Sending resource fork, " + rsrcRemaining + " bytes.");
                        this.transferRequest.local.getResourceFork().seek(rsrcSize);
                        transferrer.transferResourceFork(this.transferRequest.local.getResourceFork().getDataInput(), xfoutput, rsrcRemaining);
                    }
                    if (!HLProtocol.asynchronousFileTransfers) {
                        try {
                            DebuggerOutput.debug("Waiting for client to close socket ...");
                            xfinput.read();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    DebuggerOutput.debug("Closing socket.");
                    xfoutput.flush();
                    xfoutput.close();
                    xfinput.close();
                    this.stopMeter(fth.ref);
                }
                catch (InterruptedException e) {
                    Object var16_6 = null;
                    this.killThread.disconnect();
                    return;
                }
                catch (IOException e) {
                    DebuggerOutput.stackTrace(e);
                    if (this.file != null) {
                        this.stopMeterWithError(this.transferRequest.ref, e);
                    }
                    Object var16_7 = null;
                    this.killThread.disconnect();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var16_8 = null;
                this.killThread.disconnect();
                throw throwable;
            }
        }
        Object var16_5 = null;
        this.killThread.disconnect();
    }

    synchronized void standInLine() throws InterruptedException, IOException {
        while (this.transferRequest.queuePosition > 0) {
            this.wait(4000L);
            try {
                if (this.client.getInputStream() == null) {
                    throw new IOException("standInLine tickle failed");
                }
            }
            catch (NullPointerException e) {
                throw new IOException("standInLine tickle failed");
            }
            if (!this.transferRequest.cancelled) continue;
            throw new InterruptedException("stand in line cancelled");
        }
    }

    synchronized void nextInLine() {
        this.notify();
    }

    public void interrupt() {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.interrupt();
    }

    public String toString() {
        String s = "TransferThread[";
        s = this.client != null ? s + "address: " + this.client.getInetAddress().toString() : s + "address: " + null;
        s = s + ", transferRequest: " + this.transferRequest;
        s = s + "]";
        return s;
    }

    public void startMeter(MeterSource ms, int key, String s, long size) {
        this.meterSource = ms;
        this.file = s;
        this.startTime = System.currentTimeMillis();
        this.total = size;
        this.transferRequest.totalSize = size;
        this.transferServer.hls.log(this.client.getInetAddress(), (this.transferRequest.type == 1 ? "Receiving file " : "Sending file ") + s + " (" + size + " bytes).");
    }

    public void progressMeter(int key, long done) {
        this.transferRequest.progressDone = done;
        this.progress = done;
    }

    public void stopMeter(int key) {
        long now = System.currentTimeMillis();
        String speed = (now - this.startTime) / 1000L == 0L ? "immeasurably fast" : BytesFormat.format(this.total / ((now - this.startTime) / 1000L)) + "/s";
        String size = this.total + " bytes" + (this.total < 1024L ? "" : " (" + BytesFormat.format(this.total) + ")");
        this.transferServer.hls.log(this.client.getInetAddress(), (this.transferRequest.type == 1 ? "Received " : "Sent ") + this.file + ", total of " + size + " in " + TimeFormat.format((now - this.startTime) / 1000L) + " (" + speed + ").");
    }

    public void stopMeterWithError(int key, Throwable t) {
        if (t instanceof Exception) {
            DebuggerOutput.stackTrace((Exception)t);
        }
        this.transferServer.hls.log(this.client.getInetAddress(), "Error " + (this.transferRequest.type == 1 ? "receiving" : "sending") + " file " + this.file + " (" + t.toString() + ").");
    }

    public MeterSource getMeterSource() {
        return this.meterSource;
    }

    class KillThread
    extends Thread {
        Integer lock = new Integer(0);
        boolean running = false;
        Socket client;

        KillThread(Socket client) {
            this.client = client;
        }

        public void disconnect() {
            Integer n = this.lock;
            synchronized (n) {
                if (this.running) {
                    return;
                }
            }
            this.synchronizedDisconnect();
        }

        private synchronized void synchronizedDisconnect() {
            DebuggerOutput.debug("TransferThread[" + TransferThread.this.transferRequest + "]: notifying killthread");
            DebuggerOutput.debug("Notifying KillThread ...");
            this.notify();
        }

        public synchronized void run() {
            DebuggerOutput.debug("KillThread started");
            try {
                DebuggerOutput.debug("KillThread sleeping ...");
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Integer n = this.lock;
            synchronized (n) {
                this.running = true;
            }
            DebuggerOutput.debug("KillThread running");
            DebuggerOutput.debug("TransferThread[" + TransferThread.this.transferRequest + "]: killthread running...");
            DebuggerOutput.debug("TransferThread[" + TransferThread.this.transferRequest + "]: closing output stream");
            try {
                this.client.getOutputStream().close();
            }
            catch (IOException e) {
                DebuggerOutput.stackTrace(e);
            }
            catch (NullPointerException e) {
                DebuggerOutput.stackTrace(e);
            }
            DebuggerOutput.debug("TransferThread[" + TransferThread.this.transferRequest + "]: closing input stream");
            try {
                this.client.getInputStream().close();
            }
            catch (IOException e) {
                DebuggerOutput.stackTrace(e);
            }
            catch (NullPointerException e) {
                DebuggerOutput.stackTrace(e);
            }
            DebuggerOutput.debug("TransferThread[" + TransferThread.this.transferRequest + "]: closing socket");
            try {
                this.client.close();
            }
            catch (IOException e) {
                DebuggerOutput.stackTrace(e);
            }
            DebuggerOutput.debug("TransferThread[" + TransferThread.this.transferRequest + "]: interrupting thread");
            try {
                TransferThread.this.nextInLine();
                this.interrupt();
                DebuggerOutput.debug("TransferThread[" + TransferThread.this.transferRequest + "]: joining thread");
                this.join();
            }
            catch (InterruptedException e) {
                DebuggerOutput.stackTrace(e);
            }
            DebuggerOutput.debug("TransferThread[" + TransferThread.this.transferRequest + "]: killthread done");
            if (TransferThread.this.transferRequest != null) {
                TransferThread.this.transferServer.hls.getTransferQueue().destroy(TransferThread.this.transferRequest.ref);
            }
            TransferThread.this.transferServer.hls.log(this.client.getInetAddress(), "File transfer connection closed.");
            Vector vector = TransferThread.this.transferServer.transferThreads;
            synchronized (vector) {
                TransferThread.this.transferServer.transferThreads.removeElement(this);
            }
            DebuggerOutput.debug("KillThread exiting");
        }
    }
}

