/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.DataInputStream;
import redlight.hotline.FileTransferThread;
import redlight.hotline.HLClient;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLTask;
import redlight.utils.DebuggerOutput;

class ReaderThread
extends Thread {
    HLClient hlc;
    DataInputStream input;
    boolean blocked = false;
    HLProtocol.Packet packet;

    ReaderThread(HLClient h, DataInputStream in) {
        this.hlc = h;
        this.input = in;
        DebuggerOutput.debug("ReaderThread[" + this + "] created");
    }

    synchronized void setBlocked(boolean b) {
        this.blocked = b;
        if (!this.blocked) {
            this.notify();
        }
    }

    synchronized void honourBlock() throws InterruptedException {
        if (this.blocked) {
            DebuggerOutput.debug("ReaderThread[" + this + "]: waiting for unblock");
            while (this.blocked) {
                this.wait(5000L);
            }
        }
    }

    public void run() {
        block7: {
            DebuggerOutput.debug("ReaderThread[" + this + "]: running");
            try {
                while (!this.isInterrupted()) {
                    this.honourBlock();
                    this.packet = this.hlc.hlp.new HLProtocol.Packet(this.input);
                    DebuggerOutput.debug("ReaderThread: got packet " + this.packet.toString());
                    if (this.packet.header.id == 65536) {
                        if (this.hlc.lockTask(this.packet.header.trans)) {
                            HLTask t = this.hlc.getTask(this.packet.header.trans);
                            if (t.type == 202 || t.type == 203) {
                                DebuggerOutput.debug("ReaderThread[" + this + "]: task[" + this.packet.header.trans + "]: dispatching file transfer in separate thread.");
                                FileTransferThread ft = new FileTransferThread(this.hlc, this.packet);
                                ft.start();
                                continue;
                            }
                            DebuggerOutput.debug("ReaderThread[" + this + "]: task[" + this.packet.header.trans + "]: dispatching...");
                            this.hlc.hlr.dispatch(this.packet);
                            continue;
                        }
                        DebuggerOutput.debug("ReaderThread[" + this + "]: task[" + this.packet.header.trans + "]: cannot lock, will not dispatch.");
                        continue;
                    }
                    DebuggerOutput.debug("ReaderThread[" + this + "]: dispatching...");
                    this.hlc.hlr.dispatch(this.packet);
                }
            }
            catch (Exception e) {
                DebuggerOutput.debug("ReaderThread[" + this + "]: exception during event dispatch:");
                DebuggerOutput.stackTrace(e);
                String reason = e.toString();
                if (e.getMessage() != null) {
                    reason = e.getMessage();
                }
                this.hlc.terminateAllTasks(reason);
                if (this.isInterrupted()) break block7;
                DebuggerOutput.debug("ReaderThread[" + this + "]: calling fireDisconnect ...");
                this.hlc.fireDisconnect(reason);
            }
        }
        DebuggerOutput.debug("ReaderThread[" + this + "] exiting");
    }
}

