/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;

public class HLBookmarkFile {
    RandomAccessFile raf;
    Hashtable props;
    File file;

    public HLBookmarkFile(File f) {
        this.file = f;
        this.props = new Hashtable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() throws IOException {
        try {
            this.raf = new RandomAccessFile(this.file, "rw");
            byte[] magic = new byte[4];
            this.raf.readFully(magic, 0, 4);
            if (!new String(magic).equals("HTsc")) throw new IOException(this.file.toString() + ": not a bookmark file");
            if (this.raf.readShort() != 1) {
                throw new IOException(this.file.toString() + ": unsupported version");
            }
            int offset = 135;
            this.props.put("login", this.getString(offset));
            this.props.put("password", this.getString(offset += 34));
            this.props.put("address", this.getString(offset += 34));
            Object var4_4 = null;
            if (this.raf == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this.raf == null) throw throwable;
            this.raf.close();
            throw throwable;
        }
        this.raf.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void store() throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.file, "rw");
            raf.write(new String("HTsc").getBytes());
            raf.writeShort(1);
            raf.write(new byte[129]);
            raf.write(this.createString("login"));
            raf.write(this.createString("password"));
            raf.write(this.createString("address"));
            int pos = (int)raf.getFilePointer();
            raf.write(new byte[460 - pos]);
            Object var4_4 = null;
            if (raf == null) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (raf == null) throw throwable;
            raf.close();
            throw throwable;
        }
        raf.close();
    }

    public File getFile() {
        return this.file;
    }

    public String get(String property) {
        return (String)this.props.get(property);
    }

    public void put(String property, String value) {
        this.props.put(property, value);
    }

    private String getString(int offset) throws IOException {
        this.raf.seek(offset);
        byte[] s = new byte[this.raf.readByte()];
        this.raf.readFully(s, 0, s.length);
        return new String(s);
    }

    private byte[] createString(String t) {
        String prop = (String)this.props.get(t);
        int len = prop.length() > 32 ? 33 : prop.length();
        byte[] buf = new byte[34];
        buf[0] = (byte)len;
        System.arraycopy(prop.getBytes(), 0, buf, 1, len);
        return buf;
    }

    public String toString() {
        return "HLBookmarkFile[" + this.file.toString() + "]";
    }
}

