/*
 * Decompiled with CFR 0.152.
 */
package redlight.hotline;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import redlight.hotline.HLProtocol;

class ComponentFactory {
    static HLProtocol hlp = new HLProtocol();

    ComponentFactory() {
    }

    static HLProtocol.DataComponent createComponent(DataInputStream din) {
        try {
            short type = din.readShort();
            switch (type) {
                case 203: {
                    return new HLProtocol.ResumeTransferComponent(hlp, din);
                }
                case 200: {
                    return new HLProtocol.FileListComponent(hlp, din);
                }
                case 300: {
                    return new HLProtocol.UserListComponent(hlp, din);
                }
                case 202: 
                case 212: {
                    return new HLProtocol.PathComponent(hlp, type, din);
                }
                case 201: {
                    return new HLProtocol.FileComponent(hlp, din);
                }
                case 208: 
                case 209: {
                    return new HLProtocol.DateComponent(hlp, type, din);
                }
            }
            return new HLProtocol.DataComponent(hlp, type, din);
        }
        catch (EOFException e) {
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static HLProtocol.DataComponent[] createPathComponents(String path, short dataType, boolean isFile) throws IOException {
        HLProtocol.DataComponent[] dataComponents = new HLProtocol.DataComponent[isFile ? 2 : 1];
        if (isFile) {
            String file = path.substring(path.lastIndexOf(58) + 1);
            dataComponents[1] = new HLProtocol.FileComponent(hlp, file);
            path = path.substring(0, path.length() - file.length());
        }
        dataComponents[0] = new HLProtocol.PathComponent(hlp, dataType, path);
        return dataComponents;
    }
}

