/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.MessageTransmit;
import redlight.client.User;
import redlight.client.UserInfoInterface;
import redlight.utils.DebuggerOutput;

class UserToolBar
extends JToolBar
implements ActionListener {
    JButton reload;
    JButton info;
    JButton priv;
    JButton msg;
    JButton kick;
    User user;
    Machine rlm;

    UserToolBar(Machine rlm, User user) {
        this.rlm = rlm;
        this.user = user;
        GridBagConstraints gbc = new GridBagConstraints();
        this.reload = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[9]));
        this.info = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[13]));
        this.msg = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[3]));
        this.priv = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[0]));
        this.kick = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[5]));
        this.reload.setActionCommand("ActivateReload");
        this.info.setActionCommand("ActivateInfo");
        this.priv.setActionCommand("ActivatePrivChat");
        this.msg.setActionCommand("ActivateMessage");
        this.kick.setActionCommand("ActivateKick");
        this.reload.setToolTipText("Reload view");
        this.priv.setToolTipText("Invite user to a private chat");
        this.info.setToolTipText("Get info on the user");
        this.msg.setToolTipText("Send a message to the user");
        this.kick.setToolTipText("Disconnect the user");
        this.reload.addActionListener(this);
        this.info.addActionListener(this);
        this.priv.addActionListener(this);
        this.msg.addActionListener(this);
        this.kick.addActionListener(this);
        this.setFloatable(false);
        this.add(this.reload);
        this.add(this.info);
        this.add(this.msg);
        this.add(this.priv);
        this.add(this.kick);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals("ActivatePrivChat")) {
                this.rlm.getHLC().requestPrivateChatCreate(this.user.sock);
            } else if (e.getActionCommand().equals("ActivateInfo")) {
                new UserInfoInterface(this.rlm, this.user);
            } else if (e.getActionCommand().equals("ActivateMessage")) {
                new MessageTransmit(this.rlm, this.user);
            } else if (e.getActionCommand().equals("ActivateKick")) {
                if ((e.getModifiers() & 1) == 1) {
                    this.rlm.getHLC().requestUserKickBan(this.user.sock);
                } else {
                    this.rlm.getHLC().requestUserKick(this.user.sock);
                }
            }
        }
        catch (IOException ex) {
            DebuggerOutput.stackTrace(ex);
        }
    }
}

