/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import redlight.client.Child;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.hotline.HLException;
import redlight.hotline.HLProtocol;

public class UserEditInterface
implements Child,
ActionListener,
WindowListener,
Runnable {
    Machine rlm;
    Container contentPane;
    JTextField login;
    JTextField password;
    JTextField nickname;
    JTextArea infoHelpText;
    JFrame f;
    JScrollPane scrollPane;
    JMenuItem deleteItems;
    JMenuItem downloadItems;
    JMenuItem openInNewWindow;
    JButton cancel;
    JButton save;
    JButton delete;
    JPanel bitPanel;
    HLProtocol.AccountInfo account;
    boolean create;
    Vector checkboxes;
    Thread getter;
    String newAccount;
    String defaultPasswordString = "0123456789";
    String[] privilegeDescriptions = new String[]{"Can rename folders", "Can delete folders", "Can create folders", "Can move files", "Can rename files", "Can download files", "Can upload files", "Can delete files", "Can delete users", "Can create users", null, null, null, "Can send chat", "Can read chat", "Can move folders", "Cannot be disconnected", "Can disconnect users", "Can post news", "Can read news", null, null, "Can modify users", "Can read users", "Can make aliases", "Can view dropboxes", "Can comment folders", "Can comment files", "Don't show agreement", "Can use any name", "Can upload anywhere", "Can get user info"};

    public UserEditInterface(Machine machine, String newAccount) {
        this(machine, null, false);
        this.newAccount = newAccount;
        this.login.setText(newAccount);
        this.getter = new Thread(this);
        this.getter.start();
    }

    public void run() {
        try {
            this.account = this.rlm.getHLC().getAccountInfo(this.newAccount);
            if (this.account != null) {
                this.infoHelpText.setText("Modify users handle, password, or privileges. To delete this user, hit Delete.");
                this.login.setText(this.account.login);
                this.nickname.setText(this.account.nick);
                this.setPrivileges(this.account.privileges);
                this.password.setEnabled(true);
                this.nickname.setEnabled(true);
                this.login.setEnabled(true);
                this.save.setEnabled(true);
                this.delete.setEnabled(true);
            } else {
                this.close();
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException e) {
            this.close();
        }
        catch (HLException e) {
            this.close();
        }
    }

    public UserEditInterface(Machine machine, HLProtocol.AccountInfo account, boolean create) {
        if (account == null) {
            HLProtocol hlp = new HLProtocol();
            account = new HLProtocol.AccountInfo(hlp);
        }
        this.rlm = machine;
        this.create = create;
        this.account = account;
        this.checkboxes = new Vector();
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame((create ? "Create" : "Modify") + " account (" + this.rlm.getServerName() + ")");
        this.contentPane = this.f.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel textfieldPanel = new JPanel();
        JLabel l1 = new JLabel("Login: ");
        JLabel l2 = new JLabel("Password: ");
        JLabel l3 = new JLabel("Nickname: ");
        JPanel userInfoPanel = new JPanel();
        this.infoHelpText = create ? new JTextArea("To create a new user, type the new user's login, password and default handle and hit Save.", 2, 20) : new JTextArea("Retrieving user info, please wait ...\n", 2, 20);
        JPanel buttonPanel = new JPanel();
        JPanel deleteButtonPanel = new JPanel();
        JPanel otherButtonPanel = new JPanel();
        this.bitPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(this.bitPanel);
        this.login = new JTextField(account.login);
        this.password = new JPasswordField(create ? "" : this.defaultPasswordString);
        this.password.addKeyListener(new KeyListener(create){
            boolean firstKey;
            private final /* synthetic */ boolean val$create;
            {
                this.firstKey = this.val$create = val$create;
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyTyped(KeyEvent e) {
                if (!this.firstKey) {
                    UserEditInterface.this.password.setText("");
                    UserEditInterface.this.password.setCaretPosition(0);
                    this.firstKey = true;
                }
            }
        });
        this.nickname = new JTextField(account.nick);
        this.cancel = new JButton("Cancel");
        this.save = new JButton("Save");
        this.delete = new JButton("Delete");
        buttonPanel.registerKeyboardAction(this, "Cancel", KeyStroke.getKeyStroke(27, 0), 2);
        buttonPanel.setLayout(new BorderLayout());
        this.bitPanel.setLayout(new GridBagLayout());
        this.bitPanel.setForeground(this.rlm.getSchemeColor("foreground"));
        this.bitPanel.setBackground(this.rlm.getSchemeColor("background"));
        this.contentPane.setLayout(gbl);
        otherButtonPanel.setLayout(new FlowLayout(2));
        textfieldPanel.setLayout(new GridBagLayout());
        userInfoPanel.setLayout(new GridBagLayout());
        EmptyBorder emptyBorder = new EmptyBorder((Insets)Main.rlo.getProperty("BorderInsets"));
        Border lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), (create ? "Create" : "Modify") + " account");
        CompoundBorder infoBorder = BorderFactory.createCompoundBorder(lineBorder, emptyBorder);
        lineBorder = BorderFactory.createEtchedBorder();
        CompoundBorder privSpacerBorder = BorderFactory.createCompoundBorder(emptyBorder, lineBorder);
        lineBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Privileges");
        CompoundBorder privBorder = BorderFactory.createCompoundBorder(lineBorder, privSpacerBorder);
        userInfoPanel.setBorder(infoBorder);
        scrollPane.setBorder(privBorder);
        deleteButtonPanel.setLayout(new FlowLayout(0));
        this.cancel.setMnemonic('C');
        this.save.setMnemonic('S');
        this.cancel.addActionListener(this);
        this.save.addActionListener(this);
        this.delete.addActionListener(this);
        if (!create) {
            this.delete.setMnemonic('D');
            this.login.setBorder(BorderFactory.createEmptyBorder());
            this.login.setEditable(false);
            this.login.setOpaque(false);
            this.login.setText(this.newAccount);
        }
        this.infoHelpText.setEditable(false);
        this.infoHelpText.setOpaque(false);
        this.infoHelpText.setLineWrap(true);
        this.infoHelpText.setWrapStyleWord(true);
        if (!create) {
            this.password.setEnabled(false);
            this.nickname.setEnabled(false);
            this.save.setEnabled(false);
            this.delete.setEnabled(false);
            this.login.setEnabled(false);
        }
        gbc.gridy = 0;
        gbc.ipadx = 4;
        gbc.ipady = 4;
        gbc.fill = 1;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        textfieldPanel.add((Component)l1, gbc);
        gbc.gridy = 1;
        textfieldPanel.add((Component)l2, gbc);
        gbc.gridy = 2;
        textfieldPanel.add((Component)l3, gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.gridy = 0;
        textfieldPanel.add((Component)this.login, gbc);
        gbc.gridy = 1;
        textfieldPanel.add((Component)this.password, gbc);
        gbc.gridy = 2;
        textfieldPanel.add((Component)this.nickname, gbc);
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        userInfoPanel.add((Component)this.infoHelpText, gbc);
        gbc.gridy = 1;
        userInfoPanel.add((Component)textfieldPanel, gbc);
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.weightx = 1.0;
        Insets oldInsets = gbc.insets;
        gbc.insets = new Insets(0, 4, 0, 4);
        gbc.ipady = 0;
        int i = 0;
        while (i < 32) {
            String description = this.privilegeDescriptions[i] == null ? "reserved" : this.privilegeDescriptions[i];
            JCheckBox b = new JCheckBox(description);
            if (this.privilegeDescriptions[i] == null) {
                b.setVisible(false);
            }
            if (!create) {
                b.setEnabled(false);
            }
            this.checkboxes.addElement(b);
            b.setFont((Font)Main.rlo.getProperty("Font.list"));
            b.setForeground(this.rlm.getSchemeColor("foreground"));
            b.setBackground(this.rlm.getSchemeColor("background"));
            this.bitPanel.add((Component)b, gbc);
            ++i;
        }
        gbc.ipady = 4;
        if (create) {
            this.setPrivileges(537682016L);
        }
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 2;
        gbc.insets = oldInsets;
        if (!create) {
            deleteButtonPanel.add(this.delete);
        }
        otherButtonPanel.add(this.cancel);
        otherButtonPanel.add(this.save);
        buttonPanel.add((Component)deleteButtonPanel, "West");
        buttonPanel.add((Component)otherButtonPanel, "East");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 12;
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        this.contentPane.add((Component)userInfoPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 12;
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        this.contentPane.add((Component)scrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 12;
        gbc.insets = new Insets(0, 8, 0, 8);
        this.contentPane.add((Component)buttonPanel, gbc);
        SwingUtilities.getRootPane(this.f).setDefaultButton(this.save);
        this.f.pack();
        this.f.setSize(300, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension w = this.f.getSize();
        this.f.setLocation(d.width / 2 - w.width / 2, d.height / 2 - w.height / 2);
        this.f.addWindowListener(this);
        this.f.show();
        if (create) {
            this.login.requestFocus();
        } else {
            this.password.requestFocus();
        }
        this.rlm.getInterface().registerChild(this);
    }

    void setPrivileges(long privs) {
        long bit = 1L;
        int i = 0;
        while (i < this.checkboxes.size()) {
            JCheckBox cb = (JCheckBox)this.checkboxes.elementAt(i);
            cb.setEnabled(true);
            if ((privs & bit) == bit) {
                cb.setSelected(true);
            }
            bit *= 2L;
            ++i;
        }
    }

    long getPrivileges() {
        long val = 0L;
        long bit = 1L;
        int i = 0;
        while (i < this.checkboxes.size()) {
            JCheckBox cb = (JCheckBox)this.checkboxes.elementAt(i);
            if (cb.isVisible() && cb.isSelected()) {
                val |= bit;
            }
            bit *= 2L;
            ++i;
        }
        return val;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getActionCommand().equals("Save")) {
                long privileges = this.getPrivileges();
                if (this.create) {
                    this.rlm.getHLC().requestAccountCreate(this.login.getText(), this.password.getText(), this.nickname.getText(), privileges);
                } else {
                    String pw = this.password.getText().equals(this.defaultPasswordString) ? null : this.password.getText();
                    this.rlm.getHLC().requestAccountModify(this.login.getText(), pw, this.nickname.getText(), privileges);
                }
            } else if (e.getActionCommand().equals("Delete")) {
                this.rlm.getHLC().requestAccountDelete(this.login.getText());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void close() {
        this.rlm.getInterface().unregisterChild(this);
        if (this.getter != null) {
            this.getter.interrupt();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UserEditInterface.this.f.dispose();
            }
        });
    }

    public void displayPropertyChanged(String what, Object property) {
        if (what.equals("listfont")) {
            int i = 0;
            while (i < this.checkboxes.size()) {
                ((JCheckBox)this.checkboxes.elementAt(i)).setFont((Font)property);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.checkboxes.size()) {
                ((JCheckBox)this.checkboxes.elementAt(i)).setBackground(this.rlm.getSchemeColor("background"));
                ((JCheckBox)this.checkboxes.elementAt(i)).setForeground(this.rlm.getSchemeColor("foreground"));
                this.bitPanel.setBackground(this.rlm.getSchemeColor("background"));
                this.bitPanel.setForeground(this.rlm.getSchemeColor("foreground"));
                ++i;
            }
        }
        this.f.repaint();
    }
}

