/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.ResumeActionListener;
import redlight.client.ResumeInterface;
import redlight.client.TransferInterface;
import redlight.hotline.HLException;
import redlight.hotline.HLProtocol;
import redlight.macfiles.MacFile;
import redlight.utils.DebuggerOutput;

public class UploadInterface
extends TransferInterface {
    int transferTask;
    String path;
    File file;
    ResumeInterface resumeUI;

    UploadInterface(Machine machine, String path, File file) {
        super(machine, file.getName());
        this.path = path;
        this.file = file;
        this.doRequest();
    }

    public void granted() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                UploadInterface.this.info.setText(UploadInterface.this.filename + "   [checking whether file exists] ");
                UploadInterface.this.repaintStatus();
            }
        });
        try {
            this.localFile = MacFile.createMacFile((String)Main.rlo.getProperty("MacFileMethod"), this.file, MacFile.READ_PERM);
        }
        catch (Exception ex) {
            this.rlm.getInterface().error("Could not upload " + this.file + ": " + ex.getMessage());
            DebuggerOutput.stackTrace(ex);
            this.close();
        }
        this.resumeUI = new ResumeInterface(this.file.getName(), this.autoResume, new ResumeActionListener(){

            public boolean canResume() {
                boolean exists = false;
                try {
                    HLProtocol.FileListComponent[] files = UploadInterface.this.rlm.getHLC().getFileList(UploadInterface.this.path);
                    String n = UploadInterface.this.localFile.getFile().getName();
                    int i = 0;
                    while (i < files.length) {
                        if (!files[i].fileType.equals("fldr") && (n.equals(files[i].fileName) || files[i].fileName.equals(n + ".hpf"))) {
                            exists = true;
                        }
                        ++i;
                    }
                }
                catch (IOException e) {
                }
                catch (HLException e) {
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return exists;
            }

            public void resumeCancelled() {
                if (!UploadInterface.this.interrupted) {
                    UploadInterface.this.close();
                }
            }

            public void resumeAnswered(boolean resume) {
                try {
                    DebuggerOutput.debug("UploadInterface.confirm: requesting file upload for " + UploadInterface.this.file + " to " + UploadInterface.this.path);
                    UploadInterface.this.setTransferTask(UploadInterface.this.rlm.getHLC().requestFileUpload(UploadInterface.this.localFile, UploadInterface.this.path, UploadInterface.this.meter, resume));
                    UploadInterface.this.info.setText(UploadInterface.this.filename + "   [waiting for server to respond]        ");
                    UploadInterface.this.repaintStatus();
                    UploadInterface.this.closeLocalFile = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    protected void interrupt() {
        if (this.resumeUI != null) {
            this.resumeUI.interrupt();
        }
        super.interrupt();
    }
}

