/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.io.IOException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.ViewInterface;
import redlight.hotline.HLProtocol;
import redlight.utils.DebuggerOutput;

public class URLHandler
implements HyperlinkListener {
    Machine rlm;
    String path;
    HLProtocol.FileListComponent file;

    public URLHandler(Machine rlm, String path, HLProtocol.FileListComponent file) {
        this.rlm = rlm;
        this.path = path;
        this.file = file;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
            try {
                if (e.getURL() == null) {
                    try {
                        HLProtocol.FileListComponent f = (HLProtocol.FileListComponent)this.file.clone();
                        this.path = this.path.substring(0, this.path.indexOf(f.fileName));
                        String pathOnServer = URLHandler.stripDoubleDot(e.getDescription().replace('/', ':'));
                        this.path = this.path + ':' + pathOnServer;
                        f.fileName = pathOnServer;
                        new ViewInterface(this.rlm, this.path, f, null);
                    }
                    catch (CloneNotSupportedException _e) {
                        DebuggerOutput.stackTrace(_e);
                    }
                } else {
                    String app = Main.rlo.getHelperApp(e.getURL());
                    if (app != null) {
                        String[] args = new String[]{app, e.getURL().toString()};
                        Runtime.getRuntime().exec(args);
                    }
                }
            }
            catch (IOException _e) {
                DebuggerOutput.stackTrace(_e);
            }
        }
    }

    private static String stripDoubleDot(String hlPath) {
        return hlPath;
    }
}

