/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import redlight.client.Child;
import redlight.client.DownloadInterface;
import redlight.client.FolderDownloadInterface;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.Scripting;
import redlight.client.ViewInterface;
import redlight.hotline.HLClientAdapter;
import redlight.hotline.HLProtocol;
import redlight.macfiles.MacFile;
import redlight.script.ScriptBroker;
import redlight.script.ScriptObject;
import redlight.script.ScriptResult;
import redlight.script.Scriptable;
import redlight.script.UnknownMessageException;
import redlight.utils.BytesFormat;
import redlight.utils.DebuggerOutput;
import redlight.utils.Meter;
import redlight.utils.MeterSource;
import redlight.utils.Queueable;
import redlight.utils.TimeFormat;

public abstract class TransferInterface
extends HLClientAdapter
implements Meter,
Queueable,
Child,
Scriptable {
    Machine rlm;
    JLabel info;
    JProgressBar progressBar;
    Container contentPane;
    MeterSource transferrer;
    boolean interrupted = false;
    boolean transferStarted = false;
    boolean taskComplete = false;
    int retryCount = 1;
    int maxRetries = 100;
    int transferTask = -1;
    int xfref = 0;
    long total;
    long startTimeMillis = 0L;
    long stallTime = 0L;
    long previousProgress = 0L;
    String filename;
    MacFile localFile = null;
    boolean closeUnregistered = false;
    Meter meter;
    boolean closeLocalFile = true;
    boolean autoResume = false;
    boolean autoRetry = false;
    String path;
    HLProtocol.FileListComponent file;
    int progressSampleCounter = 0;

    public TransferInterface(Machine rlm, String filename) {
        this.filename = filename;
        this.rlm = rlm;
        this.meter = this;
        this.maxRetries = Main.rlo.getIntegerProperty("Auto.DownloadRetries");
        ++Main.activeTransfers;
        ++rlm.getInterface().getShell().activeTransfers;
        rlm.getInterface().registerChild(this);
        rlm.getScriptBroker().addTarget(this);
        try {
            ScriptResult[] sr = rlm.getScriptBroker().executeScript(new ScriptObject(1L, this));
            this.contentPane = (Container)sr[0].getUserObject();
        }
        catch (UnknownMessageException e) {
            e.printStackTrace();
        }
        this.contentPane.setBackground(rlm.getSchemeColor("background"));
        this.contentPane.setForeground(rlm.getSchemeColor("foreground"));
        this.contentPane.setLayout(new BorderLayout());
        this.info = new JLabel(filename + "   [waiting for server to respond]        ");
        this.info.setFont((Font)Main.rlo.getProperty("Font.list"));
        this.info.setBackground(rlm.getSchemeColor("background"));
        this.info.setForeground(rlm.getSchemeColor("foreground"));
        if (Main.iconFile != null) {
            this.info.setIcon(Main.iconFile.getIconOrPlaceholder(400));
        }
        this.contentPane.add((Component)this.info, "South");
        this.progressBar = new JProgressBar(0, 0);
        this.contentPane.add((Component)this.progressBar, "Center");
    }

    public File getLocalFile() {
        if (this.localFile == null) {
            return null;
        }
        DebuggerOutput.debug("TransferInterface.getLocalFile[" + this.transferTask + "]: returning " + this.localFile.getFile().toString());
        return this.localFile.getFile();
    }

    protected void doRequest() {
        if (Main.rlo.getBooleanProperty("Toggle.QueueDownloads") && (this instanceof DownloadInterface || this instanceof ViewInterface || this instanceof FolderDownloadInterface)) {
            if (this.rlm.addTransfer(this)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TransferInterface.this.info.setText(TransferInterface.this.filename + (TransferInterface.this.retryCount > 1 ? "   [queued, retry " + TransferInterface.this.retryCount + "]" : "   [queued]   "));
                        TransferInterface.this.repaintStatus();
                    }
                });
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TransferInterface.this.info.setText(TransferInterface.this.filename + "   [waiting for server to respond]     ");
                    TransferInterface.this.repaintStatus();
                }
            });
            this.granted();
        }
    }

    void setTransferTask(int t) {
        this.transferTask = t;
        this.rlm.addTaskListener(this.transferTask, this);
    }

    public void retry(final String error) {
        this.startTimeMillis = 0L;
        this.rlm.removeTransfer(this);
        this.interrupt();
        if (this.retryCount >= this.maxRetries) {
            this.rlm.getInterface().error(this.filename + ": " + error);
            this.localFile = null;
            this.close();
            return;
        }
        this.interrupted = false;
        this.autoResume = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferInterface.this.info.setText(TransferInterface.this.filename + "   [try " + TransferInterface.this.retryCount++ + ": " + error + "]");
                TransferInterface.this.repaintStatus();
            }
        });
        new Thread(new Runnable(){

            public synchronized void run() {
                try {
                    DebuggerOutput.debug("RetryThread[" + TransferInterface.this.transferTask + "]: waiting for retry...");
                    do {
                        this.wait(5000L);
                    } while (!TransferInterface.this.taskComplete && !TransferInterface.this.interrupted);
                    DebuggerOutput.debug("RetryThread[" + TransferInterface.this.transferTask + "]: woke up from retry wait");
                    TransferInterface.this.taskComplete = false;
                    if (!TransferInterface.this.interrupted) {
                        DebuggerOutput.debug("RetryThread[" + TransferInterface.this.transferTask + "]: retrying ...");
                        TransferInterface.this.doRequest();
                    }
                }
                catch (InterruptedException e) {
                    DebuggerOutput.debug("RetryThread[" + TransferInterface.this.transferTask + "]: interrupted waiting for retry");
                }
                DebuggerOutput.debug("RetryThread[" + TransferInterface.this.transferTask + "]: exiting");
            }
        }, "RetryThread[" + this.transferTask + "]").start();
    }

    protected void interrupt() {
        this.interrupted = true;
        if (this.transferrer != null) {
            DebuggerOutput.debug("TransferInterface.interrupt: interrupting transferrer ...");
            this.transferrer.interrupt();
        }
    }

    public abstract void granted();

    public void close() {
        try {
            if (this.closeLocalFile && this.localFile != null) {
                this.localFile.close();
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.rlm.getInterface().unregisterChild(this);
        this.interrupt();
        try {
            this.rlm.getScriptBroker().executeScript(new ScriptObject(2L, this.contentPane));
        }
        catch (UnknownMessageException unknownMessageException) {
            // empty catch block
        }
        this.rlm.removeTransfer(this);
        --this.rlm.getInterface().getShell().activeTransfers;
        --Main.activeTransfers;
        this.rlm.getScriptBroker().removeTarget(this);
    }

    public void displayPropertyChanged(String what, Object property) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferInterface.this.contentPane.setBackground(TransferInterface.this.rlm.getSchemeColor("background"));
                TransferInterface.this.contentPane.setForeground(TransferInterface.this.rlm.getSchemeColor("foreground"));
                TransferInterface.this.info.setBackground(TransferInterface.this.rlm.getSchemeColor("background"));
                TransferInterface.this.info.setForeground(TransferInterface.this.rlm.getSchemeColor("foreground"));
                TransferInterface.this.contentPane.repaint();
            }
        });
    }

    public void startMeter(MeterSource ms, int ref, String f, final long size) {
        this.transferrer = ms;
        this.transferStarted = true;
        this.total = size;
        this.xfref = ref;
        DebuggerOutput.debug("TransferInterface.startMeter[" + this.transferTask + "]: total = " + this.total);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferInterface.this.info.setText(TransferInterface.this.filename + " (0 / " + BytesFormat.format(size) + ")");
                TransferInterface.this.repaintStatus();
            }
        });
        this.progressBar.setMaximum((int)(size / 10L));
    }

    boolean isStalled(long progress) {
        if (this.previousProgress == 0L) {
            this.previousProgress = progress;
            return false;
        }
        if (progress - this.previousProgress > 0L) {
            this.stallTime = 0L;
            return false;
        }
        if (this.stallTime == 0L) {
            this.stallTime = System.currentTimeMillis();
            return false;
        }
        int maxStallSeconds = Main.rlo.getIntegerProperty("Auto.StallTimeout");
        if (maxStallSeconds > 0 && System.currentTimeMillis() - this.stallTime > (long)(maxStallSeconds * 1000)) {
            this.stallTime = 0L;
            this.previousProgress = 0L;
            this.retry("Transfer stalled.");
            return true;
        }
        return false;
    }

    public void progressMeter(int ref, final long progress) {
        if (this.startTimeMillis == 0L) {
            this.startTimeMillis = System.currentTimeMillis();
        }
        if (this.isStalled(progress)) {
            return;
        }
        long bytes_d = progress;
        long time_d = System.currentTimeMillis() - this.startTimeMillis;
        final long bytes_sec = bytes_d / (time_d / 1000L + 1L);
        final long secs_left = (this.total - progress) / (bytes_sec == 0L ? 1L : bytes_sec);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferInterface.this.info.setText(TransferInterface.this.filename + " (" + BytesFormat.format(progress) + " / " + BytesFormat.format(TransferInterface.this.total) + " " + BytesFormat.format(bytes_sec) + "/s ETA: " + TimeFormat.format(secs_left) + ")");
                TransferInterface.this.progressBar.setValue((int)(progress / 10L));
                TransferInterface.this.repaintStatus();
            }
        });
        this.previousProgress = progress;
    }

    public void stopMeter(int ref) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TransferInterface.this.info.setText(TransferInterface.this.filename + " 100% (" + BytesFormat.format(TransferInterface.this.total) + ")");
                TransferInterface.this.repaintStatus();
            }
        });
        this.rlm.playAudio("filedone");
        this.close();
    }

    public void stopMeterWithError(int ref, Throwable t) {
        DebuggerOutput.debug("TransferInterface.stopMeterWithError[" + this.transferTask + "]: error = " + t.toString());
        String error = t.toString();
        if (t instanceof Exception && t.getMessage() != null) {
            error = t.getMessage();
        }
        this.retry(error);
    }

    public MeterSource getMeterSource() {
        return this.transferrer;
    }

    public void handleTransferQueuePosition(int ref, final int position) {
        DebuggerOutput.debug("TransferInterface.handleTransferQueuePosition[" + this.transferTask + "]: ref = " + ref + ", xfref = " + this.xfref);
        if (ref == this.xfref) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TransferInterface.this.info.setText(TransferInterface.this.filename + "   [remotely queued #" + position + "]   ");
                    TransferInterface.this.repaintStatus();
                }
            });
        }
    }

    public void handleTaskComplete(int task) {
        DebuggerOutput.debug("TransferInterface.handleTaskComplete[" + this.transferTask + "]: task " + task + " complete.");
        this.taskComplete = true;
    }

    public void handleTaskError(int task, String error) {
        DebuggerOutput.debug("TransferInterface.handleTaskError[" + this.transferTask + "]: task " + task + " error: " + error);
        this.taskComplete = true;
        this.retry(error);
    }

    public void gotTarget(ScriptBroker sb) {
    }

    public void lostTarget(ScriptBroker sb) {
    }

    public long getKnownMessages() {
        return 8L;
    }

    public ScriptResult executeScript(ScriptObject s) throws UnknownMessageException {
        int value = (int)s.getType();
        switch (value) {
            case 8: {
                if ((Container)s.getUserObject() != this.contentPane) break;
                this.close();
                return new ScriptResult((Scriptable)this, null);
            }
        }
        throw new UnknownMessageException("Unknown message");
    }

    public void repaintStatus() {
        this.info.repaint();
        try {
            this.rlm.getScriptBroker().executeScript(Scripting.REPAINT_MESSAGE);
        }
        catch (UnknownMessageException unknownMessageException) {
            // empty catch block
        }
    }
}

