/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import redlight.client.Child;
import redlight.client.ConnectInterface;
import redlight.client.ConnectionInterface;
import redlight.client.Error;
import redlight.client.Main;
import redlight.client.Options;
import redlight.client.Parent;
import redlight.client.TrackerTableCellRenderer;
import redlight.graphics.Spinner;
import redlight.hotline.HLBookmarkFile;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLTracker;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;

public class TrackerInterface
extends AbstractTableModel
implements Child,
ActionListener,
MouseListener,
WindowListener {
    Parent parent;
    Container contentPane;
    JButton reload;
    JTable list;
    JTextField filter;
    Spinner spinner;
    JLabel info;
    JPopupMenu popupMenu;
    JMenuItem addToBookmarks;
    JMenuItem editServers;
    JMenuItem connectToServers;
    JButton removeTracker;
    JFrame f;
    JScrollPane scrollPane;
    JComboBox trackerChoice;
    Options rlo;
    String filtertext = "";
    Hashtable trackerGetters;
    TrackerGetter currentTrackerGetter;
    HLProtocol.ServerInfo[] serverList;
    HLProtocol.ServerInfo[] filteredServerList;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    public TrackerInterface(Parent p, Options opt) {
        this.parent = p;
        this.rlo = opt;
        Font guiFont = (Font)Main.rlo.getProperty("Font.gui");
        this.f = new JFrame("Trackers");
        this.contentPane = this.f.getContentPane();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.popupMenu = new JPopupMenu();
        this.reload = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[9]));
        this.filter = new JTextField(10);
        JPanel spinnerPanel = new JPanel();
        this.spinner = new Spinner(Main.rlo.getImageSet("Spinner"), 100, 16, 16);
        this.list = new JTable(this);
        this.scrollPane = new JScrollPane(this.list);
        this.info = new JLabel("");
        this.connectToServers = new JMenuItem("Connect to selected servers");
        this.addToBookmarks = new JMenuItem("Add selection to bookmarks");
        this.editServers = new JMenuItem("Edit selected servers ...");
        this.trackerChoice = new JComboBox<String>(Main.rlo.getTrackers());
        this.removeTracker = new JButton("", new ImageIcon(Main.rlo.getImageSet("FunctionIcons")[10]));
        JLabel l1 = new JLabel("Display servers containing:");
        spinnerPanel.setLayout(new FlowLayout(2));
        this.contentPane.setLayout(gbl);
        this.addToBookmarks.setFont(guiFont);
        this.editServers.setFont(guiFont);
        this.connectToServers.setFont(guiFont);
        l1.setFont(guiFont);
        this.removeTracker.setFont(guiFont);
        this.removeTracker.setActionCommand("Remove");
        this.reload.setFont(guiFont);
        this.reload.setActionCommand("Reload");
        this.reload.setMnemonic('R');
        this.reload.setToolTipText("Reload the list of servers.");
        this.list.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.list.getColumnModel().getColumn(1).setPreferredWidth(25);
        this.list.getColumnModel().getColumn(2).setPreferredWidth(500);
        this.list.setShowVerticalLines(false);
        this.list.setDefaultRenderer(class$java$lang$Number == null ? (class$java$lang$Number = TrackerInterface.class$("java.lang.Number")) : class$java$lang$Number, new TrackerTableCellRenderer());
        this.list.setFont((Font)Main.rlo.getProperty("Font.list"));
        this.list.registerKeyboardAction(this, "Activate", KeyStroke.getKeyStroke(32, 0), 2);
        this.trackerChoice.setEditable(true);
        this.trackerChoice.addActionListener(this);
        this.trackerChoice.setToolTipText("To add a new tracker, enter it's address here and press return");
        this.info.setFont((Font)Main.rlo.getProperty("Font.info"));
        this.removeTracker.setEnabled(Main.rlo.getTrackers().length > 1);
        this.reload.addActionListener(this);
        this.filter.addActionListener(this);
        this.connectToServers.addActionListener(this);
        this.addToBookmarks.addActionListener(this);
        this.editServers.addActionListener(this);
        this.list.addMouseListener(this);
        this.removeTracker.addActionListener(this);
        this.f.addWindowListener(this);
        this.popupMenu.add(this.connectToServers);
        this.popupMenu.add(this.addToBookmarks);
        this.popupMenu.add(this.editServers);
        spinnerPanel.add(this.spinner);
        gbc.insets = (Insets)Main.rlo.getProperty("BorderInsets");
        gbc.fill = 0;
        gbc.anchor = 17;
        this.contentPane.add((Component)this.reload, gbc);
        gbc.gridx = 1;
        this.contentPane.add((Component)l1, gbc);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.contentPane.add((Component)this.filter, gbc);
        gbc.gridx = 4;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        this.contentPane.add((Component)spinnerPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        this.contentPane.add((Component)this.scrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 4;
        this.contentPane.add((Component)this.trackerChoice, gbc);
        gbc.gridx = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        this.contentPane.add((Component)this.removeTracker, gbc);
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        this.contentPane.add((Component)this.info, gbc);
        this.f.pack();
        this.f.setLocation((Point)Main.rlo.getProperty("WindowLocation.Tracker"));
        this.f.setSize((Dimension)Main.rlo.getProperty("WindowDimension.Tracker"));
        this.f.show();
        this.trackerGetters = new Hashtable();
        int i = 0;
        while (i < Main.rlo.getTrackers().length) {
            this.trackerGetters.put(Main.rlo.getTrackers()[i], new TrackerGetter(Main.rlo.getTrackers()[i], this));
            ++i;
        }
        this.trackerChoice.setSelectedIndex(this.getTrackerIndex(Main.rlo.getStringProperty("Tracker.Default")));
    }

    int getTrackerIndex(String s) {
        String[] trackers = Main.rlo.getTrackers();
        int i = 0;
        while (i < trackers.length) {
            if (s.equals(trackers[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    void filterServerList() {
        String filtertext = this.filter.getText().toUpperCase();
        Vector<HLProtocol.ServerInfo> filteredList = new Vector<HLProtocol.ServerInfo>();
        StringTokenizer st = new StringTokenizer(filtertext);
        int tokens = st.countTokens();
        String[] stComp = new String[tokens];
        int j = 0;
        while (st.hasMoreTokens()) {
            stComp[j] = st.nextToken();
            ++j;
        }
        int i = 0;
        while (i < this.serverList.length) {
            boolean found = true;
            if (tokens == 0) {
                filteredList.addElement(this.serverList[i]);
            } else {
                j = 0;
                while (j < stComp.length) {
                    if (this.serverList[i].name.toUpperCase().indexOf(stComp[j]) == -1 && this.serverList[i].desc.toUpperCase().indexOf(stComp[j]) == -1) {
                        found = false;
                    }
                    ++j;
                }
                if (found) {
                    filteredList.addElement(this.serverList[i]);
                }
            }
            ++i;
        }
        this.filteredServerList = new HLProtocol.ServerInfo[filteredList.size()];
        int i2 = 0;
        while (i2 < filteredList.size()) {
            this.filteredServerList[i2] = (HLProtocol.ServerInfo)filteredList.elementAt(i2);
            ++i2;
        }
    }

    public void show() {
        this.f.show();
        if (this.list.getSelectionModel().isSelectionEmpty() && this.list.getRowCount() > 0) {
            this.list.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.list.requestFocus();
    }

    void itemEdit(int i) {
        new ConnectInterface(this.parent, this.filteredServerList[i].getAddress(), new Integer(this.filteredServerList[i].port).toString(), "guest", "", this.filteredServerList[i].name, true);
    }

    void itemActivated(int i) {
        new ConnectionInterface(this.filteredServerList[i].getAddress(), this.filteredServerList[i].port, "guest", "", this.filteredServerList[i].name);
    }

    synchronized void notifyThreadStarting(final TrackerGetter startingThread) {
        if (startingThread == this.currentTrackerGetter) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TrackerInterface.this.info.setText(startingThread.status);
                    TrackerInterface.this.spinner.start();
                    TrackerInterface.this.reload.setEnabled(false);
                }
            });
        }
    }

    synchronized void notifyThreadFinished(final TrackerGetter finishedThread) {
        if (finishedThread == this.currentTrackerGetter) {
            this.serverList = finishedThread.serverList;
            this.filterServerList();
            this.fireTableDataChanged();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TrackerInterface.this.currentTrackerGetter.isRunning || TrackerInterface.this.currentTrackerGetter.hasFinished && !TrackerInterface.this.currentTrackerGetter.wasSuccess) {
                        TrackerInterface.this.info.setText(finishedThread.status);
                    } else {
                        TrackerInterface.this.info.setText(TrackerInterface.this.serverList.length + " servers (" + TrackerInterface.this.filteredServerList.length + " displayed).");
                    }
                    TrackerInterface.this.spinner.stop();
                    TrackerInterface.this.reload.setEnabled(true);
                }
            });
        }
    }

    public Class getColumnClass(int col) {
        if (col == 1) {
            return class$java$lang$Number == null ? (class$java$lang$Number = TrackerInterface.class$("java.lang.Number")) : class$java$lang$Number;
        }
        return class$java$lang$String == null ? (class$java$lang$String = TrackerInterface.class$("java.lang.String")) : class$java$lang$String;
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return "Name";
        }
        if (col == 1) {
            return "Users";
        }
        if (col == 2) {
            return "Description";
        }
        return "error: col = " + col;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        if (this.filteredServerList == null) {
            return 0;
        }
        return this.filteredServerList.length;
    }

    public Object getValueAt(int row, int col) {
        if (this.filteredServerList != null) {
            HLProtocol.ServerInfo server = this.filteredServerList[row];
            if (col == 0) {
                return server.name;
            }
            if (col == 1) {
                return new Short(server.nusers);
            }
            if (col == 2) {
                return server.desc;
            }
        }
        return new String("error: col = " + col);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Reload")) {
            this.currentTrackerGetter.start();
        } else if (e.getSource() == this.trackerChoice) {
            String entry = this.trackerChoice.getEditor().getItem().toString();
            Main.rlo.setStringProperty("Tracker.Default", entry);
            if (!this.trackerGetters.containsKey(entry)) {
                Main.rlo.addTracker(entry);
                this.trackerChoice.addItem(entry);
                this.currentTrackerGetter = new TrackerGetter(Main.rlo.getStringProperty("Tracker.Default"), this);
                this.trackerGetters.put(entry, this.currentTrackerGetter);
            } else {
                this.currentTrackerGetter = (TrackerGetter)this.trackerGetters.get(entry);
            }
            if (!this.currentTrackerGetter.hasFinished && !this.currentTrackerGetter.isRunning) {
                this.currentTrackerGetter.start();
            }
            this.serverList = this.currentTrackerGetter.serverList;
            this.filterServerList();
            this.fireTableDataChanged();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TrackerInterface.this.currentTrackerGetter.isRunning) {
                        TrackerInterface.this.spinner.start();
                    } else {
                        TrackerInterface.this.spinner.stop();
                    }
                    if (TrackerInterface.this.currentTrackerGetter.isRunning || TrackerInterface.this.currentTrackerGetter.hasFinished && !TrackerInterface.this.currentTrackerGetter.wasSuccess) {
                        TrackerInterface.this.info.setText(TrackerInterface.this.currentTrackerGetter.status);
                    } else {
                        TrackerInterface.this.info.setText(TrackerInterface.this.serverList.length + " servers (" + TrackerInterface.this.filteredServerList.length + " displayed).");
                    }
                    TrackerInterface.this.reload.setEnabled(!TrackerInterface.this.currentTrackerGetter.isRunning);
                    TrackerInterface.this.removeTracker.setEnabled(Main.rlo.getTrackers().length > 1);
                }
            });
        } else if (e.getActionCommand().equals("Remove")) {
            String entry = this.trackerChoice.getEditor().getItem().toString();
            if (this.trackerGetters.containsKey(entry)) {
                this.trackerGetters.remove(entry);
                Main.rlo.removeTracker(entry);
                this.trackerChoice.removeItem(entry);
                Main.rlo.setStringProperty("Tracker.Default", Main.rlo.getTrackers()[0]);
                this.trackerChoice.setSelectedItem(Main.rlo.getStringProperty("Tracker.Default"));
            }
            this.removeTracker.setEnabled(Main.rlo.getTrackers().length > 1);
        } else if (e.getSource() == this.filter) {
            this.filtertext = this.filter.getText();
            this.filterServerList();
            if (this.currentTrackerGetter.isRunning || this.currentTrackerGetter.hasFinished && !this.currentTrackerGetter.wasSuccess) {
                this.info.setText(this.currentTrackerGetter.status);
            } else {
                this.info.setText(this.serverList.length + " servers (" + this.filteredServerList.length + " displayed).");
            }
            this.fireTableDataChanged();
        } else if (e.getSource() == this.addToBookmarks) {
            int[] indices = this.list.getSelectedRows();
            int i = 0;
            while (i < indices.length) {
                HLProtocol.ServerInfo server = this.filteredServerList[indices[i]];
                String address = new String(server.getAddress());
                char port = server.port;
                address = address + ":" + new Integer(server.port).toString();
                try {
                    HLBookmarkFile bmf = new HLBookmarkFile(new File((File)Main.rlo.getProperty("Path.Bookmarks"), FilenameUtils.qualify(new String(server.name))));
                    bmf.put("address", address);
                    bmf.put("login", "guest");
                    bmf.put("password", "");
                    if (!((File)Main.rlo.getProperty("Path.Bookmarks")).exists() && !((File)Main.rlo.getProperty("Path.Bookmarks")).mkdir()) {
                        throw new IOException("cannot create " + ((File)Main.rlo.getProperty("Path.Bookmarks")).toString());
                    }
                    bmf.store();
                }
                catch (IOException ex) {
                    new Error("Could not save bookmark: " + ex.getMessage());
                }
                ++i;
            }
            this.parent.displayPropertyChanged("bookmarkentries", "");
        } else if (e.getSource() == this.editServers) {
            int[] indices = this.list.getSelectedRows();
            int i = 0;
            while (i < indices.length) {
                this.itemEdit(indices[i]);
                ++i;
            }
        } else if (e.getSource() == this.connectToServers) {
            int[] indices = this.list.getSelectedRows();
            int i = 0;
            while (i < indices.length) {
                this.itemActivated(indices[i]);
                ++i;
            }
        } else if (e.getActionCommand().equals("Activate") && this.list.getSelectedRow() != -1) {
            this.itemActivated(this.list.getSelectedRow());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && (e.getModifiers() & 0x10) == 16) {
            this.itemActivated(this.list.getSelectedRow());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.mouseReleased(e);
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.addToBookmarks.setEnabled(this.list.getSelectedRows().length != 0);
            this.popupMenu.show(this.list, e.getX(), e.getY());
        }
    }

    public void close() {
        Main.rlo.setProperty("WindowLocation.Tracker", this.f.getLocation());
        Main.rlo.setProperty("WindowDimension.Tracker", this.f.getSize());
        this.f.setVisible(false);
    }

    public void displayPropertyChanged(String what, Object property) {
        if (what.equals("listfont")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TrackerInterface.this.list.setFont((Font)Main.rlo.getProperty("Font.list"));
                    TrackerInterface.this.list.repaint();
                }
            });
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TrackerGetter
    implements Runnable {
        String status;
        String trackerName;
        boolean isRunning;
        boolean wasSuccess;
        boolean hasFinished;
        HLTracker tracker;
        TrackerInterface trackerInterface;
        HLProtocol.ServerInfo[] serverList = new HLProtocol.ServerInfo[0];
        Thread thread;

        TrackerGetter(String trackerName, TrackerInterface trackerInterface) {
            this.trackerInterface = trackerInterface;
            this.trackerName = trackerName;
            this.thread = null;
        }

        void start() {
            this.status = "Retrieving server information from " + this.trackerName;
            this.serverList = new HLProtocol.ServerInfo[0];
            this.isRunning = false;
            this.wasSuccess = true;
            this.hasFinished = false;
            if (this.thread != null) {
                throw new RuntimeException("eww, trying to start thread when it's already running");
            }
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void run() {
            block6: {
                this.isRunning = true;
                this.trackerInterface.notifyThreadStarting(this);
                try {
                    try {
                        if (this.tracker == null) {
                            this.tracker = new HLTracker(this.trackerName);
                        }
                        this.serverList = this.tracker.getServerList();
                    }
                    catch (UnknownHostException e) {
                        this.wasSuccess = false;
                        this.status = "Could not locate tracker " + this.trackerName + ".";
                        Object var4_2 = null;
                        this.thread = null;
                        this.isRunning = false;
                        this.hasFinished = true;
                        this.trackerInterface.notifyThreadFinished(this);
                        break block6;
                    }
                    catch (IOException e) {
                        DebuggerOutput.stackTrace(e);
                        this.wasSuccess = false;
                        this.status = "Error: " + this.trackerName + ":" + e.getMessage();
                        Object var4_3 = null;
                        this.thread = null;
                        this.isRunning = false;
                        this.hasFinished = true;
                        this.trackerInterface.notifyThreadFinished(this);
                    }
                    Object var4_1 = null;
                    this.thread = null;
                    this.isRunning = false;
                    this.hasFinished = true;
                    this.trackerInterface.notifyThreadFinished(this);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.thread = null;
                    this.isRunning = false;
                    this.hasFinished = true;
                    this.trackerInterface.notifyThreadFinished(this);
                    throw throwable;
                }
            }
        }

        public String toString() {
            return "TrackerGetter[trackerName = " + this.trackerName + "]";
        }
    }
}

