/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.SwingUtilities;
import redlight.client.DepthFirstFileSearch;
import redlight.client.FileSearchAction;
import redlight.client.Machine;
import redlight.client.Main;
import redlight.client.TransferInterface;
import redlight.hotline.HLProtocol;
import redlight.hotline.HLTaskErrorException;
import redlight.macfiles.MacFile;
import redlight.utils.BytesFormat;
import redlight.utils.DebuggerOutput;
import redlight.utils.FilenameUtils;
import redlight.utils.MeterSource;
import redlight.utils.TimeFormat;

public class FolderDownloadInterface
extends TransferInterface
implements Runnable {
    String path;
    HLProtocol.FileListComponent file;
    long totalSize = 0L;
    long folderProgress = 0L;
    long previousFolderProgress = 0L;
    long previousTimeMillis = 0L;
    int filesLeft = 0;
    int totalFiles = 0;
    int folderErrors = 0;
    DepthFirstFileSearch fileSearch;
    Thread downloadThread;
    int maxFolderErrors = Main.rlo.getIntegerProperty("Auto.MaxFolderErrors");
    long bytes_sec = 0L;
    long secs_left = 0L;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Integer;

    public FolderDownloadInterface(Machine machine, String path, HLProtocol.FileListComponent file) {
        super(machine, file.fileName);
        this.path = path;
        this.file = file;
        if (Main.iconFile != null) {
            this.info.setIcon(Main.iconFile.getIconForFile(file));
        }
        this.doRequest();
    }

    public synchronized void granted() {
        this.downloadThread = new Thread(this);
        this.downloadThread.setName("FolderDownload " + this.path + this.file.fileName);
        this.downloadThread.start();
    }

    public void run() {
        block18: {
            final Vector list = new Vector();
            this.fileSearch = new DepthFirstFileSearch();
            try {
                this.fileSearch.descend(this.rlm.getHLC(), this.path + ':', 0, 0, new FileSearchAction(){

                    public void fileFound(String path, HLProtocol.FileListComponent file) {
                        list.addElement(new Location(path, file));
                        FolderDownloadInterface.this.info.setText("Calculating total size ... " + path);
                        FolderDownloadInterface.this.repaintStatus();
                    }
                });
                Location l = null;
                Enumeration en = list.elements();
                while (en.hasMoreElements()) {
                    if (l != null && !l.file.fileType.equals("fldr")) {
                        this.totalSize += l.file.fileSize;
                        ++this.totalFiles;
                    }
                    l = (Location)en.nextElement();
                }
                long oldFolderProgress = 0L;
                this.filesLeft = this.totalFiles;
                this.progressBar.setMaximum((int)(this.totalSize / 100L));
                this.repaintStatus();
                Constructor<?> cs = null;
                try {
                    String macFileMethod = Main.rlo.getProperty("MacFileMethod") + "MacFile";
                    Class<?> c = Class.forName("redlight.macfiles." + macFileMethod);
                    Class[] paramTypes = new Class[]{class$java$io$File == null ? (class$java$io$File = FolderDownloadInterface.class$("java.io.File")) : class$java$io$File, class$java$lang$Integer == null ? (class$java$lang$Integer = FolderDownloadInterface.class$("java.lang.Integer")) : class$java$lang$Integer};
                    cs = c.getConstructor(paramTypes);
                }
                catch (Exception e) {
                    this.rlm.getInterface().error(this.filename + ": " + e);
                    DebuggerOutput.stackTrace(e);
                    if (!this.interrupted) {
                        this.close();
                    }
                    return;
                }
                Enumeration en2 = list.elements();
                while (en2.hasMoreElements()) {
                    block19: {
                        if (l != null && !l.file.fileType.equals("fldr")) {
                            if (Thread.currentThread().isInterrupted() || this.folderErrors > this.maxFolderErrors) {
                                DebuggerOutput.debug("FolderDownloadInterface.run: was interrupted");
                                break;
                            }
                            oldFolderProgress = this.folderProgress;
                            try {
                                String localFolder = Main.rlo.getProperty("Path.Downloads").toString();
                                StringTokenizer st = new StringTokenizer(l.path, String.valueOf(':'));
                                while (st.hasMoreTokens()) {
                                    localFolder = localFolder + System.getProperty("file.separator") + FilenameUtils.qualify(st.nextToken());
                                }
                                File destination = new File(localFolder);
                                if (!destination.exists()) {
                                    destination.mkdirs();
                                }
                                if (!destination.exists()) {
                                    ++this.folderErrors;
                                    this.rlm.getInterface().error(this.filename + ": " + "Cannot create destination folder " + destination);
                                    break block19;
                                }
                                Object[] params = new Object[]{new File(destination, FilenameUtils.qualify(l.file.fileName)), new Integer(MacFile.READ_PERM | MacFile.WRITE_PERM)};
                                this.localFile = (MacFile)cs.newInstance(params);
                                this.setTransferTask(this.rlm.getHLC().requestFileDownload(l.path + l.file.fileName, this.localFile, this, false));
                                this.rlm.getHLC().waitFor(this.transferTask);
                                Thread.currentThread();
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            catch (Exception e) {
                                ++this.folderErrors;
                                String error = e.getMessage() == null ? "Error " + e.toString() : e.getMessage();
                                this.rlm.getInterface().error(this.filename + ": " + error);
                                DebuggerOutput.stackTrace(e);
                            }
                            this.folderProgress = l.file.fileSize + oldFolderProgress;
                            --this.filesLeft;
                        }
                    }
                    l = (Location)en2.nextElement();
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                ++this.folderErrors;
                if (e instanceof HLTaskErrorException) break block18;
                String error = e.getMessage() == null ? "Error " + e.toString() : e.getMessage();
                this.rlm.getInterface().error(this.filename + ": " + error);
                DebuggerOutput.stackTrace(e);
            }
        }
        if (!this.interrupted) {
            this.close();
        }
        DebuggerOutput.debug("FolderDownloadInterface.run: exiting");
    }

    public void startMeter(MeterSource ms, int ref, String f, long size) {
        this.filename = f;
        this.transferrer = ms;
        this.xfref = ref;
        this.previousProgress = 0L;
        this.previousTimeMillis = System.currentTimeMillis();
        DebuggerOutput.debug("FolderDownloadInterface.startMeter[" + this.transferTask + "]: total = " + this.total);
        this.progressSampleCounter = 0;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FolderDownloadInterface.this.info.setText("[" + FolderDownloadInterface.this.filesLeft + "] " + FolderDownloadInterface.this.filename + " (" + BytesFormat.format(FolderDownloadInterface.this.folderProgress) + " / " + BytesFormat.format(FolderDownloadInterface.this.totalSize) + ")");
                FolderDownloadInterface.this.progressBar.setValue((int)(FolderDownloadInterface.this.folderProgress / 100L));
                FolderDownloadInterface.this.repaintStatus();
            }
        });
    }

    public void progressMeter(int ref, long progress) {
        this.folderProgress += progress - this.previousProgress;
        long time_d = System.currentTimeMillis() - this.previousTimeMillis;
        long bytes_d = this.folderProgress - this.previousFolderProgress;
        if (this.progressSampleCounter % 5 == 0) {
            this.previousTimeMillis = System.currentTimeMillis();
            this.previousFolderProgress = this.folderProgress;
            this.bytes_sec = bytes_d / (time_d / 1000L + 1L);
            this.secs_left = (this.totalSize - this.folderProgress) / (this.bytes_sec == 0L ? 1L : this.bytes_sec);
        }
        ++this.progressSampleCounter;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String text = "[" + FolderDownloadInterface.this.filesLeft + "] " + FolderDownloadInterface.this.filename + " (" + BytesFormat.format(FolderDownloadInterface.this.folderProgress) + " / " + BytesFormat.format(FolderDownloadInterface.this.totalSize);
                text = FolderDownloadInterface.this.bytes_sec != 0L ? text + " " + BytesFormat.format(FolderDownloadInterface.this.bytes_sec) + "/s ETA: " + TimeFormat.format(FolderDownloadInterface.this.secs_left) + ")" : text + ")";
                FolderDownloadInterface.this.info.setText(text);
                FolderDownloadInterface.this.progressBar.setValue((int)(FolderDownloadInterface.this.folderProgress / 100L));
                FolderDownloadInterface.this.repaintStatus();
            }
        });
        this.previousProgress = progress;
    }

    public void stopMeter(int ref) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FolderDownloadInterface.this.info.setText("[" + FolderDownloadInterface.this.filesLeft + "] " + FolderDownloadInterface.this.filename + " (" + BytesFormat.format(FolderDownloadInterface.this.folderProgress) + " / " + BytesFormat.format(FolderDownloadInterface.this.totalSize) + ") [finishing]");
                FolderDownloadInterface.this.progressBar.setValue((int)(FolderDownloadInterface.this.folderProgress / 100L));
                FolderDownloadInterface.this.repaintStatus();
            }
        });
        this.rlm.playAudio("filedone");
    }

    public void stopMeterWithError(int ref, Throwable t) {
        DebuggerOutput.stackTrace((Exception)t);
        DebuggerOutput.debug("TransferInterface.stopMeterWithError[" + this.transferTask + "]: error = " + t.toString());
        ++this.folderErrors;
        if (t instanceof Exception) {
            if (t.getMessage() == null) {
                this.rlm.getInterface().error(this.filename + ": " + "An error occurred during transfer. Perhaps the server disconnected.");
            } else {
                this.rlm.getInterface().error(this.filename + ": " + t.getMessage() + "");
            }
            this.localFile = null;
        }
    }

    public void handleTaskError(int task, String error) {
        DebuggerOutput.debug("FolderDownloadInterface.handleTaskError[" + task + "]: " + error);
    }

    protected synchronized void interrupt() {
        super.interrupt();
        if (this.fileSearch != null) {
            this.fileSearch.interrupt();
        }
        if (this.downloadThread != null) {
            this.downloadThread.interrupt();
            try {
                this.downloadThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Location {
        String path;
        HLProtocol.FileListComponent file;

        Location(String path, HLProtocol.FileListComponent file) {
            this.path = path;
            this.file = file;
        }

        public String toString() {
            return this.path + ':' + this.file.toString();
        }
    }
}

