/*
 * Decompiled with CFR 0.152.
 */
package redlight.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import redlight.client.Main;
import redlight.client.Options;

class AutoPanel
extends JPanel
implements ActionListener {
    JTextField folderErrors;
    JTextField retries;
    JTextField stallTimeout;

    AutoPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.retries = new JTextField("", 15);
        this.folderErrors = new JTextField("", 5);
        this.stallTimeout = new JTextField("", 5);
        this.retries.setToolTipText("This number determines how often Red Light will retry a transfer if an error occurs.");
        this.folderErrors.setToolTipText("For folder downloads, this number determines how many errors to tolerate before giving up.");
        this.stallTimeout.setToolTipText("If no data is received or sent on a transfer for this many seconds, it is retried. Use 0 to disable.");
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.addRow(new JLabel("Transfer retries:"), this.retries, gbc);
        this.addRow(new JLabel("Max. folder errors:"), this.folderErrors, gbc);
        this.addRow(new JLabel("Stalled transfer timeout (s):"), this.stallTimeout, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.addRow(Box.createGlue(), Box.createGlue(), gbc);
        this.setup(Main.rlo);
    }

    void addRow(Component l, Component v, GridBagConstraints gbc) {
        gbc.anchor = 17;
        gbc.fill = 0;
        this.add(l, gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add(v, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
    }

    void setup(Options o) {
        this.retries.setText(Main.rlo.getStringProperty("Auto.DownloadRetries"));
        this.folderErrors.setText(new Integer(Main.rlo.getIntegerProperty("Auto.MaxFolderErrors")).toString());
        this.stallTimeout.setText(new Integer(Main.rlo.getIntegerProperty("Auto.StallTimeout")).toString());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Save")) {
            try {
                Main.rlo.setIntegerProperty("Auto.MaxFolderErrors", new Integer(this.folderErrors.getText()));
                Main.rlo.setIntegerProperty("Auto.DownloadRetries", new Integer(this.retries.getText()));
                Main.rlo.setIntegerProperty("Auto.StallTimeout", new Integer(this.stallTimeout.getText()));
            }
            catch (NumberFormatException ex) {
                System.out.println(ex.toString() + " is not a number");
            }
        }
    }
}

