/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.xsd.DataTypeWithFacet;
import com.sun.msv.datatype.xsd.DataTypeWithLexicalConstraintFacet;
import com.sun.msv.datatype.xsd.TypeIncubator;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

public class TotalDigitsFacet
extends DataTypeWithLexicalConstraintFacet {
    public final int precision;

    public TotalDigitsFacet(String nsUri, String typeName, XSDatatypeImpl baseType, TypeIncubator facets) throws DatatypeException {
        super(nsUri, typeName, baseType, "totalDigits", facets);
        this.precision = facets.getPositiveInteger("totalDigits");
        DataTypeWithFacet o = baseType.getFacetObject("totalDigits");
        if (o != null && ((TotalDigitsFacet)o).precision < this.precision) {
            throw new DatatypeException(XSDatatypeImpl.localize("LoosenedFacet", "totalDigits", o.displayName()));
        }
    }

    protected boolean checkLexicalConstraint(String content) {
        return TotalDigitsFacet.countPrecision(content) <= this.precision;
    }

    protected void diagnoseByFacet(String content, ValidationContext context) throws DatatypeException {
        int cnt = TotalDigitsFacet.countPrecision(content);
        if (cnt <= this.precision) {
            return;
        }
        throw new DatatypeException(-1, XSDatatypeImpl.localize("DataTypeErrorDiagnosis.TooMuchPrecision", new Integer(cnt), new Integer(this.precision)));
    }

    protected static int countPrecision(String literal) {
        int len = literal.length();
        boolean skipMode = true;
        int count = 0;
        int trailingZero = 0;
        int i = 0;
        while (i < len) {
            char ch = literal.charAt(i);
            if (skipMode) {
                if ('1' <= ch && ch <= '9') {
                    ++count;
                    skipMode = false;
                }
                if ('.' == ch) {
                    skipMode = false;
                }
            } else {
                if (ch == '0') {
                    ++trailingZero;
                } else if (ch != '.') {
                    trailingZero = 0;
                }
                if ('0' <= ch && ch <= '9') {
                    ++count;
                }
            }
            ++i;
        }
        return count - trailingZero;
    }
}

