/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import com.sun.xml.bind.unmarshaller.Discarder;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.unmarshaller.UnmarshallableObject;
import com.sun.xml.bind.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.unmarshaller.UnreportedException;
import javax.xml.bind.Element;
import org.xml.sax.Attributes;

public abstract class ContentHandlerEx {
    public final UnmarshallingContext context;
    private final String stateTextTypes;
    public int state;
    private UnmarshallableObject child;

    public ContentHandlerEx(UnmarshallingContext _ctxt, String _stateTextTypes) {
        this.context = _ctxt;
        this.stateTextTypes = _stateTextTypes;
    }

    protected abstract UnmarshallableObject owner();

    public void enterElement(String uri, String local, Attributes atts) throws UnreportedException {
        this.unexpectedEnterElement(uri, local);
    }

    public void leaveElement(String uri, String local) throws UnreportedException {
        this.unexpectedLeaveElement(uri, local);
    }

    public void text(String s) throws UnreportedException {
        this.unexpectedText(s);
    }

    public void enterAttribute(String uri, String local) throws UnreportedException {
        this.unexpectedEnterAttribute(uri, local);
    }

    public void leaveAttribute(String uri, String local) throws UnreportedException {
        this.unexpectedLeaveAttribute(uri, local);
    }

    public void leaveChild(int nextState) throws UnreportedException {
        this.unexpectedLeaveChild();
    }

    protected final boolean isListState() {
        return this.stateTextTypes.charAt(this.state) == 'L';
    }

    protected void handleUnexpectedTextException(String text, RuntimeException e) throws UnreportedException {
        throw new UnreportedException(Messages.format("ContentHandlerEx.UnexpectedText", text), this.context.getLocator(), e);
    }

    protected final void dump() {
        System.err.println("state is :" + this.state);
    }

    protected final void unexpectedEnterElement(String uri, String local) throws UnreportedException {
        throw new UnreportedException(Messages.format("ContentHandlerEx.UnexpectedEnterElement", uri, local), this.context.getLocator());
    }

    protected final void unexpectedLeaveElement(String uri, String local) throws UnreportedException {
        throw new UnreportedException(Messages.format("ContentHandlerEx.UnexpectedLeaveElement", uri, local), this.context.getLocator());
    }

    protected final void unexpectedEnterAttribute(String uri, String local) throws UnreportedException {
        throw new UnreportedException(Messages.format("ContentHandlerEx.UnexpectedEnterAttribute", uri, local), this.context.getLocator());
    }

    protected final void unexpectedLeaveAttribute(String uri, String local) throws UnreportedException {
        throw new UnreportedException(Messages.format("ContentHandlerEx.UnexpectedLeaveAttribute", uri, local), this.context.getLocator());
    }

    protected final void unexpectedText(String str) throws UnreportedException {
        str = str.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ').trim();
        throw new UnreportedException(Messages.format("ContentHandlerEx.UnexpectedText", str), this.context.getLocator());
    }

    protected final void unexpectedLeaveChild() throws UnreportedException {
        this.dump();
        throw new InternalError(Messages.format("ContentHandlerEx.UnexpectedLeaveChild"));
    }

    private ContentHandlerEx spawnChild(Class clazz, int memento) {
        this.child = this.context.getTypeRegistry().createInstanceOf(clazz);
        ContentHandlerEx handler = this.child.getUnmarshaller(this.context);
        this.context.pushContentHandler(handler, memento);
        return handler;
    }

    protected final Object spawnChildFromEnterElement(Class clazz, int memento, String uri, String local, Attributes atts) throws UnreportedException {
        this.spawnChild(clazz, memento).enterElement(uri, local, atts);
        return this.child;
    }

    protected final Object spawnChildFromEnterAttribute(Class clazz, int memento, String uri, String local) throws UnreportedException {
        this.spawnChild(clazz, memento).enterAttribute(uri, local);
        return this.child;
    }

    protected final Object spawnChildFromText(Class clazz, int memento, String value) throws UnreportedException {
        this.spawnChild(clazz, memento).text(value);
        return this.child;
    }

    protected final Object spawnChildFromLeaveElement(Class clazz, int memento, String uri, String local) throws UnreportedException {
        this.spawnChild(clazz, memento).leaveElement(uri, local);
        return this.child;
    }

    protected final Object spawnChildFromLeaveAttribute(Class clazz, int memento, String uri, String local) throws UnreportedException {
        this.spawnChild(clazz, memento).leaveAttribute(uri, local);
        return this.child;
    }

    protected final Element spawnWildcard(int memento, String uri, String local, Attributes atts) throws UnreportedException {
        Class clazz = this.context.getTypeRegistry().getRootElement(uri, local);
        if (clazz != null) {
            return (Element)this.spawnChildFromEnterElement(clazz, memento, uri, local, atts);
        }
        this.context.pushContentHandler(new Discarder(this.context), memento);
        this.context.getCurrentHandler().enterElement(uri, local, atts);
        return null;
    }

    protected final void spawnSuperClassFromEnterElement(ContentHandlerEx unm, int memento, String uri, String local, Attributes atts) throws UnreportedException {
        this.context.pushContentHandler(unm, memento);
        unm.enterElement(uri, local, atts);
    }

    protected final void spawnSuperClassFromEnterAttribute(ContentHandlerEx unm, int memento, String uri, String local) throws UnreportedException {
        this.context.pushContentHandler(unm, memento);
        unm.enterAttribute(uri, local);
    }

    protected final void spawnSuperClassFromFromText(ContentHandlerEx unm, int memento, String value) throws UnreportedException {
        this.context.pushContentHandler(unm, memento);
        unm.text(value);
    }

    protected final void spawnSuperClassFromLeaveElement(ContentHandlerEx unm, int memento, String uri, String local) throws UnreportedException {
        this.context.pushContentHandler(unm, memento);
        unm.leaveElement(uri, local);
    }

    protected final void spawnSuperClassFromLeaveAttribute(ContentHandlerEx unm, int memento, String uri, String local) throws UnreportedException {
        this.context.pushContentHandler(unm, memento);
        unm.leaveAttribute(uri, local);
    }

    protected final void spawnSuperClassFromText(ContentHandlerEx unm, int memento, String text) throws UnreportedException {
        this.context.pushContentHandler(unm, memento);
        unm.text(text);
    }

    protected final void revertToParentFromEnterElement(String uri, String local, Attributes atts) throws UnreportedException {
        this.context.popContentHandler();
        this.context.getCurrentHandler().enterElement(uri, local, atts);
    }

    protected final void revertToParentFromLeaveElement(String uri, String local) throws UnreportedException {
        this.context.popContentHandler();
        this.context.getCurrentHandler().leaveElement(uri, local);
    }

    protected final void revertToParentFromEnterAttribute(String uri, String local) throws UnreportedException {
        this.context.popContentHandler();
        this.context.getCurrentHandler().enterAttribute(uri, local);
    }

    protected final void revertToParentFromLeaveAttribute(String uri, String local) throws UnreportedException {
        this.context.popContentHandler();
        this.context.getCurrentHandler().leaveAttribute(uri, local);
    }

    protected final void revertToParentFromText(String value) throws UnreportedException {
        this.context.popContentHandler();
        this.context.getCurrentHandler().text(value);
    }
}

