/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.StringTokenizer;
import phex.common.URN;
import phex.utils.IOUtil;

public class MsgResRecord {
    private int mFileIndex = 0;
    private String fileName = "";
    private int mFileSize = 0;
    private URN urn;
    private String metaData;

    public MsgResRecord() {
    }

    public MsgResRecord(int n, URN uRN, int n2, String string) {
        this.mFileIndex = n;
        this.mFileSize = n2;
        this.fileName = string;
        this.urn = uRN;
    }

    public int getFileIndex() {
        return this.mFileIndex;
    }

    public int getFileSize() {
        return this.mFileSize;
    }

    public String getFilename() {
        return this.fileName;
    }

    public int getSize() {
        return 8 + this.fileName.length() + this.urn.getAsString().length() + 2;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void copy(MsgResRecord msgResRecord) {
        this.mFileIndex = msgResRecord.mFileIndex;
        this.mFileSize = msgResRecord.mFileSize;
        this.fileName = msgResRecord.fileName;
    }

    public int serialize(byte[] byArray, int n) {
        n = IOUtil.serializeIntLE(this.mFileIndex, byArray, n);
        n = IOUtil.serializeIntLE(this.mFileSize, byArray, n);
        n = IOUtil.serializeString(this.fileName, byArray, n);
        byArray[n++] = 0;
        n = IOUtil.serializeString(this.urn.getAsString(), byArray, n);
        byArray[n++] = 0;
        return n;
    }

    public int deserialize(byte[] byArray, int n) {
        this.mFileIndex = IOUtil.deserializeIntLE(byArray, n);
        this.mFileSize = IOUtil.deserializeIntLE(byArray, n += 4);
        int n2 = n += 4;
        while (byArray[n2] != 0) {
            ++n2;
        }
        this.fileName = new String(byArray, n, n2 - n);
        int n3 = n2 + 1;
        while (byArray[n3] != 0) {
            ++n3;
        }
        String string = new String(byArray, n2 + 1, n3 - n2 - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u001c");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (URN.isValidURN(string2)) {
                this.urn = new URN(string2);
                continue;
            }
            if (this.metaData != null && this.metaData.length() != 0) continue;
            this.metaData = this.parseMetaData(string2);
        }
        n = n3 + 1;
        return n;
    }

    public String toString() {
        return "[FileIndex=" + this.mFileIndex + ", " + "FileSize=" + this.mFileSize + ", " + "Filename=" + this.fileName + "]";
    }

    private String parseMetaData(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            return "";
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = "";
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string3.toLowerCase().startsWith("kbps")) {
            bl2 = true;
            if (string3.indexOf("VBR") > 0) {
                bl = true;
            }
        } else if (string2.toLowerCase().endsWith("kbps")) {
            bl3 = true;
        }
        if (bl2) {
            string6 = string2;
        } else if (bl3) {
            n = string2.toLowerCase().indexOf("kbps");
            string6 = string2.substring(0, n);
        }
        if (bl2 || bl3) {
            String string7 = "";
            String string8 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string8 = stringTokenizer.nextToken();
                if (string8.startsWith("kHz")) {
                    string5 = string7;
                }
                string7 = string8;
            }
            string4 = string8;
        } else if (string.endsWith("kHz")) {
            bl4 = true;
            string4 = string2;
            n = string3.indexOf("kbps");
            if (n > -1) {
                string6 = string3.substring(0, n);
            } else {
                bl4 = false;
            }
        }
        if (bl2 || bl3 || bl4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string6);
            stringBuffer.append("Kbps");
            if (bl) {
                stringBuffer.append("(VBR)");
            }
            stringBuffer.append(" - ");
            if (string5 != null && string5.length() > 0) {
                stringBuffer.append(string5);
                stringBuffer.append("kHz");
                stringBuffer.append(" - ");
            }
            stringBuffer.append(string4);
            return stringBuffer.toString();
        }
        return "";
    }
}

