/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import javax.xml.bind.JAXBException;
import phex.chat.ChatManager;
import phex.common.ExpiryDate;
import phex.common.URN;
import phex.download.swarming.SWDownloadCandidate;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.event.DownloadFilesChangeListener;
import phex.gui.actions.FWAction;
import phex.gui.common.BrowserLauncher;
import phex.gui.common.FWTable;
import phex.gui.common.FWToolBar;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.MainFrame;
import phex.gui.dialogs.DownloadConfigDialog;
import phex.gui.models.FWSortedTableModel;
import phex.gui.models.FWTableColumnModel;
import phex.gui.models.SWCandidateTableModel;
import phex.gui.models.SWDownloadTableModel;
import phex.gui.models.SWSegmentTableModel;
import phex.gui.tabs.FWTab;
import phex.query.QueryManager;
import phex.query.SearchContainer;
import phex.security.PhexSecurityManager;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.StrUtil;
import phex.utils.URLUtil;
import phex.xml.ObjectFactory;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITable;
import phex.xml.XJBGUITableColumnList;

public class SWDownloadTab
extends FWTab {
    private static final String DOWNLOAD_TABLE_IDENTIFIER = "DownloadTable";
    private static final String SEGMENT_TABLE_IDENTIFIER = "SegmentTable";
    private static final String CANDIDATE_TABLE_IDENTIFIER = "CandidateTable";
    private static final SWDownloadFile[] EMPTY_DOWNLOADFILE_ARRAY = new SWDownloadFile[0];
    private static final SWDownloadCandidate[] EMPTY_DOWNLOADCANDIDATE_ARRAY = new SWDownloadCandidate[0];
    private SwarmingManager swarmingMgr = SwarmingManager.getInstance();
    private FWTable downloadTable;
    private JScrollPane downloadTableScrollPane;
    private FWTableColumnModel downloadColumnModel;
    private SWDownloadTableModel downloadModel;
    private JTabbedPane downloadDetails;
    private TitledBorder candidateTitleBorder;
    private JPopupMenu downloadPopup;
    private FWTable candidateTable;
    private JScrollPane candidateTableScrollPane;
    private FWTableColumnModel candidateColumnModel;
    private SWCandidateTableModel candidateModel;
    private JPopupMenu candidatePopup;
    private FWTable segmentTable;
    private JScrollPane segmentTableScrollPane;
    private FWTableColumnModel segmentColumnModel;
    private SWSegmentTableModel segmentModel;
    private MainFrame mainFrame;

    public SWDownloadTab(MainFrame mainFrame) {
        super(1003, Localizer.getString("Download"), GUIRegistry.getInstance().getIconFactory().getIcon("Download"), Localizer.getString("TTTDownloadTab"), Localizer.getChar("DownloadMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("DownloadAccelerator")), 3);
        this.swarmingMgr.addDownloadFilesChangeListener(new DownloadFilesChangeHandler());
        this.mainFrame = mainFrame;
    }

    public void initComponent(XJBGUISettings xJBGUISettings) {
        MouseHandler mouseHandler = new MouseHandler();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("DownloadFiles")));
        this.downloadModel = new SWDownloadTableModel();
        XJBGUITable xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, DOWNLOAD_TABLE_IDENTIFIER);
        this.buildDownloadTableColumnModel(xJBGUITable);
        this.downloadTable = new FWTable((TableModel)new FWSortedTableModel(this.downloadModel), this.downloadColumnModel);
        this.downloadTable.activateAllHeaderActions();
        this.downloadTable.setAutoResizeMode(0);
        this.downloadTable.getSelectionModel().addListSelectionListener(new DownloadSelectionHandler());
        this.downloadTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.downloadTable);
        this.downloadTableScrollPane = FWTable.createFWTableScrollPane(this.downloadTable);
        this.downloadTableScrollPane.addMouseListener(mouseHandler);
        jPanel.add("Center", this.downloadTableScrollPane);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4), BorderFactory.createEtchedBorder()));
        FWToolBar fWToolBar = new FWToolBar(0);
        fWToolBar.setBorderPainted(false);
        fWToolBar.setFloatable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)fWToolBar, gridBagConstraints);
        this.downloadPopup = new JPopupMenu();
        FWAction fWAction = new StartDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new StopDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new RemoveDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWToolBar.addSeparator();
        this.downloadPopup.addSeparator();
        fWAction = new ConfigureDownloadAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        fWAction = new SearchCandidatesAction();
        this.addTabAction(fWAction);
        fWToolBar.addAction(fWAction);
        this.downloadPopup.add(fWAction);
        JMenu jMenu = new JMenu(Localizer.getString("Priority"));
        fWAction = new MoveDownloadPriorityAction(0);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(1);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(2);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        fWAction = new MoveDownloadPriorityAction(3);
        jMenu.add(fWAction);
        this.addTabAction(fWAction);
        this.downloadPopup.add(jMenu);
        fWAction = new ViewBitziTicketAction();
        this.addTabAction(fWAction);
        this.downloadPopup.add(fWAction);
        jPanel.add("South", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.candidateTitleBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("DownloadCandidates"));
        jPanel3.setBorder(this.candidateTitleBorder);
        this.candidateModel = new SWCandidateTableModel(this.downloadTable);
        xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, CANDIDATE_TABLE_IDENTIFIER);
        this.buildCandidateTableColumnModel(xJBGUITable);
        this.candidateTable = new FWTable((TableModel)new FWSortedTableModel(this.candidateModel), this.candidateColumnModel);
        this.candidateTable.activateAllHeaderActions();
        this.candidateTable.getSelectionModel().addListSelectionListener(new CandidateSelectionHandler());
        this.candidateTable.setAutoResizeMode(0);
        this.candidateTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.candidateTable);
        this.candidateTableScrollPane = FWTable.createFWTableScrollPane(this.candidateTable);
        this.candidateTableScrollPane.addMouseListener(mouseHandler);
        jPanel3.add("Center", this.candidateTableScrollPane);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4), BorderFactory.createEtchedBorder()));
        FWToolBar fWToolBar2 = new FWToolBar(0);
        fWToolBar2.setBorderPainted(false);
        fWToolBar2.setFloatable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel4.add((Component)fWToolBar2, gridBagConstraints);
        this.candidatePopup = new JPopupMenu();
        fWAction = new RetryCandidateAction();
        this.addTabAction(fWAction);
        fWToolBar2.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new RemoveCandidateAction();
        this.addTabAction(fWAction);
        fWToolBar2.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        this.candidatePopup.addSeparator();
        fWToolBar2.addSeparator();
        fWAction = new BrowseHostAction();
        this.addTabAction(fWAction);
        fWToolBar2.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new ChatToHostAction();
        this.addTabAction(fWAction);
        fWToolBar2.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        fWAction = new BanHostAction();
        this.addTabAction(fWAction);
        fWToolBar2.addAction(fWAction);
        this.candidatePopup.add(fWAction);
        jPanel3.add("South", jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.getBackground().darker()), Localizer.getString("DownloadSegments")));
        this.segmentModel = new SWSegmentTableModel(this.downloadTable);
        xJBGUITable = GUIUtils.getXJBGUITableByIdentifier(xJBGUISettings, SEGMENT_TABLE_IDENTIFIER);
        this.buildSegmentTableColumnModel(xJBGUITable);
        this.segmentTable = new FWTable((TableModel)new FWSortedTableModel(this.segmentModel), this.segmentColumnModel);
        this.segmentTable.activateAllHeaderActions();
        this.segmentTable.setSelectionMode(0);
        this.segmentTable.setAutoResizeMode(0);
        GUIRegistry.getInstance().getTableUpdateService().registerTable(this.segmentTable);
        this.segmentTableScrollPane = FWTable.createFWTableScrollPane(this.segmentTable);
        jPanel5.add("Center", this.segmentTableScrollPane);
        this.downloadDetails = new JTabbedPane(3);
        this.downloadDetails.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        this.downloadDetails.addTab(Localizer.getString("Candidates"), jPanel3);
        this.downloadDetails.addTab(Localizer.getString("Segments"), jPanel5);
        Dimension dimension = new Dimension(400, 200);
        jPanel.setPreferredSize(dimension);
        this.downloadDetails.setPreferredSize(dimension);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, this.downloadDetails);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jSplitPane.setDividerSize(4);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setDividerLocation(0.5);
        jSplitPane.setResizeWeight(0.5);
        this.add("Center", jSplitPane);
        GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        GUIUtils.adjustTableProgresssBarHeight(this.candidateTable);
        GUIUtils.adjustTableProgresssBarHeight(this.segmentTable);
    }

    public void updateUI() {
        super.updateUI();
        if (this.downloadTable != null) {
            GUIUtils.adjustTableProgresssBarHeight(this.downloadTable);
        }
        if (this.downloadTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.downloadTableScrollPane);
        }
        if (this.candidateTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.candidateTableScrollPane);
        }
        if (this.segmentTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.segmentTableScrollPane);
        }
    }

    private void updateDownloadFileInfo(int n) {
        int n2 = this.downloadTable.convertRowIndexToModel(this.downloadTable.getSelectedRow());
        if (n2 == n) {
            this.refreshTabActions();
            SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile != null) {
                if (sWDownloadFile.getResearchSetting().isSearchRunning()) {
                    Object[] objectArray = new Object[]{new Integer(sWDownloadFile.getResearchSetting().getSearchHitCount())};
                    StringBuffer stringBuffer = new StringBuffer(Localizer.getString("DownloadCandidates"));
                    stringBuffer.append(' ');
                    stringBuffer.append(Localizer.getFormatedString("CandidatesSearchingExt", objectArray));
                    this.candidateTitleBorder.setTitle(stringBuffer.toString());
                } else {
                    this.candidateTitleBorder.setTitle(Localizer.getString("DownloadCandidates"));
                }
                this.downloadDetails.repaint();
            }
        }
    }

    private SWDownloadFile[] getSelectedDownloadFiles() {
        if (this.downloadTable.getSelectedRowCount() == 0) {
            return EMPTY_DOWNLOADFILE_ARRAY;
        }
        int[] nArray = this.downloadTable.getSelectedRows();
        int[] nArray2 = this.downloadTable.convertRowIndicesToModel(nArray);
        SWDownloadFile[] sWDownloadFileArray = this.swarmingMgr.getDownloadFilesAt(nArray2);
        return sWDownloadFileArray;
    }

    private SWDownloadFile getSelectedDownloadFile() {
        int n = this.downloadTable.getSelectedRow();
        if (n < 0) {
            return null;
        }
        int n2 = this.downloadTable.convertRowIndexToModel(n);
        SWDownloadFile sWDownloadFile = this.swarmingMgr.getDownloadFile(n2);
        return sWDownloadFile;
    }

    private SWDownloadCandidate[] getSelectedDownloadCandidates() {
        if (this.candidateTable.getSelectedRowCount() == 0) {
            return EMPTY_DOWNLOADCANDIDATE_ARRAY;
        }
        int[] nArray = this.candidateTable.getSelectedRows();
        int[] nArray2 = this.candidateTable.convertRowIndicesToModel(nArray);
        SWDownloadCandidate[] sWDownloadCandidateArray = new SWDownloadCandidate[nArray2.length];
        SWDownloadFile sWDownloadFile = this.candidateModel.getDownloadFile();
        int n = 0;
        while (n < sWDownloadCandidateArray.length) {
            sWDownloadCandidateArray[n] = sWDownloadFile.getCandidate(nArray2[n]);
            ++n;
        }
        return sWDownloadCandidateArray;
    }

    private SWDownloadCandidate getSelectedDownloadCandidate() {
        int n = this.candidateTable.getSelectedRow();
        int n2 = this.candidateTable.convertRowIndexToModel(n);
        SWDownloadFile sWDownloadFile = this.candidateModel.getDownloadFile();
        SWDownloadCandidate sWDownloadCandidate = sWDownloadFile.getCandidate(n2);
        return sWDownloadCandidate;
    }

    private void buildDownloadTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SWDownloadTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.downloadColumnModel = new FWTableColumnModel(this.downloadModel, nArray, xJBGUITableColumnList);
    }

    private void buildSegmentTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = new int[]{1001, 1002, 1003, 1004};
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.segmentColumnModel = new FWTableColumnModel(this.segmentModel, nArray, xJBGUITableColumnList);
    }

    private void buildCandidateTableColumnModel(XJBGUITable xJBGUITable) {
        int[] nArray = SWCandidateTableModel.getColumnIdArray();
        XJBGUITableColumnList xJBGUITableColumnList = null;
        if (xJBGUITable != null) {
            xJBGUITableColumnList = xJBGUITable.getTableColumnList();
        }
        this.candidateColumnModel = new FWTableColumnModel(this.candidateModel, nArray, xJBGUITableColumnList);
    }

    public void appendXJBGUISettings(XJBGUISettings xJBGUISettings) throws JAXBException {
        super.appendXJBGUISettings(xJBGUISettings);
        XJBGUITableColumnList xJBGUITableColumnList = this.downloadColumnModel.createXJBGUITableColumnList();
        XJBGUITable xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(DOWNLOAD_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
        xJBGUITableColumnList = this.segmentColumnModel.createXJBGUITableColumnList();
        xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(SEGMENT_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
        xJBGUITableColumnList = this.candidateColumnModel.createXJBGUITableColumnList();
        xJBGUITable = ObjectFactory.createXJBGUITable();
        xJBGUITable.setTableColumnList(xJBGUITableColumnList);
        xJBGUITable.setTableIdentifier(CANDIDATE_TABLE_IDENTIFIER);
        xJBGUISettings.getTableList().getTableList().add(xJBGUITable);
    }

    private class SearchCandidatesAction
    extends FWAction {
        public SearchCandidatesAction() {
            super(Localizer.getString("Search"), GUIRegistry.getInstance().getIconFactory().getIcon("Search"), Localizer.getString("TTTSearchCandidates"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            sWDownloadFile.startSearchForCandidates();
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile == null) {
                this.setEnabled(false);
            } else if (sWDownloadFile.getResearchSetting().isSearchRunning() || sWDownloadFile.isDownloadCompleted()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class BanHostAction
    extends FWAction {
        public BanHostAction() {
            super(Localizer.getString("BanHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Ban"), Localizer.getString("TTTBanHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.candidateModel.getDownloadFile();
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            int n = 0;
            while (n < sWDownloadCandidateArray.length) {
                try {
                    sWDownloadFile.removeDownloadCandidate(sWDownloadCandidateArray[n]);
                    phexSecurityManager.createIPAccessRule(Localizer.getString("UserBanned"), true, (byte)1, sWDownloadCandidateArray[n].getHostAddress().getHostIP(), null, false, ExpiryDate.SESSION_EXPIRY_DATE, true);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                ++n;
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getIconFactory().getIcon("BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate();
            if (sWDownloadCandidate == null) {
                return;
            }
            SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();
            searchContainer.createBrowseHostSearch(sWDownloadCandidate.getHostAddress(), null);
            SWDownloadTab.this.mainFrame.setSelectedTab(1001);
        }

        public void refreshActionState() {
            SWDownloadCandidate sWDownloadCandidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getIconFactory().getIcon("Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate();
            if (sWDownloadCandidate == null) {
                return;
            }
            if (!sWDownloadCandidate.isChatSupported()) {
                return;
            }
            ChatManager.getInstance().openChat(sWDownloadCandidate.getHostAddress());
        }

        public void refreshActionState() {
            SWDownloadCandidate sWDownloadCandidate;
            if (SWDownloadTab.this.candidateTable.getSelectedRowCount() == 1 && (sWDownloadCandidate = SWDownloadTab.this.getSelectedDownloadCandidate()) != null && sWDownloadCandidate.isChatSupported()) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    class RetryCandidateAction
    extends FWAction {
        RetryCandidateAction() {
            super(Localizer.getString("RetryCandidate"), GUIRegistry.getInstance().getIconFactory().getIcon("ReconnectHost"), Localizer.getString("TTTRetryCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            int n = 0;
            while (n < sWDownloadCandidateArray.length) {
                sWDownloadCandidateArray[n].manualConnectionRetry();
                ++n;
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class RemoveCandidateAction
    extends FWAction {
        RemoveCandidateAction() {
            super(Localizer.getString("RemoveCandidate"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTRemoveCandidate"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadCandidate[] sWDownloadCandidateArray = SWDownloadTab.this.getSelectedDownloadCandidates();
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.candidateModel.getDownloadFile();
            int n = 0;
            while (n < sWDownloadCandidateArray.length) {
                sWDownloadFile.removeDownloadCandidate(sWDownloadCandidateArray[n]);
                ++n;
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.candidateTable.getSelectedRow();
            if (n < 0 || n2 < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    private class ViewBitziTicketAction
    extends FWAction {
        public ViewBitziTicketAction() {
            super(Localizer.getString("ViewBitziTicket"), GUIRegistry.getInstance().getIconFactory().getIcon("Bitzi"), Localizer.getString("TTTViewBitziTicket"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block4: {
                SWDownloadFile sWDownloadFile = SWDownloadTab.this.getSelectedDownloadFile();
                if (sWDownloadFile == null) {
                    return;
                }
                URN uRN = sWDownloadFile.getFileURN();
                if (uRN == null) {
                    return;
                }
                String string = URLUtil.buildBitziLookupURL(uRN);
                try {
                    BrowserLauncher.openURL(string);
                }
                catch (IOException iOException) {
                    Logger.logWarning(iOException);
                    Object[] objectArray = new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                    int n = JOptionPane.showOptionDialog(SWDownloadTab.this, Localizer.getString("FailedToLaunchBrowserURLInClipboard"), Localizer.getString("FailedToLaunchBrowser"), 0, 2, null, objectArray, Localizer.getString("Yes"));
                    if (n != 0) break block4;
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
                }
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class MoveDownloadPriorityAction
    extends FWAction {
        private short moveDirection;

        MoveDownloadPriorityAction(short s) {
            this.moveDirection = s;
            switch (s) {
                case 0: {
                    this.setName(Localizer.getString("MoveToTop"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveToTop"));
                    this.setToolTipText(Localizer.getString("TTTMoveToTop"));
                    break;
                }
                case 1: {
                    this.setName(Localizer.getString("MoveUp"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveUp"));
                    this.setToolTipText(Localizer.getString("TTTMoveUp"));
                    break;
                }
                case 2: {
                    this.setName(Localizer.getString("MoveDown"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveDown"));
                    this.setToolTipText(Localizer.getString("TTTMoveDown"));
                    break;
                }
                case 3: {
                    this.setName(Localizer.getString("MoveToBottom"));
                    this.setSmallIcon(GUIRegistry.getInstance().getIconFactory().getIcon("MoveToBottom"));
                    this.setToolTipText(Localizer.getString("TTTMoveToBottom"));
                }
            }
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            int n = 0;
            while (n < sWDownloadFileArray.length) {
                SWDownloadTab.this.swarmingMgr.moveDownloadFilePriority(sWDownloadFileArray[n], this.moveDirection);
                ++n;
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class RemoveDownloadAction
    extends FWAction {
        RemoveDownloadAction() {
            super(Localizer.getString("RemoveDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Close"), Localizer.getString("TTTRemoveDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray;
            SWDownloadFile[] sWDownloadFileArray2 = SWDownloadTab.this.getSelectedDownloadFiles();
            ArrayList<SWDownloadFile> arrayList = new ArrayList<SWDownloadFile>(sWDownloadFileArray2.length);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(sWDownloadFileArray2.length);
            int n = 0;
            while (n < sWDownloadFileArray2.length) {
                if (sWDownloadFileArray2[n].isDownloadCompleted()) {
                    arrayList2.add(sWDownloadFileArray2[n]);
                } else if (sWDownloadFileArray2[n].getTransferredDataSize() == 0L) {
                    arrayList2.add(sWDownloadFileArray2[n]);
                } else {
                    arrayList.add(sWDownloadFileArray2[n]);
                }
                ++n;
            }
            Integer n2 = new Integer(arrayList.size());
            int n3 = 0;
            while (n3 < n2) {
                sWDownloadFileArray = (SWDownloadFile[])arrayList.get(n3);
                sWDownloadFileArray.forceCollectionOfTransferData();
                Object[] objectArray = new Object[]{sWDownloadFileArray.getDestinationFile().getName(), StrUtil.formatSizeBytes(sWDownloadFileArray.getTransferredDataSize()), StrUtil.formatSizeBytes(sWDownloadFileArray.getTransferDataSize())};
                Object[] objectArray2 = new Object[]{new Integer(n3 + 1), n2};
                Object[] objectArray3 = n2 - n3 > 1 ? new Object[]{Localizer.getString("Yes"), Localizer.getString("No"), Localizer.getString("YesToAll"), Localizer.getString("NoToAll")} : new Object[]{Localizer.getString("Yes"), Localizer.getString("No")};
                int n4 = JOptionPane.showOptionDialog(SWDownloadTab.this.mainFrame, Localizer.getFormatedString("RemoveDownloadWarning", objectArray), Localizer.getFormatedString("RemoveDownloadTitle", objectArray2), 0, 2, null, objectArray3, Localizer.getString("Yes"));
                if (n4 == 0) {
                    arrayList2.add(sWDownloadFileArray);
                } else {
                    if (n4 == 2) {
                        arrayList2.addAll(arrayList.subList(n3, arrayList.size()));
                        break;
                    }
                    if (n4 == 3) break;
                }
                ++n3;
            }
            if (arrayList2.size() > 0) {
                sWDownloadFileArray = new SWDownloadFile[arrayList2.size()];
                arrayList2.toArray(sWDownloadFileArray);
                SWDownloadTab.this.swarmingMgr.removeDownloadFiles(sWDownloadFileArray);
                SWDownloadTab.this.downloadTable.getSelectionModel().clearSelection();
            }
        }

        public void refreshActionState() {
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            if (n < 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class ConfigureDownloadAction
    extends FWAction {
        ConfigureDownloadAction() {
            super(Localizer.getString("ConfigureDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("ConfigDownload"), Localizer.getString("TTTConfigureDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() != 1) {
                this.setEnabled(false);
                return;
            }
            int n = SWDownloadTab.this.downloadTable.getSelectedRow();
            int n2 = SWDownloadTab.this.downloadTable.convertRowIndexToModel(n);
            SWDownloadFile sWDownloadFile = SWDownloadTab.this.swarmingMgr.getDownloadFile(n2);
            if (sWDownloadFile != null) {
                if (sWDownloadFile.isDownloadInProgress()) {
                    JOptionPane.showMessageDialog(SWDownloadTab.this, Localizer.getString("NoConfigDownloadInProgress"), Localizer.getString("DownloadInProgress"), 2);
                    return;
                }
                short s = sWDownloadFile.getStatus();
                sWDownloadFile.stopDownload();
                DownloadConfigDialog downloadConfigDialog = new DownloadConfigDialog(sWDownloadFile);
                downloadConfigDialog.show();
                sWDownloadFile.setStatus(s);
            }
        }

        public void refreshActionState() {
            if (SWDownloadTab.this.downloadTable.getSelectedRowCount() == 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class StopDownloadAction
    extends FWAction {
        StopDownloadAction() {
            super(Localizer.getString("StopDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Stop"), Localizer.getString("TTTStopDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            int n = 0;
            while (n < sWDownloadFileArray.length) {
                if (!sWDownloadFileArray[n].isDownloadCompleted() && !sWDownloadFileArray[n].isDownloadStopped()) {
                    sWDownloadFileArray[n].stopDownload();
                }
                ++n;
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            boolean bl = false;
            int n = 0;
            while (n < sWDownloadFileArray.length) {
                if (!sWDownloadFileArray[n].isDownloadCompleted() && !sWDownloadFileArray[n].isDownloadStopped()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            this.setEnabled(bl);
        }
    }

    class StartDownloadAction
    extends FWAction {
        StartDownloadAction() {
            super(Localizer.getString("StartDownload"), GUIRegistry.getInstance().getIconFactory().getIcon("Start"), Localizer.getString("TTTStartDownload"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            int n = 0;
            while (n < sWDownloadFileArray.length) {
                if (sWDownloadFileArray[n].isDownloadStopped()) {
                    sWDownloadFileArray[n].startDownload();
                }
                ++n;
            }
            this.refreshActionState();
        }

        public void refreshActionState() {
            SWDownloadFile[] sWDownloadFileArray = SWDownloadTab.this.getSelectedDownloadFiles();
            boolean bl = false;
            int n = 0;
            while (n < sWDownloadFileArray.length) {
                if (sWDownloadFileArray[n].isDownloadStopped()) {
                    bl = true;
                    break;
                }
                ++n;
            }
            this.setEnabled(bl);
        }
    }

    private class DownloadFilesChangeHandler
    implements DownloadFilesChangeListener {
        private DownloadFilesChangeHandler() {
        }

        public void downloadFileChanged(int n) {
            SWDownloadTab.this.updateDownloadFileInfo(n);
        }

        public void downloadFileAdded(int n) {
        }

        public void downloadFileRemoved(int n) {
        }
    }

    private class MouseHandler
    extends MouseAdapter
    implements MouseListener {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.popupMenu((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void popupMenu(Component component, int n, int n2) {
            if (component == SWDownloadTab.this.downloadTable || component == SWDownloadTab.this.downloadTableScrollPane) {
                SWDownloadTab.this.downloadPopup.show(component, n, n2);
            } else if (component == SWDownloadTab.this.candidateTable || component == SWDownloadTab.this.candidateTableScrollPane) {
                SWDownloadTab.this.candidatePopup.show(component, n, n2);
            }
        }
    }

    class CandidateSelectionHandler
    implements ListSelectionListener {
        CandidateSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                SWDownloadTab.this.refreshTabActions();
            }
        }
    }

    class DownloadSelectionHandler
    implements ListSelectionListener {
        DownloadSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                int n = listSelectionModel.getLeadSelectionIndex();
                SWDownloadTab.this.updateDownloadFileInfo(n);
            }
        }
    }
}

