/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import phex.event.NetworkHostsChangeListener;
import phex.gui.models.FWTableModel;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.utils.Localizer;
import phex.utils.StrUtil;

public class NetworkTableModel
extends FWTableModel {
    public static final int HOST_COLUMN_ID = 1001;
    public static final int VENDOR_COLUMN_ID = 1002;
    public static final int TYPE_COLUMN_ID = 1003;
    public static final int RECEIVED_DROPPED_COLUMN_ID = 1004;
    public static final int SENT_QUEUED_COLUMN_ID = 1005;
    public static final int SHARED_COLUMN_ID = 1007;
    public static final int UPTIME_COLUMN_ID = 1008;
    public static final int STATUS_COLUMN_ID = 1009;
    public static final int MODE_COLUMN_ID = 1010;
    public static final int HOST_MODEL_INDEX = 0;
    public static final int VENDOR_MODEL_INDEX = 1;
    public static final int TYPE_MODEL_INDEX = 2;
    public static final int MODE_MODEL_INDEX = 3;
    public static final int RECEIVED_DROPPED_MODEL_INDEX = 4;
    public static final int SENT_QUEUED_MODEL_INDEX = 5;
    public static final int SHARED_MODEL_INDEX = 6;
    public static final int UPTIME_MODEL_INDEX = 7;
    public static final int STATUS_MODEL_INDEX = 8;
    private static String[] tableColumns = new String[]{Localizer.getString("RemoteHost"), Localizer.getString("Vendor"), Localizer.getString("Type"), Localizer.getString("Mode"), Localizer.getString("ReceivedDropped"), Localizer.getString("SentQueuedDropped"), Localizer.getString("Shared"), Localizer.getString("Uptime"), Localizer.getString("Status")};
    private static Class[] tableClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NetworkTableModel.class$("java.lang.String")) : class$java$lang$String};
    private NetworkHostsContainer hostsContainer;
    static /* synthetic */ Class class$java$lang$String;

    public NetworkTableModel() {
        super(tableColumns, tableClasses);
        HostManager hostManager = HostManager.getInstance();
        this.hostsContainer = hostManager.getNetworkHostsContainer();
        this.hostsContainer.addNetworkHostsChangeListener(new NetworkHostsListener());
    }

    public int getRowCount() {
        return this.hostsContainer.getNetworkHostCount();
    }

    public Object getValueAt(int n, int n2) {
        Host host = this.hostsContainer.getNetworkHostAt(n);
        if (host == null) {
            this.fireTableRowsDeleted(n, n);
            return "";
        }
        switch (n2) {
            case 0: {
                return host.getHostAddress().getFullHostName();
            }
            case 1: {
                return host.getVendor();
            }
            case 2: {
                Object[] objectArray = new Object[]{host.getType()};
                return Localizer.getFormatedString("HostType", objectArray);
            }
            case 3: {
                if (!host.isConnected()) {
                    return "";
                }
                if (host.isUltrapeer()) {
                    return Localizer.getString("Ultrapeer");
                }
                if (host.isUltrapeerLeafConnection()) {
                    return Localizer.getString("Leaf");
                }
                return Localizer.getString("Peer");
            }
            case 4: {
                return String.valueOf(host.getReceivedCount() + " (" + String.valueOf(host.getDropCount()) + ")");
            }
            case 5: {
                return String.valueOf(host.getSentCount()) + " / " + String.valueOf(host.getSendQueueLength()) + " / " + String.valueOf(host.getSendDropCount());
            }
            case 6: {
                if (host.getFileCount() == -1) {
                    return "";
                }
                return host.getFileCount() + "/" + StrUtil.formatSizeBytes((long)host.getTotalSize() * 1024L);
            }
            case 7: {
                long l = host.getConnectionUpTime(System.currentTimeMillis()) / 1000L;
                return StrUtil.formatSignificantElapsedTime(l);
            }
            case 8: {
                return host.getStatusName();
            }
        }
        return "";
    }

    public Object getComparableValueAt(int n, int n2) {
        switch (n2) {
            case 7: {
                Host host = this.hostsContainer.getNetworkHostAt(n);
                if (host == null) {
                    return new Long(Long.MIN_VALUE);
                }
                return host.getConnectionUpTimeObject(System.currentTimeMillis());
            }
        }
        return this.getValueAt(n, n2);
    }

    public int mapColumnIDToModelIndex(int n) {
        switch (n) {
            case 1001: {
                return 0;
            }
            case 1002: {
                return 1;
            }
            case 1003: {
                return 2;
            }
            case 1010: {
                return 3;
            }
            case 1004: {
                return 4;
            }
            case 1005: {
                return 5;
            }
            case 1007: {
                return 6;
            }
            case 1008: {
                return 7;
            }
            case 1009: {
                return 8;
            }
        }
        return -1;
    }

    public boolean isColumnHideable(int n) {
        return n != 1001;
    }

    public static int[] getColumnIdArray() {
        int[] nArray = new int[]{1001, 1002, 1003, 1010, 1004, 1005, 1007, 1008, 1009};
        return nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class NetworkHostsListener
    implements NetworkHostsChangeListener {
        private NetworkHostsListener() {
        }

        public void networkHostChanged(int n) {
            NetworkTableModel.this.fireTableRowsUpdated(n, n);
        }

        public void networkHostAdded(int n) {
            NetworkTableModel.this.fireTableRowsInserted(n, n);
        }

        public void networkHostRemoved(int n) {
            NetworkTableModel.this.fireTableRowsDeleted(n, n);
        }
    }
}

