/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phex.common.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class DownloadPane
extends OptionsSettingsPane {
    private static final String WORKER_PER_DOWNLOAD_KEY = "WorkerPerDownload";
    private static final String MAX_TOTAL_WORKER_KEY = "TotalWorker";
    private static final String MAX_FAILED_CONNECTIONS_KEY = "MaxFailedConnections";
    private static final String PUSH_TIMEOUT_KEY = "PushTimeout";
    private static final String DOWNLOAD_SPLIT_VALUE = "DownloadSplitValue";
    private IntegerTextField totalWorkersTF;
    private IntegerTextField workerPerDownloadTF;
    private IntegerTextField pushTimeoutTF;
    private IntegerTextField maxFailedConnectionsInARowTF;
    private JCheckBox removeCompletedDownloadsChkbx;
    private JCheckBox isDownloadInitiallySplittedChkbx;
    private JComboBox splitTypeCbx;
    private JTextField splitValueTF;
    private JLabel splitTextPreLabel;
    private JLabel splitTextPostLabel;
    private JCheckBox enableHitSnoopingChkbx;

    public DownloadPane() {
        super("Download");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("GeneralDownloadSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString("TotalParallelDownloads") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.totalWorkersTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxTotalDownloadWorker), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.totalWorkersTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("ParallelDownloadsPerFile") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.workerPerDownloadTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxWorkerPerDownload), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.workerPerDownloadTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MaxFailedConnectionsInARow") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.maxFailedConnectionsInARowTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxFailedConnectionsInARow), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.maxFailedConnectionsInARowTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(PUSH_TIMEOUT_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.pushTimeoutTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mPushTransferTimeout / 1000), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.pushTimeoutTF, gridBagConstraints);
        this.removeCompletedDownloadsChkbx = new JCheckBox(Localizer.getString("AutoRemoveCompletedDownloads"), ServiceManager.sCfg.mDownloadAutoRemoveCompleted);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.removeCompletedDownloadsChkbx, gridBagConstraints);
        this.isDownloadInitiallySplittedChkbx = new JCheckBox(Localizer.getString("InitiallySplitSegments"));
        this.isDownloadInitiallySplittedChkbx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DownloadPane.this.refreshEnableState();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.isDownloadInitiallySplittedChkbx, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        String[] stringArray = new String[]{Localizer.getString("SplitBySize"), Localizer.getString("SplitByCount")};
        this.splitTypeCbx = new JComboBox<String>(stringArray);
        this.splitTypeCbx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DownloadPane.this.updateSplitTextLabel();
            }
        });
        GUIUtils.adjustComboBoxHeight(this.splitTypeCbx);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.splitTypeCbx, gridBagConstraints);
        this.splitTextPreLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.splitTextPreLabel, gridBagConstraints);
        this.splitValueTF = new IntegerTextField(3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.splitValueTF, gridBagConstraints);
        this.splitTextPostLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add((Component)this.splitTextPostLabel, gridBagConstraints);
        this.enableHitSnoopingChkbx = new JCheckBox(Localizer.getString("EnableHitSnooping"), ServiceManager.sCfg.enableHitSnooping);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.enableHitSnoopingChkbx, gridBagConstraints);
        this.initConfigValues();
        this.updateSplitTextLabel();
        this.refreshEnableState();
    }

    public void updateUI() {
        super.updateUI();
        GUIUtils.adjustComboBoxHeight(this.splitTypeCbx);
    }

    public void checkInput(HashMap hashMap) {
        Number number;
        String string;
        try {
            string = this.workerPerDownloadTF.getText();
            number = new Short(string);
            hashMap.put(WORKER_PER_DOWNLOAD_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.workerPerDownloadTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.totalWorkersTF.getText();
            number = new Short(string);
            hashMap.put(MAX_TOTAL_WORKER_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.totalWorkersTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.pushTimeoutTF.getText();
            number = new Integer(string);
            hashMap.put(PUSH_TIMEOUT_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.pushTimeoutTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.maxFailedConnectionsInARowTF.getText();
            number = new Short(string);
            hashMap.put(MAX_FAILED_CONNECTIONS_KEY, number);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxFailedConnectionsInARowTF);
            this.setInputValid(hashMap, false);
            return;
        }
        if (this.isDownloadInitiallySplittedChkbx.isSelected()) {
            try {
                string = this.splitValueTF.getText();
                number = new Integer(string);
                hashMap.put(DOWNLOAD_SPLIT_VALUE, number);
            }
            catch (NumberFormatException numberFormatException) {
                hashMap.put("NumberFormatError", this.splitValueTF);
                this.setInputValid(hashMap, false);
                return;
            }
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        int n;
        boolean bl;
        boolean bl2;
        Short s;
        short s2;
        Integer n2;
        int n3;
        Short s3;
        short s4;
        Short s5 = (Short)hashMap.get(MAX_TOTAL_WORKER_KEY);
        short s6 = s5;
        if (ServiceManager.sCfg.maxTotalDownloadWorker != s6) {
            ServiceManager.sCfg.maxTotalDownloadWorker = s6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxWorkerPerDownload != (s4 = (s3 = (Short)hashMap.get(WORKER_PER_DOWNLOAD_KEY)).shortValue())) {
            ServiceManager.sCfg.maxWorkerPerDownload = s4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mPushTransferTimeout != (n3 = (n2 = (Integer)hashMap.get(PUSH_TIMEOUT_KEY)).intValue())) {
            ServiceManager.sCfg.mPushTransferTimeout = n3 * 1000;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxFailedConnectionsInARow != (s2 = (s = (Short)hashMap.get(MAX_FAILED_CONNECTIONS_KEY)).shortValue())) {
            ServiceManager.sCfg.maxFailedConnectionsInARow = s2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mDownloadAutoRemoveCompleted != (bl2 = this.removeCompletedDownloadsChkbx.isSelected())) {
            ServiceManager.sCfg.mDownloadAutoRemoveCompleted = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.enableHitSnooping != (bl = this.enableHitSnoopingChkbx.isSelected())) {
            ServiceManager.sCfg.enableHitSnooping = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        Integer n4 = null;
        boolean bl3 = this.isDownloadInitiallySplittedChkbx.isSelected();
        if (bl3) {
            n = Localizer.getString("SplitBySize").equals(this.splitTypeCbx.getSelectedItem()) ? 1 : 2;
            n4 = (Integer)hashMap.get(DOWNLOAD_SPLIT_VALUE);
        } else {
            n = 0;
        }
        if (ServiceManager.sCfg.downloadSplitType != n) {
            ServiceManager.sCfg.downloadSplitType = (short)n;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (n4 != null && ServiceManager.sCfg.downloadSplitValue != n4) {
            ServiceManager.sCfg.downloadSplitValue = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void refreshEnableState() {
        boolean bl = this.isDownloadInitiallySplittedChkbx.isSelected();
        this.splitTypeCbx.setEnabled(bl);
        this.splitTextPreLabel.setEnabled(bl);
        this.splitTextPostLabel.setEnabled(bl);
        this.splitValueTF.setEnabled(bl);
    }

    private void initConfigValues() {
        short s = ServiceManager.sCfg.downloadSplitType;
        if (s == 0) {
            this.isDownloadInitiallySplittedChkbx.setSelected(false);
        } else if (s == 1) {
            this.isDownloadInitiallySplittedChkbx.setSelected(true);
            this.splitTypeCbx.setSelectedItem(Localizer.getString("SplitBySize"));
        } else if (s == 2) {
            this.isDownloadInitiallySplittedChkbx.setSelected(true);
            this.splitTypeCbx.setSelectedItem(Localizer.getString("SplitByCount"));
        }
        this.splitValueTF.setText(String.valueOf(ServiceManager.sCfg.downloadSplitValue));
    }

    private void updateSplitTextLabel() {
        if (Localizer.getString("SplitBySize").equals(this.splitTypeCbx.getSelectedItem())) {
            this.splitTextPreLabel.setText(Localizer.getString("SizePerSegment") + Localizer.getString("ColonSign") + " ");
            this.splitTextPostLabel.setText(Localizer.getString("MBToken"));
        } else {
            this.splitTextPreLabel.setText(Localizer.getString("NumberOfSegments") + Localizer.getString("ColonSign") + " ");
            this.splitTextPostLabel.setText("");
        }
    }
}

