/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.Keymap;
import phex.gui.common.GUIRegistry;
import phex.utils.Localizer;
import phex.xml.XJBGUISettings;
import phex.xml.XJBGUITab;
import phex.xml.XJBGUITable;

public final class GUIUtils {
    private GUIUtils() {
    }

    public static void assignKeymapToComboBoxEditor(Keymap keymap, JComboBox jComboBox) {
        ComboBoxUIChangeListener comboBoxUIChangeListener = new ComboBoxUIChangeListener(keymap, jComboBox);
        jComboBox.addPropertyChangeListener("UI", comboBoxUIChangeListener);
        ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
        JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
        jTextField.addPropertyChangeListener("UI", comboBoxUIChangeListener);
    }

    public static void setWindowLocationRelativeTo(Window window, Window window2) {
        Rectangle rectangle = window.getBounds();
        Dimension dimension = window2.getSize();
        Point point = window2.getLocation();
        int n = point.x + (dimension.width - rectangle.width >> 1);
        int n2 = point.y + (dimension.height - rectangle.height >> 1);
        Dimension dimension2 = window.getToolkit().getScreenSize();
        if (n2 + rectangle.height > dimension2.height) {
            n2 = dimension2.height - rectangle.height;
            int n3 = n = point.x < dimension2.width >> 1 ? point.x + dimension.width : point.x - rectangle.width;
        }
        if (n + rectangle.width > dimension2.width) {
            n = dimension2.width - rectangle.width;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        window.setLocation(n, n2);
    }

    public static XJBGUITable getXJBGUITableByIdentifier(XJBGUISettings xJBGUISettings, String string) {
        if (xJBGUISettings == null) {
            return null;
        }
        Iterator iterator = xJBGUISettings.getTableList().getTableList().iterator();
        while (iterator.hasNext()) {
            XJBGUITable xJBGUITable = (XJBGUITable)iterator.next();
            if (!xJBGUITable.getTableIdentifier().equals(string)) continue;
            return xJBGUITable;
        }
        return null;
    }

    public static XJBGUITab getXJBGUITabById(XJBGUISettings xJBGUISettings, int n) {
        if (xJBGUISettings == null) {
            return null;
        }
        Iterator iterator = xJBGUISettings.getTabList().iterator();
        while (iterator.hasNext()) {
            XJBGUITab xJBGUITab = (XJBGUITab)iterator.next();
            if (xJBGUITab.getTabID() != n) continue;
            return xJBGUITab;
        }
        return null;
    }

    public static void adjustComboBoxHeight(JComboBox jComboBox) {
        if (jComboBox == null) {
            return;
        }
        Font font = (Font)UIManager.getDefaults().get("ComboBox.font");
        if (jComboBox != null) {
            Dimension dimension = jComboBox.getUI().getPreferredSize(jComboBox);
            FontMetrics fontMetrics = jComboBox.getFontMetrics(font);
            int n = fontMetrics.getHeight() + fontMetrics.getDescent() + 2;
            jComboBox.setPreferredSize(new Dimension(dimension.width + 4, n));
        }
    }

    public static void adjustTableProgresssBarHeight(JTable jTable) {
        Font font = (Font)UIManager.getDefaults().get("ProgressBar.font");
        FontMetrics fontMetrics = jTable.getFontMetrics(font);
        int n = fontMetrics.getHeight() + fontMetrics.getDescent();
        jTable.setRowHeight(n);
    }

    public static void fireTableChanged(JTable jTable, AbstractTableModel abstractTableModel) {
        int n = jTable.getSelectedRowCount();
        int[] nArray = jTable.getSelectedRows();
        abstractTableModel.fireTableDataChanged();
        if (n > 0) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < jTable.getRowCount()) {
                    jTable.addRowSelectionInterval(nArray[n2], nArray[n2]);
                }
                ++n2;
            }
        }
    }

    public static void showErrorMessage(String string) {
        GUIUtils.showErrorMessage(GUIRegistry.getInstance().getMainFrame(), string);
    }

    public static void showErrorMessage(String string, String string2) {
        GUIUtils.showErrorMessage(null, string, string2);
    }

    public static void showErrorMessage(Component component, String string) {
        GUIUtils.showErrorMessage(component, string, Localizer.getString("Error"));
    }

    public static void showErrorMessage(Component component, String string, String string2) {
        if (component == null) {
            component = GUIRegistry.getInstance().getMainFrame();
        }
        JOptionPane.showMessageDialog(component, string, string2, 0);
    }

    private static class ComboBoxUIChangeListener
    implements PropertyChangeListener {
        private Keymap keymap;
        private JComboBox comboBox;

        public ComboBoxUIChangeListener(Keymap keymap, JComboBox jComboBox) {
            this.keymap = keymap;
            this.comboBox = jComboBox;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!propertyChangeEvent.getPropertyName().equals("UI")) {
                return;
            }
            if (propertyChangeEvent.getSource() == this.comboBox) {
                ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
                JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
                jTextField.addPropertyChangeListener("UI", this);
            } else {
                ComboBoxEditor comboBoxEditor = this.comboBox.getEditor();
                JTextField jTextField = (JTextField)comboBoxEditor.getEditorComponent();
                jTextField.setKeymap(this.keymap);
            }
        }
    }
}

