/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import phex.common.ServiceManager;
import phex.gui.common.GUIRegistry;
import phex.utils.Logger;

public class BaseFrame
extends JFrame {
    private static Vector sFrames = new Vector();

    public BaseFrame() {
        sFrames.addElement(this);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
        this.setBackground(Color.lightGray);
        Icon icon = GUIRegistry.getInstance().getIconFactory().getIcon("Phex16");
        if (icon != null) {
            this.setIconImage(((ImageIcon)icon).getImage());
        }
    }

    public void dispose() {
        try {
            sFrames.removeElement(this);
            super.dispose();
        }
        catch (Exception exception) {
            Logger.logWarning((short)32, exception);
        }
    }

    public void setFonts() {
        FontUIResource fontUIResource = new FontUIResource(ServiceManager.sCfg.mFontTable);
        UIManager.getDefaults().put("Table.font", fontUIResource);
        UIManager.getDefaults().put("TextPane.font", fontUIResource);
        UIManager.getDefaults().put("TextArea.font", fontUIResource);
        UIManager.getDefaults().put("TextField.font", fontUIResource);
        UIManager.getDefaults().put("PasswordField.font", fontUIResource);
        UIManager.getDefaults().put("EditorPane.font", fontUIResource);
        UIManager.getDefaults().put("ProgressBar.font", fontUIResource);
        FontUIResource fontUIResource2 = new FontUIResource(ServiceManager.sCfg.mFontMenu);
        UIManager.getDefaults().put("MenuBar.font", fontUIResource2);
        UIManager.getDefaults().put("Menu.font", fontUIResource2);
        UIManager.getDefaults().put("MenuItem.font", fontUIResource2);
        UIManager.getDefaults().put("PopupMenu.font", fontUIResource2);
        UIManager.getDefaults().put("CheckBoxMenuItem.font", fontUIResource2);
        UIManager.getDefaults().put("RadioButtonMenuItem.font", fontUIResource2);
        FontUIResource fontUIResource3 = new FontUIResource(ServiceManager.sCfg.mFontLabel);
        UIManager.getDefaults().put("CheckBox.font", fontUIResource3);
        UIManager.getDefaults().put("ComboBox.font", fontUIResource3);
        UIManager.getDefaults().put("Button.font", fontUIResource3);
        UIManager.getDefaults().put("Tree.font", fontUIResource3);
        UIManager.getDefaults().put("ScrollPane.font", fontUIResource3);
        UIManager.getDefaults().put("TabbedPane.font", fontUIResource3);
        UIManager.getDefaults().put("TitledBorder.font", fontUIResource3);
        UIManager.getDefaults().put("OptionPane.font", fontUIResource3);
        UIManager.getDefaults().put("ToolBar.font", fontUIResource3);
        UIManager.getDefaults().put("RadioButton.font", fontUIResource3);
        UIManager.getDefaults().put("ToggleButton.font", fontUIResource3);
        UIManager.getDefaults().put("ToolTip.font", fontUIResource3);
        UIManager.getDefaults().put("TableHeader.font", fontUIResource3);
        UIManager.getDefaults().put("Panel.font", fontUIResource3);
        UIManager.getDefaults().put("List.font", fontUIResource3);
        UIManager.getDefaults().put("ColorChooser.font", fontUIResource3);
        UIManager.getDefaults().put("Label.font", fontUIResource3);
        UIManager.getDefaults().put("Viewport.font", fontUIResource3);
        BaseFrame.updateComponentsUI();
    }

    public static void setAllFramesLookAndFeel(String string) {
        try {
            Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            BaseFrame.setAllFramesLookAndFeel((LookAndFeel)clazz.newInstance());
        }
        catch (Exception exception) {
            Logger.logError(exception);
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exception, "Error", 0);
        }
    }

    public static void setAllFramesLookAndFeel(LookAndFeel lookAndFeel) {
        try {
            if (lookAndFeel.getID().equals(UIManager.getLookAndFeel().getID())) {
                return;
            }
            UIManager.setLookAndFeel(lookAndFeel);
            BaseFrame.updateComponentsUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(GUIRegistry.getInstance().getMainFrame(), "Error loading Look & Feel " + exception, "Error", 0);
        }
    }

    public static void updateComponentsUI() {
        int n = 0;
        while (n < sFrames.size()) {
            BaseFrame baseFrame = (BaseFrame)sFrames.elementAt(n);
            SwingUtilities.updateComponentTreeUI(baseFrame);
            Window[] windowArray = baseFrame.getOwnedWindows();
            int n2 = 0;
            while (n2 < windowArray.length) {
                SwingUtilities.updateComponentTreeUI(windowArray[n2]);
                ++n2;
            }
            ++n;
        }
    }

    public static void centerWindow(Window window, Point point) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = window.getSize();
        Rectangle rectangle = new Rectangle((dimension.width - dimension2.width) / 2 + point.x, (dimension.height - dimension2.height) / 2 + point.y, dimension2.width, dimension2.height);
        window.setBounds(rectangle);
    }

    public static void centerAndSizeWindow(Window window, int n, int n2) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width * n / n2;
        int n4 = dimension.height * n / n2;
        Rectangle rectangle = new Rectangle((dimension.width - n3) / 2, (dimension.height - n4) / 2, n3, n4);
        window.setBounds(rectangle);
    }
}

